/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor.tree;

import ilog.views.IlvGraphic;
import ilog.views.css.model.AbstractNode;
import ilog.views.css.model.IlvNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.event.CSSChangeEvent;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.IlvEventMap;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.IlvSymbolEditorView;
import ilog.views.symbology.editor.event.ParameterListChangedEvent;
import ilog.views.symbology.editor.event.ParameterListChangedListener;
import ilog.views.symbology.editor.event.SelectionChangedEvent;
import ilog.views.symbology.editor.event.SelectionChangedListener;
import ilog.views.symbology.editor.event.SymbolChangedEvent;
import ilog.views.symbology.editor.event.SymbolChangedListener;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.tree.IlvSymbolTreeRoot;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.java2d.internal.IlvBufferedImageUtil;
import ilog.views.util.swing.context.ComponentAction;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextEvent;
import ilog.views.util.swing.context.ComponentContextListener;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class IlvSymbolTree
extends JTree {
    private static final String a = "Symbol Tree Object";
    public static final DataFlavor SYMBOL_TREE_OBJECT_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "Symbol Tree Object");
    private IlvSymbolEditorDocument b;
    private SymbolTreeContextListener c;
    private DocumentListener d;
    private boolean e;
    private HashMap f = new HashMap();
    private ResourceBundle g;
    private boolean h;
    private IlvRule i;
    private Object j;
    private boolean k;
    private Font l;
    private Font m;

    public IlvSymbolTree() {
        this(false);
    }

    public IlvSymbolTree(boolean bl) {
        super(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.k = bl;
        this.g = IlvResourceUtil.getBundle("ilog.views.symbology.editor.tree.tree", IlvLocaleUtil.getCurrentLocale(), IlvSymbolTree.class.getClassLoader());
        this.m = this.getFont();
        this.l = this.m.deriveFont(1, this.m.getSize());
        String string = "none";
        this.getInputMap().put(KeyStroke.getKeyStroke(88, 2), string);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), string);
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), string);
        SymbolTreeRenderer symbolTreeRenderer = new SymbolTreeRenderer();
        this.setCellRenderer(symbolTreeRenderer);
        this.setCellEditor(new SymbolTreeEditor(this, symbolTreeRenderer));
        this.setRowHeight(0);
        if (!bl) {
            this.c = new SymbolTreeContextListener();
            this.addTreeSelectionListener(new SymbolTreeSelectionListener());
            this.d = new DocumentListener();
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, new TreeDragGestureListener());
            new DropTarget(this, new TreeDropTargetListener());
        }
    }

    @Override
    public boolean isPathEditable(TreePath treePath) {
        return !this.h;
    }

    protected void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void setDocument(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
        if (this.b != ilvSymbolEditorDocument) {
            if (this.b != null && this.d != null) {
                this.b.removeSelectionChangedListener(this.d);
                this.b.getRuleModel().removeStyleChangeListener(this.d);
                this.b.removeSymbolChangedListener(this.d);
                this.b.removeParameterListChangedListener(this.d);
            }
            this.b = ilvSymbolEditorDocument;
            this.a();
            if (this.b != null && this.d != null) {
                this.b.addSelectionChangedListener(this.d);
                this.b.getRuleModel().addStyleChangeListener(this.d);
                this.b.addSymbolChangedListener(this.d);
                this.b.addParameterListChangedListener(this.d);
            }
        }
    }

    public IlvSymbolEditorDocument getDocument() {
        return this.b;
    }

    private void a() {
        if (this.b != null) {
            this.setModel(new TreeModelAdapter(new IlvSymbolTreeRoot(this.b, this.k)));
            this.a(((IlvNode)this.getModel().getRoot()).getUserObject(), 2);
        } else {
            this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
        this.c();
    }

    private void b() {
        boolean bl = this.e;
        try {
            this.e = true;
            Object[] objectArray = this.d();
            this.setModel(new TreeModelAdapter(new IlvSymbolTreeRoot(this.b, this.k)));
            this.a(objectArray);
            this.c();
        }
        finally {
            this.e = bl;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.c != null) {
            ComponentContextManager.getSingleton().addComponentContextListener(this, this.c);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.c != null) {
            ComponentContextManager.getSingleton().removeComponentContextListener(this, this.c);
        }
    }

    public IlvRule getSelectedParentRule() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1) {
            AbstractNode abstractNode = (AbstractNode)treePathArray[0].getLastPathComponent();
            Object object = abstractNode.getUserObject();
            IlvRule ilvRule = null;
            if (abstractNode.getUserObject() instanceof IlvRule) {
                ilvRule = (IlvRule)abstractNode.getUserObject();
            } else if (object instanceof IlvPaletteSymbol || object.equals(IlvSymbolTreeRoot.elementsNode)) {
                ilvRule = this.getDocument().getToplevelRule();
            }
            return ilvRule;
        }
        return null;
    }

    private void c() {
        List list;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        if (this.getDocument() != null && (list = this.getDocument().getSelection()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                TreePath treePath = this.a(list.get(i));
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
        }
        this.setSelectionPaths(arrayList.toArray(new TreePath[0]));
    }

    private TreePath a(Object object) {
        return this.a(new TreePath(this.getModel().getRoot()), object);
    }

    private TreePath a(TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        if (((AbstractNode)treePath.getLastPathComponent()).getUserObject() == object) {
            return treePath;
        }
        for (int i = 0; i < this.getModel().getChildCount(object2); ++i) {
            Object object3 = this.getModel().getChild(object2, i);
            TreePath treePath2 = this.a(treePath.pathByAddingChild(object3), object);
            if (treePath2 == null) continue;
            return treePath2;
        }
        return null;
    }

    private void a(Object object, int n) {
        TreePath treePath = this.a(object);
        if (treePath != null) {
            Object object2;
            for (object2 = treePath.getParentPath(); object2 != null; object2 = ((TreePath)object2).getParentPath()) {
                this.setExpandedState((TreePath)object2, true);
            }
            this.setExpandedState(treePath, true);
            if (n < 0 || --n > 0) {
                object2 = treePath.getLastPathComponent();
                for (int i = 0; i < this.getModel().getChildCount(object2); ++i) {
                    this.a(((IlvNode)this.getModel().getChild(object2, i)).getUserObject(), n);
                }
            }
        }
    }

    private Object[] d() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isExpanded(i)) continue;
            AbstractNode abstractNode = (AbstractNode)this.getPathForRow(i).getLastPathComponent();
            arrayList.add(abstractNode.getUserObject());
        }
        return arrayList.toArray();
    }

    private void a(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.a(objectArray[i], 0);
        }
    }

    private Icon a(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3, BufferedImage bufferedImage, ImageIcon imageIcon4) {
        IlvSymbolTreeRoot ilvSymbolTreeRoot;
        String string;
        if (jTree.getModel().getRoot() instanceof IlvSymbolTreeRoot && object instanceof IlvNode && (string = (ilvSymbolTreeRoot = (IlvSymbolTreeRoot)jTree.getModel().getRoot()).getIconKey((IlvNode)object)).length() > 0) {
            Object object2;
            Icon icon = (Icon)this.f.get(string);
            if (icon == null) {
                object2 = this.g.getString("SymbolEditor.Tree." + string);
                try {
                    icon = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, (String)object2));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                this.f.put(string, icon);
            }
            if (bl || bl2 || bl3) {
                IlvBufferedImageUtil.clearRect(bufferedImage, 0, 0, 20, 20);
                object2 = bufferedImage.createGraphics();
                icon.paintIcon(this, (Graphics)object2, (20 - icon.getIconWidth()) / 2, 17 - icon.getIconHeight());
                if (bl) {
                    ((Graphics)object2).drawImage(imageIcon.getImage(), 0, 0, this);
                }
                if (bl2) {
                    ((Graphics)object2).drawImage(imageIcon2.getImage(), 0, 0, this);
                }
                if (bl3) {
                    ((Graphics)object2).drawImage(imageIcon3.getImage(), 0, 0, this);
                }
                imageIcon4.setImage(bufferedImage);
                return imageIcon4;
            }
            return icon;
        }
        return null;
    }

    private class TreeDropTargetListener
    implements DropTargetListener {
        private TreeDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.getTransferable().isDataFlavorSupported(SYMBOL_TREE_OBJECT_FLAVOR)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            IlvRule ilvRule = null;
            Object object = null;
            TreePath treePath = IlvSymbolTree.this.getPathForLocation(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
            if (treePath != null) {
                AbstractNode abstractNode = (AbstractNode)treePath.getLastPathComponent();
                Object object2 = abstractNode.getUserObject();
                if (object2 instanceof IlvRule) {
                    IlvGraphic ilvGraphic = IlvSymbolTree.this.getDocument().getRuleModel().getGraphicFromRule((IlvRule)object2);
                    if (ilvGraphic instanceof IlvCompositeGraphic) {
                        ilvRule = (IlvRule)object2;
                        object = abstractNode;
                    } else if (ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic) {
                        if ((ilvGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag()) == IlvSymbolTree.this.getDocument().getToplevelGraphic()) {
                            ilvRule = IlvSymbolTree.this.getDocument().getToplevelRule();
                            object = ((IlvSymbolTreeRoot)IlvSymbolTree.this.getModel().getRoot()).a();
                        } else {
                            ilvRule = IlvSymbolTree.this.getDocument().getRuleModel().getMainRuleFromGraphic(ilvGraphic);
                            object = IlvSymbolTree.this.a((Object)ilvRule).getLastPathComponent();
                        }
                    }
                } else if (object2 instanceof IlvPaletteSymbol || object2.equals(IlvSymbolTreeRoot.elementsNode)) {
                    ilvRule = IlvSymbolTree.this.getDocument().getToplevelRule();
                    object = ((IlvSymbolTreeRoot)IlvSymbolTree.this.getModel().getRoot()).a();
                }
            }
            if (ilvRule != null && IlvSymbolTree.this.getDocument().canReparent(ilvRule)) {
                IlvSymbolTree.this.i = ilvRule;
                IlvSymbolTree.this.j = object;
                IlvSymbolTree.this.repaint();
            } else {
                IlvSymbolTree.this.i = null;
                IlvSymbolTree.this.j = null;
                IlvSymbolTree.this.repaint();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            IlvSymbolTree.this.i = null;
            IlvSymbolTree.this.j = null;
            IlvSymbolTree.this.repaint();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (IlvSymbolTree.this.i != null) {
                IlvSymbolTree.this.getDocument().reparent(IlvSymbolTree.this.i);
                IlvSymbolTree.this.i = null;
                IlvSymbolTree.this.j = null;
                IlvSymbolTree.this.repaint();
            }
        }
    }

    private class TreeDragGestureListener
    implements DragGestureListener,
    DragSourceListener,
    Transferable {
        private TreeDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (IlvSymbolTree.this.getDocument() != null && IlvSymbolTree.this.getDocument().canReparent(null)) {
                IlvSymbolTree.this.h = true;
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, this, this);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            IlvSymbolTree.this.h = false;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{SYMBOL_TREE_OBJECT_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == SYMBOL_TREE_OBJECT_FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return null;
        }
    }

    private class SymbolTreeEditor
    extends DefaultTreeCellEditor {
        public SymbolTreeEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            if (object instanceof IlvRule) {
                IlvGraphic ilvGraphic;
                IlvRule ilvRule = (IlvRule)object;
                if (IlvSymbolTree.this.b.getRuleModel() != null && (ilvGraphic = IlvSymbolTree.this.b.getRuleModel().getGraphicFromRule(ilvRule)) != null) {
                    Object object2;
                    IlvEventMap ilvEventMap;
                    int n2 = SymbolEditorUtilities.getCompositeChildIndex(ilvGraphic);
                    if (n2 == 0) {
                        bl4 = true;
                    }
                    if (n2 > -1 && !(ilvEventMap = ((IlvCompositeGraphic)(object2 = SymbolEditorUtilities.getComposite(ilvGraphic))).getEventMaps(n2)).isEmpty()) {
                        bl5 = true;
                    }
                    object2 = null;
                    if (ilvGraphic.getName().startsWith("port_")) {
                        bl6 = true;
                        if (ilvGraphic.getName().startsWith("port_inout_")) {
                            object2 = ilvGraphic.getName().substring(11);
                        } else if (ilvGraphic.getName().startsWith("port_in_")) {
                            object2 = ilvGraphic.getName().substring(8);
                        } else if (ilvGraphic.getName().startsWith("port_out_")) {
                            object2 = ilvGraphic.getName().substring(9);
                        }
                        ((DefaultTreeCellEditor.DefaultTextField)this.editingComponent).setText((String)object2);
                    }
                }
            }
            this.editingIcon = IlvSymbolTree.this.a(jTree, object, false, false, false, null, null, null, null, null);
            return component;
        }
    }

    private class SymbolTreeRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon a = null;
        private ImageIcon b = null;
        private ImageIcon c = null;
        private ImageIcon d = null;
        private ImageIcon e = null;
        private ImageIcon f = null;
        private BufferedImage g = new BufferedImage(20, 20, 2);
        private ImageIcon h = new ImageIcon();
        private boolean i;

        public SymbolTreeRenderer() {
            try {
                this.a = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, IlvSymbolTree.this.g.getString("SymbolEditor.Tree.BaseIcon")));
                this.b = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, IlvSymbolTree.this.g.getString("SymbolEditor.Tree.InteractorIcon")));
                this.d = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, IlvSymbolTree.this.g.getString("SymbolEditor.Tree.PortInIcon")));
                this.e = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, IlvSymbolTree.this.g.getString("SymbolEditor.Tree.PortOutIcon")));
                this.f = new ImageIcon(IlvImageUtil.getImageFromFile(IlvSymbolTree.class, IlvSymbolTree.this.g.getString("SymbolEditor.Tree.PortInOutIcon")));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            Object object3;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jLabel.setFont(IlvSymbolTree.this.m);
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            if (object instanceof IlvRule && !SymbolEditorUtilities.hasCondition((IlvRule)(object3 = (IlvRule)object)) && IlvSymbolTree.this.b != null && IlvSymbolTree.this.b.getRuleModel() != null && (object2 = IlvSymbolTree.this.b.getRuleModel().getGraphicFromRule((IlvRule)object3)) != null) {
                Object object4;
                IlvEventMap ilvEventMap;
                int n2 = SymbolEditorUtilities.getCompositeChildIndex((IlvGraphic)object2);
                if (n2 == 0) {
                    bl5 = true;
                }
                if (n2 > -1 && !(ilvEventMap = ((IlvCompositeGraphic)(object4 = SymbolEditorUtilities.getComposite((IlvGraphic)object2))).getEventMaps(n2)).isEmpty()) {
                    bl6 = true;
                }
                if (((IlvGraphic)object2).getName().startsWith("port_")) {
                    bl7 = true;
                    object4 = null;
                    if (((IlvGraphic)object2).getName().startsWith("port_inout_")) {
                        this.c = this.f;
                        object4 = ((IlvGraphic)object2).getName().substring(11);
                    } else if (((IlvGraphic)object2).getName().startsWith("port_in_")) {
                        this.c = this.d;
                        object4 = ((IlvGraphic)object2).getName().substring(8);
                    } else if (((IlvGraphic)object2).getName().startsWith("port_out_")) {
                        this.c = this.e;
                        object4 = ((IlvGraphic)object2).getName().substring(9);
                    }
                    jLabel.setText((String)object4);
                }
            }
            object3 = IlvSymbolTree.this.a(jTree, object, bl5, bl6, bl7, this.a, this.b, this.c, this.g, this.h);
            jLabel.setIcon((Icon)object3);
            this.i = object == IlvSymbolTree.this.j;
            this.setEnabled(true);
            if (IlvSymbolTree.this.k) {
                Object object5;
                object2 = null;
                if (object instanceof IlvRule) {
                    object2 = (IlvRule)object;
                } else if (object instanceof AbstractNode && (object5 = ((AbstractNode)object).getUserObject()).equals(IlvSymbolTreeRoot.elementsNode)) {
                    object2 = IlvSymbolTree.this.getDocument().getToplevelRule();
                }
                if (object2 == null || !IlvSymbolTree.this.getDocument().canReparent((IlvRule)object2)) {
                    this.setEnabled(false);
                }
            }
            return jLabel;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.i) {
                Color color = this.getBorderSelectionColor();
                graphics.setColor(color);
                graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private class DocumentListener
    implements SelectionChangedListener,
    CSSChangeListener,
    SymbolChangedListener,
    ParameterListChangedListener {
        boolean a;

        private DocumentListener() {
        }

        @Override
        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (IlvSymbolTree.this.e || IlvSymbolTree.this.getDocument() == null) {
                return;
            }
            try {
                IlvSymbolTree.this.e = true;
                IlvSymbolTree.this.c();
            }
            finally {
                IlvSymbolTree.this.e = false;
            }
        }

        @Override
        public void refresh() {
        }

        @Override
        public void styleChange(CSSChangeEvent cSSChangeEvent) {
            if (!cSSChangeEvent.isAdjusting() || cSSChangeEvent.getMode() == CSSChangeEvent.ADJUSTMENT_END) {
                if (!IlvSymbolTree.this.getDocument().getRuleModel().isDragging()) {
                    IlvSymbolTree.this.b();
                }
                if (this.a) {
                    IlvSymbolTree.this.expandPath(IlvSymbolTree.this.getSelectionPath());
                }
                this.a = false;
            } else if (cSSChangeEvent.getMode() == CSSChangeEvent.ADD) {
                IlvRule ilvRule = cSSChangeEvent.getRule();
                String string = ilvRule.getSelector().getID();
                if (string == null) {
                    return;
                }
                if (string.startsWith("pushAction") && cSSChangeEvent.getDeclarations() == null) {
                    this.a = true;
                }
            }
        }

        @Override
        public void symbolChanged(SymbolChangedEvent symbolChangedEvent) {
            IlvSymbolTree.this.b();
        }

        @Override
        public void parameterAdded(ParameterListChangedEvent parameterListChangedEvent) {
            IlvSymbolTree.this.b();
        }

        @Override
        public void parameterRemoved(ParameterListChangedEvent parameterListChangedEvent) {
            IlvSymbolTree.this.b();
        }

        @Override
        public void parametersMoved(ParameterListChangedEvent parameterListChangedEvent) {
            IlvSymbolTree.this.b();
        }
    }

    private class SymbolTreeSelectionListener
    implements TreeSelectionListener {
        private SymbolTreeSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (IlvSymbolTree.this.e || IlvSymbolTree.this.getDocument() == null) {
                return;
            }
            try {
                Object object;
                IlvSymbolTree.this.e = true;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                TreePath[] treePathArray = IlvSymbolTree.this.getSelectionPaths();
                if (treePathArray != null) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        object = (AbstractNode)treePathArray[i].getLastPathComponent();
                        arrayList.add(((AbstractNode)object).getUserObject());
                    }
                }
                IlvSymbolTree.this.getDocument().setSelection(arrayList);
                ComponentContextManager componentContextManager = ComponentContextManager.getSingleton();
                object = componentContextManager.getContext(IlvSymbolTree.this.getRootPane());
                if (object != null) {
                    ComponentAction.updateActions(componentContextManager.getRoot(IlvSymbolTree.this.getRootPane()), ((ComponentContext)object).getTarget());
                }
            }
            finally {
                IlvSymbolTree.this.e = false;
            }
        }
    }

    private class TreeModelAdapter
    implements TreeModel {
        private IlvNode a;

        public TreeModelAdapter(IlvNode ilvNode) {
            this.a = ilvNode;
        }

        @Override
        public Object getRoot() {
            return this.a;
        }

        @Override
        public Object getChild(Object object, int n) {
            return ((IlvNode)object).getChildAt(n);
        }

        @Override
        public int getChildCount(Object object) {
            return ((IlvNode)object).getChildCount();
        }

        @Override
        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
            IlvSymbolTree.this.valueForPathChanged(treePath, object);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return ((IlvNode)object).getIndex((IlvNode)object2);
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }
    }

    private class SymbolTreeContextListener
    implements ComponentContextListener {
        private SymbolTreeContextListener() {
        }

        @Override
        public void targetChanged(ComponentContextEvent componentContextEvent) {
            if (componentContextEvent.getNewTarget() instanceof IlvSymbolEditorView) {
                IlvSymbolTree.this.setDocument(((IlvSymbolEditorView)componentContextEvent.getNewTarget()).getDocument());
            } else {
                IlvSymbolTree.this.setDocument(null);
            }
        }
    }
}

