/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes;

import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameterValueSet;
import ilog.views.symbology.palettes.IlvPaletteXMLConstants;
import ilog.views.symbology.palettes.internal.IlvPaletteUtil;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class IlvPaletteXMLReader
implements IlvPaletteXMLConstants {
    private IlvPalette a = null;

    public IlvPaletteXMLReader(IlvPalette ilvPalette) {
        this.a = ilvPalette;
    }

    public void read(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
        }
        documentBuilder.setErrorHandler(new XMLParsingErrorHandler(System.err));
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
            if (document != null) {
                this.a(document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                NamedNodeMap namedNodeMap = ((DocumentType)node).getEntities();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Entity entity = (Entity)namedNodeMap.item(i);
                    this.a(entity);
                }
                break;
            }
            case 1: {
                this.a((Element)node);
                break;
            }
            default: {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.a(nodeList.item(i));
                }
            }
        }
    }

    private void a(Element element) {
        String string = element.getNodeName();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (IlvPaletteXMLConstants.PALETTE_ELEMENT.equals(string)) {
            Node node;
            int n;
            String string2 = element.getAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE);
            if ("".equals(string2)) {
                string2 = null;
            }
            this.a.setIconResourceName(string2);
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (!(node instanceof Element)) continue;
                this.b((Element)node);
            }
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (!(node instanceof Element)) continue;
                this.a((Element)node, (IlvPaletteCategory)null);
            }
        } else {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                this.a((Element)node);
            }
        }
    }

    private void b(Element element) {
        String string = element.getNodeName();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (IlvPaletteXMLConstants.VALUESET_ELEMENT.equals(string)) {
            String string2 = element.getAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE);
            IlvPaletteSymbolParameterValueSet ilvPaletteSymbolParameterValueSet = new IlvPaletteSymbolParameterValueSet(string2);
            String string3 = element.getAttribute(IlvPaletteXMLConstants.TYPE_ATTRIBUTE);
            if ("".equals(string3)) {
                string3 = null;
            }
            ilvPaletteSymbolParameterValueSet.setType(string3);
            Class clazz = IlvPaletteUtil.getClass(string3);
            String string4 = element.getAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE);
            this.a(ilvPaletteSymbolParameterValueSet, string4);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                this.a((Element)node, ilvPaletteSymbolParameterValueSet, clazz);
            }
            this.a.addValueSet(ilvPaletteSymbolParameterValueSet, false);
        } else if (!(IlvPaletteXMLConstants.VALUE_ELEMENT.equals(string) || IlvPaletteXMLConstants.CATEGORY_ELEMENT.equals(string) || IlvPaletteXMLConstants.SYMBOL_ELEMENT.equals(string))) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                this.b((Element)node);
            }
        }
    }

    private void a(IlvPaletteSymbolParameterValueSet ilvPaletteSymbolParameterValueSet, String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f:", false);
        int n = 32;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("i")) {
                n = 105;
                continue;
            }
            if (string2.startsWith("d")) {
                n = 100;
                continue;
            }
            if (string2.startsWith("f")) {
                n = 102;
                continue;
            }
            try {
                switch (n) {
                    case 102: {
                        float f = Float.parseFloat(string2);
                        ilvPaletteSymbolParameterValueSet.addValue(f);
                        break;
                    }
                    case 100: {
                        double d = Double.parseDouble(string2);
                        ilvPaletteSymbolParameterValueSet.addValue(d);
                        break;
                    }
                    default: {
                        int n2 = Integer.parseInt(string2);
                        ilvPaletteSymbolParameterValueSet.addValue(n2);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    private void a(Element element, IlvPaletteSymbolParameterValueSet ilvPaletteSymbolParameterValueSet, Class clazz) {
        String string = element.getNodeName();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (IlvPaletteXMLConstants.VALUE_ELEMENT.equals(string)) {
            String string2 = this.c(element);
            Object object = this.a(string2, clazz);
            ilvPaletteSymbolParameterValueSet.addValue(object);
        }
    }

    private void a(Element element, IlvPaletteCategory ilvPaletteCategory) {
        block19: {
            String string = element.getNodeName();
            if (string != null) {
                string = string.toLowerCase(Locale.ENGLISH);
            }
            if (IlvPaletteXMLConstants.VALUE_ELEMENT.equals(string) || IlvPaletteXMLConstants.VALUESET_ELEMENT.equals(string)) break block19;
            if (IlvPaletteXMLConstants.CATEGORY_ELEMENT.equals(string)) {
                IlvPaletteCategory ilvPaletteCategory2;
                String string2 = element.getAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE);
                if (ilvPaletteCategory == null) {
                    ilvPaletteCategory2 = new IlvPaletteCategory(string2);
                    this.a.setRoot(ilvPaletteCategory2);
                } else {
                    ilvPaletteCategory2 = this.a.addCategory(ilvPaletteCategory, string2);
                }
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    this.a((Element)node, ilvPaletteCategory2);
                }
            } else if (IlvPaletteXMLConstants.SYMBOL_ELEMENT.equals(string)) {
                if (ilvPaletteCategory == null) {
                    throw new RuntimeException("symbol without parent category");
                }
                String string3 = element.getAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE);
                String string4 = element.getAttribute(IlvPaletteXMLConstants.VERSION_ATTRIBUTE);
                String string5 = element.getAttribute(IlvPaletteXMLConstants.CSS_ATTRIBUTE);
                String string6 = element.getAttribute(IlvPaletteXMLConstants.CLASSNAME_ATTRIBUTE);
                String string7 = element.getAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE);
                if ("".equals(string5)) {
                    string5 = null;
                }
                if ("".equals(string6)) {
                    string6 = null;
                }
                if ("".equals(string7)) {
                    string7 = null;
                }
                if ("".equals(string4)) {
                    string4 = null;
                }
                IlvPaletteSymbol ilvPaletteSymbol = this.a.addSymbol(ilvPaletteCategory, string3);
                if (string5 != null) {
                    ilvPaletteSymbol.setCSSResourceName(string5);
                }
                if (string6 != null) {
                    ilvPaletteSymbol.setClassName(string6);
                }
                if (string7 != null) {
                    ilvPaletteSymbol.setIconResourceName(string7);
                }
                if (string4 != null) {
                    ilvPaletteSymbol.setVersion(string4);
                }
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    this.a((Element)node, ilvPaletteSymbol);
                }
            } else {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    this.a((Element)node, ilvPaletteCategory);
                }
            }
        }
    }

    private void a(Element element, IlvPaletteSymbol ilvPaletteSymbol) {
        String string = element.getNodeName();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (IlvPaletteXMLConstants.PARAM_ELEMENT.equals(string)) {
            String string2 = element.getAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE);
            String string3 = element.getAttribute(IlvPaletteXMLConstants.VALUE_ATTRIBUTE);
            String string4 = element.getAttribute(IlvPaletteXMLConstants.TYPE_ATTRIBUTE);
            String string5 = element.getAttribute(IlvPaletteXMLConstants.EDITOR_ATTRIBUTE);
            String string6 = element.getAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE);
            String string7 = element.getAttribute(IlvPaletteXMLConstants.READONLY_ATTRIBUTE);
            String string8 = element.getAttribute(IlvPaletteXMLConstants.VISIBLE_ATTRIBUTE);
            if ("".equals(string4)) {
                string4 = null;
            }
            if ("".equals(string5)) {
                string5 = null;
            }
            if ("".equals(string6)) {
                string6 = null;
            }
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = new IlvPaletteSymbolParameter(string2, null, string4, string5);
            ilvPaletteSymbol.addParameter(ilvPaletteSymbolParameter);
            IlvPaletteUtil.setValueAsLocaleIndependentString(ilvPaletteSymbolParameter, string3);
            if (string6 != null) {
                ilvPaletteSymbolParameter.setValueSet(this.a.getValueSet(string6));
            }
            if ("true".equals(string7)) {
                ilvPaletteSymbolParameter.setReadOnly(true);
            } else {
                ilvPaletteSymbolParameter.setReadOnly(false);
            }
            if ("false".equals(string8)) {
                ilvPaletteSymbolParameter.setVisible(false);
            } else {
                ilvPaletteSymbolParameter.setVisible(true);
            }
        } else if (IlvPaletteXMLConstants.RESOURCE_ELEMENT.equals(string)) {
            String string9 = this.c(element);
            if (string9 != null) {
                ilvPaletteSymbol.addResource(string9);
            }
        } else {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                this.a((Element)node, ilvPaletteSymbol);
            }
        }
    }

    private String c(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        Text text = (Text)nodeList.item(0);
        try {
            return text.getData();
        }
        catch (DOMException dOMException) {
            return "";
        }
    }

    private Object a(String string, Class clazz) {
        if (string == null) {
            if (clazz == String.class) {
                return "";
            }
        }
        if ("@|emptyString".equals(string)) {
            if (clazz == String.class) {
                return "";
            }
        }
        if (clazz == null) {
            return string;
        }
        try {
            return IlvConvert.convert(string, clazz);
        }
        catch (IlvConvertException ilvConvertException) {
            return string;
        }
    }

    static final class XMLParsingErrorHandler
    implements ErrorHandler {
        private PrintStream a;

        XMLParsingErrorHandler(PrintStream printStream) {
            this.a = printStream;
        }

        private String a(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.a.println("Warning: " + this.a(sAXParseException));
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.a(sAXParseException);
            throw new SAXException(string);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.a(sAXParseException);
            throw new SAXException(string);
        }
    }
}

