/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.text.internal.IlvFormatUtil;
import ilog.views.util.text.internal.IlvICUNumberFormatFactory;
import java.beans.PropertyEditorSupport;

public class IlvFloatPropertyEditor
extends PropertyEditorSupport
implements IlvInternationalizedPropertyEditor {
    private static final String a = "Infinity";
    private static final String b = "-Infinity";
    private static final String c = "NaN";
    private static final Float d = new Float(Float.POSITIVE_INFINITY);
    private static final Float e = new Float(Float.NEGATIVE_INFINITY);
    private static final Float f = new Float(Float.NaN);
    private final ULocale g;
    private boolean h = false;
    private int i = 10;
    private static final Float j = new Float(0.0f);
    private static final Float k = new Float(1.0f);

    public IlvFloatPropertyEditor() {
        this(IlvLocaleUtil.getCurrentULocale());
    }

    public IlvFloatPropertyEditor(ULocale uLocale) {
        this.g = uLocale;
    }

    @Override
    public String getJavaInitializationString() {
        float f = ((Float)this.getValue()).floatValue();
        if (Double.isNaN(f)) {
            return "Float.NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Float.POSITIVE_INFINITY";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "Float.NEGATIVE_INFINITY";
        }
        return Float.toString(f) + "F";
    }

    @Override
    public void setAsText(String string) {
        this.a(string, false);
    }

    @Override
    public void setAsLocalizedText(String string) throws IllegalArgumentException {
        this.a(string, true);
    }

    @Override
    public String getAsText() {
        return this.a(false);
    }

    @Override
    public String getAsLocalizedText() {
        return this.a(true);
    }

    @Override
    public String[] getValuesAsLocalizedText() {
        return null;
    }

    private void a(String string, boolean bl) {
        if ("0" == string) {
            this.setValue(j);
            return;
        }
        if ("1" == string) {
            this.setValue(k);
            return;
        }
        if (a.equals(string)) {
            this.setValue(d);
        } else if (b.equals(string)) {
            this.setValue(e);
        } else if (c.equals(string)) {
            this.setValue(f);
        } else if (bl) {
            NumberFormat numberFormat = IlvICUNumberFormatFactory.getInstance(this.g);
            try {
                this.setValue(Float.valueOf(IlvFormatUtil.parseFully(numberFormat, string).floatValue()));
            }
            catch (Exception exception) {
                if (numberFormat instanceof DecimalFormat && !((DecimalFormat)numberFormat).isScientificNotation()) {
                    ((DecimalFormat)numberFormat).setScientificNotation(true);
                    numberFormat.setGroupingUsed(this.h);
                    try {
                        this.setValue(Float.valueOf(IlvFormatUtil.parseFully(numberFormat, string).floatValue()));
                    }
                    catch (Exception exception2) {
                        throw new IllegalArgumentException("invalid float:" + string);
                    }
                }
                throw new IllegalArgumentException("invalid float:" + string);
            }
        } else {
            this.setValue(Float.valueOf(string));
        }
    }

    private String a(boolean bl) {
        Object object = this.getValue();
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            if (d.equals(object)) {
                return a;
            }
            if (e.equals(object)) {
                return b;
            }
            if (IlvFloatPropertyEditor.f.equals(object)) {
                return c;
            }
            if (bl) {
                NumberFormat numberFormat = IlvICUNumberFormatFactory.createInstance(this.g);
                numberFormat.setGroupingUsed(this.h);
                String string = numberFormat.format((double)f);
                if (string.length() > this.i && numberFormat instanceof DecimalFormat && !((DecimalFormat)numberFormat).isScientificNotation()) {
                    ((DecimalFormat)numberFormat).setScientificNotation(true);
                    numberFormat.setGroupingUsed(this.h);
                    string = numberFormat.format((double)f);
                }
                return string;
            }
            return Float.toString(f);
        }
        return "0";
    }

    public void setGroupingUsed(boolean bl) {
        this.h = bl;
    }

    public boolean isGroupingUsed() {
        return this.h;
    }

    public void setMinTextLengthForceingScientificNotation(int n) {
        this.i = n;
    }

    public int getMinTextLengthForceingScientificNotation() {
        return this.i;
    }
}

