/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.calendar.plaf;

import ilog.views.util.swing.calendar.IlvCalendarCellRenderer;
import ilog.views.util.swing.calendar.IlvCalendarHeaderRenderer;
import ilog.views.util.swing.calendar.IlvCalendarModel;
import ilog.views.util.swing.calendar.IlvJCalendarPanel;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.swing.calendar.plaf.CalendarPanelUI;
import ilog.views.util.time.IlvCalendarUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicCalendarPanelUI
extends CalendarPanelUI {
    protected IlvJCalendarPanel calendarPanel;
    protected CellRendererPane rendererPane;
    protected PropertyChangeListener propertyChangeListener;
    protected CalendarModelListener modelListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseListener;
    private static HashSet a = new HashSet();
    private static HashSet b;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCalendarPanelUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.calendarPanel = (IlvJCalendarPanel)jComponent;
        this.rendererPane = new CellRendererPane();
        this.calendarPanel.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.calendarPanel.remove(this.rendererPane);
        this.rendererPane = null;
        this.calendarPanel = null;
    }

    protected void installDefaults() {
        block39: {
            block38: {
                Font font;
                block37: {
                    block36: {
                        Color color;
                        block35: {
                            block34: {
                                Color color2;
                                block33: {
                                    block32: {
                                        Color color3;
                                        block31: {
                                            block30: {
                                                Color color4;
                                                block29: {
                                                    block28: {
                                                        Font font2;
                                                        block27: {
                                                            block26: {
                                                                Color color5;
                                                                block25: {
                                                                    block24: {
                                                                        Color color6;
                                                                        block23: {
                                                                            block22: {
                                                                                Color color7;
                                                                                block21: {
                                                                                    block20: {
                                                                                        this.calendarPanel.setLayout(null);
                                                                                        this.calendarPanel.setOpaque(true);
                                                                                        LookAndFeel.installColorsAndFont(this.calendarPanel, "CalendarPanel.background", "CalendarPanel.foreground", "CalendarPanel.font");
                                                                                        Color color8 = this.calendarPanel.getSelectionForeground();
                                                                                        if (color8 == null) break block20;
                                                                                        if (!(color8 instanceof UIResource)) break block21;
                                                                                    }
                                                                                    this.calendarPanel.setSelectionForeground(UIManager.getColor("CalendarPanel.selectionForeground"));
                                                                                }
                                                                                if ((color7 = this.calendarPanel.getSelectionBackground()) == null) break block22;
                                                                                if (!(color7 instanceof UIResource)) break block23;
                                                                            }
                                                                            this.calendarPanel.setSelectionBackground(UIManager.getColor("CalendarPanel.selectionBackground"));
                                                                        }
                                                                        if ((color6 = this.calendarPanel.getWeekendForeground()) == null) break block24;
                                                                        if (!(color6 instanceof UIResource)) break block25;
                                                                    }
                                                                    this.calendarPanel.setWeekendForeground(UIManager.getColor("CalendarPanel.weekendForeground"));
                                                                }
                                                                if ((color5 = this.calendarPanel.getWeekendBackground()) == null) break block26;
                                                                if (!(color5 instanceof UIResource)) break block27;
                                                            }
                                                            this.calendarPanel.setWeekendBackground(UIManager.getColor("CalendarPanel.weekendBackground"));
                                                        }
                                                        if ((font2 = this.calendarPanel.getWeekendFont()) == null) break block28;
                                                        if (!(font2 instanceof UIResource)) break block29;
                                                    }
                                                    this.calendarPanel.setWeekendFont(UIManager.getFont("CalendarPanel.weekendFont"));
                                                }
                                                if ((color4 = this.calendarPanel.getPreviousMonthForeground()) == null) break block30;
                                                if (!(color4 instanceof UIResource)) break block31;
                                            }
                                            this.calendarPanel.setPreviousMonthForeground(UIManager.getColor("CalendarPanel.previousMonthForeground"));
                                        }
                                        if ((color3 = this.calendarPanel.getNextMonthForeground()) == null) break block32;
                                        if (!(color3 instanceof UIResource)) break block33;
                                    }
                                    this.calendarPanel.setNextMonthForeground(UIManager.getColor("CalendarPanel.nextMonthForeground"));
                                }
                                if ((color2 = this.calendarPanel.getHeaderForeground()) == null) break block34;
                                if (!(color2 instanceof UIResource)) break block35;
                            }
                            this.calendarPanel.setHeaderForeground(UIManager.getColor("CalendarPanel.headerForeground"));
                        }
                        if ((color = this.calendarPanel.getHeaderBackground()) == null) break block36;
                        if (!(color instanceof UIResource)) break block37;
                    }
                    this.calendarPanel.setHeaderBackground(UIManager.getColor("CalendarPanel.headerBackground"));
                }
                if ((font = this.calendarPanel.getHeaderFont()) == null) break block38;
                if (!(font instanceof UIResource)) break block39;
            }
            this.calendarPanel.setHeaderFont(UIManager.getFont("CalendarPanel.headerFont"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.mouseListener = this.createMouseListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.modelListener = this.createCalendarModelListener();
        this.calendarPanel.addFocusListener(this.focusListener);
        this.calendarPanel.addMouseListener(this.mouseListener);
        this.calendarPanel.addMouseMotionListener(this.mouseListener);
        this.calendarPanel.addPropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.calendarPanel.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.addCalendarModelListener(this.modelListener);
        }
    }

    protected void uninstallListeners() {
        this.calendarPanel.removeFocusListener(this.focusListener);
        this.calendarPanel.removeMouseListener(this.mouseListener);
        this.calendarPanel.removeMouseMotionListener(this.mouseListener);
        this.calendarPanel.removePropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.calendarPanel.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.removeCalendarModelListener(this.modelListener);
        }
        this.focusListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
        this.modelListener = null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseListener() {
        return new MouseHandler();
    }

    protected CalendarModelListener createCalendarModelListener() {
        return new CalendarModelHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public int getRowCount(IlvJCalendarPanel ilvJCalendarPanel) {
        return 6;
    }

    @Override
    public int getColumnCount(IlvJCalendarPanel ilvJCalendarPanel) {
        return 7;
    }

    @Override
    public int getRowHeight(IlvJCalendarPanel ilvJCalendarPanel) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n = ilvJCalendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return (ilvJCalendarPanel.getHeight() - n) / this.getRowCount(ilvJCalendarPanel);
    }

    @Override
    public int getColumnWidth(IlvJCalendarPanel ilvJCalendarPanel) {
        Insets insets = ilvJCalendarPanel.getInsets();
        return (ilvJCalendarPanel.getWidth() - (insets.left + insets.right)) / this.getColumnCount(ilvJCalendarPanel);
    }

    @Override
    public Rectangle getCellRect(IlvJCalendarPanel ilvJCalendarPanel, int n, int n2) {
        if (n < -1 || n >= this.getRowCount(ilvJCalendarPanel) || n2 < 0 || n2 >= this.getColumnCount(ilvJCalendarPanel)) {
            return null;
        }
        Insets insets = ilvJCalendarPanel.getInsets();
        int n3 = this.getColumnWidth(ilvJCalendarPanel);
        int n4 = insets.left + n2 * n3;
        int n5 = insets.top;
        int n6 = 0;
        if (n == -1) {
            n6 = ilvJCalendarPanel.getHeaderHeight();
        } else {
            n6 = this.getRowHeight(ilvJCalendarPanel);
            n5 += ilvJCalendarPanel.getHeaderHeight() + n * n6;
        }
        return new Rectangle(n4, n5, n3, n6);
    }

    @Override
    public int getRowAtPoint(IlvJCalendarPanel ilvJCalendarPanel, Point point) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n = point.y - insets.top;
        if (n < 0) {
            return -2;
        }
        if ((n -= ilvJCalendarPanel.getHeaderHeight()) < 0) {
            return -1;
        }
        int n2 = n / this.getRowHeight(ilvJCalendarPanel);
        if (n2 >= this.getRowCount(ilvJCalendarPanel)) {
            return -2;
        }
        return n2;
    }

    @Override
    public int getColumnAtPoint(IlvJCalendarPanel ilvJCalendarPanel, Point point) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n = point.x - insets.left;
        if (n < 0) {
            return -1;
        }
        int n2 = n / this.getColumnWidth(ilvJCalendarPanel);
        if (n2 >= this.getColumnCount(ilvJCalendarPanel)) {
            return -1;
        }
        return n2;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.calendarPanel.getInsets();
        float f = this.calendarPanel.getFont().getSize2D();
        int n = Math.round((float)this.getColumnCount(this.calendarPanel) * 2.25f * f) + insets.left + insets.right;
        int n2 = Math.round((float)this.getRowCount(this.calendarPanel) * 1.83f * f) + this.calendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = this.calendarPanel.getInsets();
        int n = this.getColumnCount(this.calendarPanel) * 10 + insets.left + insets.right;
        int n2 = this.getRowCount(this.calendarPanel) * 10 + this.calendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected final Calendar getFirstDayOfMonth() {
        Calendar calendar = this.calendarPanel.getCalendar();
        IlvCalendarUtil.monthFloor(calendar);
        return calendar;
    }

    protected final Calendar getFirstDayOfPanel() {
        Calendar calendar = this.getFirstDayOfMonth();
        int n = calendar.get(7);
        int n2 = calendar.getFirstDayOfWeek();
        int n3 = n2 - n;
        if (n3 > 0) {
            n3 -= 7;
        }
        if (n3 != 0) {
            calendar.add(6, n3);
        }
        return calendar;
    }

    @Override
    public Calendar getCellDate(IlvJCalendarPanel ilvJCalendarPanel, int n, int n2) {
        if (n < 0 || n >= this.getRowCount(ilvJCalendarPanel) || n2 < 0 || n2 >= this.getColumnCount(ilvJCalendarPanel)) {
            return null;
        }
        Calendar calendar = this.getFirstDayOfPanel();
        if (n > 0 || n2 > 0) {
            calendar.add(6, n2 + n * this.getColumnCount(ilvJCalendarPanel));
        }
        return calendar;
    }

    protected void resizeAndRepaint() {
        this.calendarPanel.revalidate();
        this.calendarPanel.repaint();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.a(graphics);
        this.b(graphics);
    }

    private void a(Graphics graphics) {
        Calendar calendar = this.getFirstDayOfPanel();
        IlvCalendarHeaderRenderer ilvCalendarHeaderRenderer = this.calendarPanel.getHeaderRenderer();
        Rectangle rectangle = this.getCellRect(this.calendarPanel, -1, 0);
        int n = this.getColumnWidth(this.calendarPanel);
        int n2 = this.getColumnCount(this.calendarPanel);
        for (int i = 0; i < n2; ++i) {
            this.paintHeader(graphics, rectangle, i, ilvCalendarHeaderRenderer, calendar);
            rectangle.x += n;
            calendar.add(6, 1);
        }
    }

    protected void paintHeader(Graphics graphics, Rectangle rectangle, int n, IlvCalendarHeaderRenderer ilvCalendarHeaderRenderer, Calendar calendar) {
        Component component = ilvCalendarHeaderRenderer.getCalendarHeaderRendererComponent(this.calendarPanel, calendar, n);
        this.rendererPane.paintComponent(graphics, component, this.calendarPanel, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void b(Graphics graphics) {
        Calendar calendar = this.calendarPanel.getCalendar();
        Calendar calendar2 = this.getFirstDayOfPanel();
        IlvCalendarCellRenderer ilvCalendarCellRenderer = this.calendarPanel.getCellRenderer();
        int n = this.getColumnWidth(this.calendarPanel);
        int n2 = this.getRowCount(this.calendarPanel);
        int n3 = this.getColumnCount(this.calendarPanel);
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = this.getCellRect(this.calendarPanel, i, 0);
            for (int j = 0; j < n3; ++j) {
                int n4 = IlvCalendarUtil.compareMonth(calendar2, calendar);
                boolean bl = n4 == 0 ? IlvCalendarUtil.compareDay(calendar, calendar2) == 0 : false;
                this.paintCell(graphics, rectangle, i, j, ilvCalendarCellRenderer, calendar2, n4 < 0, n4 > 0, bl);
                rectangle.x += n;
                calendar2.add(6, 1);
            }
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2, IlvCalendarCellRenderer ilvCalendarCellRenderer, Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.calendarPanel.hasFocus();
        Component component = ilvCalendarCellRenderer.getCalendarCellRendererComponent(this.calendarPanel, calendar, n, n2, bl, bl2, bl3, bl4);
        this.rendererPane.paintComponent(graphics, component, this.calendarPanel, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    static {
        a.add("cellRenderer");
        a.add("headerRenderer");
        a.add("selectionForeground");
        a.add("selectionBackground");
        a.add("weekendForeground");
        a.add("weekendBackground");
        a.add("weekendFont");
        a.add("previousMonthForeground");
        a.add("nextMonthForeground");
        a.add("headerForeground");
        a.add("headerBackground");
        a.add("headerFont");
        b = new HashSet();
        b.add("font");
        b.add("foreground");
        b.add("background");
        b.add("headerHeight");
    }

    public static class SelectionBorder
    implements Border,
    UIResource {
        private Border a;
        private JButton b;

        public SelectionBorder(Border border) {
            this.a = border;
            this.b = new JButton(""){

                @Override
                public boolean isDefaultButton() {
                    return true;
                }

                @Override
                public boolean isDefaultCapable() {
                    return true;
                }
            };
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.a.paintBorder(this.b, graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.a.getBorderInsets(component);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.a.isBorderOpaque();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                IlvCalendarModel ilvCalendarModel = (IlvCalendarModel)propertyChangeEvent.getOldValue();
                IlvCalendarModel ilvCalendarModel2 = (IlvCalendarModel)propertyChangeEvent.getNewValue();
                if (ilvCalendarModel != null) {
                    ilvCalendarModel.removeCalendarModelListener(BasicCalendarPanelUI.this.modelListener);
                }
                if (ilvCalendarModel2 != null) {
                    ilvCalendarModel2.addCalendarModelListener(BasicCalendarPanelUI.this.modelListener);
                }
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            } else if (a.contains(string)) {
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            } else if (b.contains(string)) {
                BasicCalendarPanelUI.this.resizeAndRepaint();
            }
        }
    }

    public class CalendarModelHandler
    implements CalendarModelListener {
        @Override
        public void calendarChanged(CalendarModelEvent calendarModelEvent) {
            if (IlvCalendarUtil.compareDay(calendarModelEvent.getOldCalendar(), calendarModelEvent.getNewCalendar()) != 0) {
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            }
        }
    }

    public class MouseHandler
    implements MouseInputListener {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            Point point;
            int n2;
            Calendar calendar;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicCalendarPanelUI.this.calendarPanel.isEnabled()) {
                return;
            }
            if (!BasicCalendarPanelUI.this.calendarPanel.hasFocus()) {
                BasicCalendarPanelUI.this.calendarPanel.requestFocus();
            }
            if ((calendar = BasicCalendarPanelUI.this.getCellDate(BasicCalendarPanelUI.this.calendarPanel, n2 = BasicCalendarPanelUI.this.getRowAtPoint(BasicCalendarPanelUI.this.calendarPanel, point = mouseEvent.getPoint()), n = BasicCalendarPanelUI.this.getColumnAtPoint(BasicCalendarPanelUI.this.calendarPanel, point))) != null) {
                Calendar calendar2 = BasicCalendarPanelUI.this.calendarPanel.getModel().getCalendar();
                calendar.add(11, calendar2.get(11));
                calendar.add(12, calendar2.get(12));
                calendar.add(13, calendar2.get(13));
                BasicCalendarPanelUI.this.calendarPanel.getModel().setCalendar(calendar);
                BasicCalendarPanelUI.this.calendarPanel.fireDateSelected();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicCalendarPanelUI.this.calendarPanel.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicCalendarPanelUI.this.calendarPanel.repaint();
        }
    }
}

