/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.awt.Component;
import java.util.ArrayList;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.Validator;
import oracle.jdeveloper.builder.BuilderValidationHelper;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.legacy.JotNames;

public abstract class TypeNameValidation
implements Validator {
    private boolean hasError = false;

    public ValidationMessage[] validate(Component comp, Object data) {
        this.hasError = false;
        ArrayList<ValidationMessage> res = new ArrayList<ValidationMessage>();
        String newClassName = (String)data;
        if (newClassName == null || !JotNames.isValidIdentifier(newClassName)) {
            res.add(new ValidationMessage(1, BuilderArb.format(180, BuilderValidationHelper.getDisplayName(newClassName, false))));
            this.hasError = true;
        }
        String warning = null;
        warning = BuilderValidationHelper.checkSuitableTypeName(newClassName);
        if (warning != null) {
            res.add(new ValidationMessage(2, warning));
        }
        this.resetOKButton();
        return res.toArray(new ValidationMessage[res.size()]);
    }

    public abstract void resetOKButton();

    public boolean isHasError() {
        return this.hasError;
    }
}

