/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.file;

import java.net.URL;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.AbstractFileScope;
import oracle.ide.file.FileSet;
import oracle.ide.file.Path;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Workspace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.file.ProjectKey;
import oracle.jdeveloper.model.JavaProject;

public final class ProjectOutputScope
extends AbstractFileScope {
    @GuardedBy(value="itself")
    private static final WeakCache<ProjectKey, ProjectOutputScope> INSTANCES = new WeakCache();
    private final Workspace workspace;
    private final Project project;
    @GuardedBy(value="listeners")
    private ProjectListener projectListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectOutputScope getInstance(Workspace workspace, Project project) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        WeakCache<ProjectKey, ProjectOutputScope> weakCache = INSTANCES;
        synchronized (weakCache) {
            ProjectKey key = ProjectKey.getInstance((Workspace)workspace, (Project)project);
            ProjectOutputScope scope = (ProjectOutputScope)((Object)INSTANCES.get((Object)key));
            if (scope == null) {
                scope = new ProjectOutputScope(workspace, project);
                INSTANCES.put((Object)key, (Object)scope);
            }
            return scope;
        }
    }

    private ProjectOutputScope(Workspace workspace, Project project) {
        this.workspace = workspace;
        this.project = project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Project getProject() {
        return this.project;
    }

    protected void activate() {
        if (this.projectListener == null) {
            this.projectListener = new ProjectListener();
            Project.addProjectChangeListener((String)JavaProject.OUTPUT_DIRECTORY, (ProjectChangeListener)this.projectListener);
        }
    }

    protected void deactivate() {
        if (this.projectListener != null) {
            Project.removeProjectChangeListener((String)JavaProject.OUTPUT_DIRECTORY, (ProjectChangeListener)this.projectListener);
            this.projectListener = null;
        }
    }

    protected Path getPath() {
        return Path.getInstance((FileSet[])new FileSet[]{FileSet.getInstance((URL)ProjectOutputScope.getOutputDirectory(this.project))});
    }

    protected Storage getStorage() {
        return Storages.getApplicationStorage((Workspace)this.workspace);
    }

    private static URL getOutputDirectory(Project project) {
        return JavaProject.getInstance(project).getOutputDirectory();
    }

    private final class ProjectListener
    extends ProjectChangeListener {
        private ProjectListener() {
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            ProjectOutputScope.this.notifyPathChanged();
        }
    }
}

