/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.Path;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.FileTableClassLocator;
import oracle.jdeveloper.java.locator.JavaTypeTableClassLocator;
import oracle.jdeveloper.java.locator.JdevPathClassLocator;
import oracle.jdeveloper.java.locator.LibraryClassLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkClassLocator;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.java.types.JavaTypeTable;

public class JdevClassLocatorFactory
extends ClassLocatorFactory {
    private static final boolean USE_FILE_TABLES = !Boolean.getBoolean("jdev.locator.disable.file.tables");

    public static BaseClassLocator getLibraryLocator(Library library) {
        if (library != null) {
            return new LibraryClassLocator(library);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocator(Workspace workspace, Library library) {
        if (library != null) {
            return library instanceof JDK ? JdevClassLocatorFactory.getJdkLocator(workspace, (JDK)library) : new LibraryClassLocator(workspace, library);
        }
        return null;
    }

    public static BaseClassLocator getJdkLocator(Workspace workspace, JDK jdkLibrary) {
        VersionNumber javaVersion;
        if (jdkLibrary != null && (javaVersion = jdkLibrary.getJavaVersion()) != null) {
            if (javaVersion.isAfter(new VersionNumber("9"), true)) {
                return new LibraryClassLocator(workspace, (Library)jdkLibrary){

                    @Override
                    protected void init(Workspace workspace, Library library) {
                        this._library = library;
                        Path sourcePath = Path.getInstance((URLPath)library.getSourcePath());
                        this._sourceLocator = 1.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocator(workspace, sourcePath));
                        this._classLocator = JdevClassLocatorFactory.getModularizedJDKClassLocator((JDK)library);
                        this._hasNoClassPath = this._classLocator == null;
                        this._classLocator = 1.ensureValid((BaseClassLocator)this._classLocator);
                    }
                };
            }
            return new LibraryClassLocator(workspace, (Library)jdkLibrary);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocator(Library[] libraries) {
        if (libraries != null) {
            int libraryCount = libraries.length;
            if (libraryCount == 0) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            BaseClassLocator[] libraryLocators = new BaseClassLocator[libraryCount];
            for (int i = 0; i < libraryCount; ++i) {
                BaseClassLocator locator = JdevClassLocatorFactory.getLibraryLocator(libraries[i]);
                libraryLocators[i] = locator != null ? locator : BaseClassLocator.EMPTY_LOCATOR;
            }
            return new ArrayClassLocator(libraryLocators);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocatorInterruptibly(Library[] libraries) throws InterruptedException {
        if (libraries != null) {
            int libraryCount = libraries.length;
            if (libraryCount == 0) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            BaseClassLocator[] libraryLocators = new BaseClassLocator[libraryCount];
            for (int i = 0; i < libraryCount; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                BaseClassLocator locator = JdevClassLocatorFactory.getLibraryLocator(libraries[i]);
                libraryLocators[i] = locator != null ? locator : BaseClassLocator.EMPTY_LOCATOR;
            }
            return new ArrayClassLocator(libraryLocators);
        }
        return null;
    }

    public static BaseClassLocator getProjectLocator(Workspace workspace, Project project) {
        if (project != null) {
            return ProjectClassLocator.getInstance(workspace, project);
        }
        return null;
    }

    public static BaseClassLocator getProjectLocatorInterruptibly(Workspace workspace, Project project) throws InterruptedException {
        if (project != null) {
            return ProjectClassLocator.getInstanceInterruptibly(workspace, project);
        }
        return null;
    }

    @Deprecated
    public static BaseClassLocator getProjectLocator(Project project) {
        if (project != null) {
            return ProjectClassLocator.getInstance(project);
        }
        return null;
    }

    @Deprecated
    public static BaseClassLocator getProjectLocatorInterruptibly(Project project) throws InterruptedException {
        if (project != null) {
            return ProjectClassLocator.getInstanceInterruptibly(project);
        }
        return null;
    }

    public BaseClassLocator getPathLocator(URLPath sourcePath, URLPath classPath) {
        if (sourcePath != null || classPath != null) {
            return JdevPathClassLocator.getInstance((URLPath)sourcePath, (URLPath)classPath);
        }
        return super.getPathLocator(sourcePath, classPath);
    }

    public BaseClassLocator getPathLocatorInterruptibly(URLPath sourcePath, URLPath classPath) throws InterruptedException {
        if (sourcePath != null || classPath != null) {
            return JdevPathClassLocator.getInstanceInterruptibly((URLPath)sourcePath, (URLPath)classPath);
        }
        return super.getPathLocator(sourcePath, classPath);
    }

    public static BaseClassLocator getSourceLocator(Workspace workspace, Path path) {
        BaseClassLocator[] locators = new BaseClassLocator[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            locators[i] = JdevClassLocatorFactory.getSourceLocator(workspace, (FileSet)path.get(i));
        }
        return new ArrayClassLocator(locators);
    }

    public static BaseClassLocator getSourceLocatorInterruptibly(Workspace workspace, Path path) throws InterruptedException {
        BaseClassLocator[] locators = new BaseClassLocator[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            locators[i] = JdevClassLocatorFactory.getSourceLocator(workspace, (FileSet)path.get(i));
        }
        return new ArrayClassLocator(locators);
    }

    public static BaseClassLocator getSourceLocator(Workspace workspace, FileSet fileSet) {
        if (workspace != null && JdevClassLocatorFactory.useFileTables()) {
            return JdevClassLocatorFactory.getFileTableLocator(workspace, fileSet, FileTableClassLocator.Type.SOURCE);
        }
        return JavaModelFactory.getInstance().getLocatorFactory().getSourceLocator(fileSet.getRoot());
    }

    public static BaseClassLocator getClassLocator(Workspace workspace, Path path) {
        BaseClassLocator[] locators = new BaseClassLocator[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            locators[i] = JdevClassLocatorFactory.getClassLocator(workspace, (FileSet)path.get(i));
        }
        return new ArrayClassLocator(locators);
    }

    public static BaseClassLocator getClassLocatorInterruptibly(Workspace workspace, Path path) throws InterruptedException {
        BaseClassLocator[] locators = new BaseClassLocator[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            locators[i] = JdevClassLocatorFactory.getClassLocator(workspace, (FileSet)path.get(i));
        }
        return new ArrayClassLocator(locators);
    }

    public static BaseClassLocator getClassLocator(Workspace workspace, FileSet fileSet) {
        if (workspace != null && JdevClassLocatorFactory.useFileTables() && JavaTypeTable.isEnabled()) {
            return JdevClassLocatorFactory.getFileTableLocator(workspace, fileSet, FileTableClassLocator.Type.CLASS);
        }
        return JavaModelFactory.getInstance().getLocatorFactory().getClassLocator(fileSet.getRoot());
    }

    private static BaseClassLocator getModularizedJDKClassLocator(JDK jdk) {
        URL parent;
        URL url = jdk.getJavaExecutable();
        URL uRL = parent = url != null ? URLFileSystem.getParent((URL)url) : null;
        while (parent != null) {
            URL jrtfs = URLFactory.newURL((URL)parent, (String)"lib/jrt-fs.jar");
            if (jrtfs != null && URLFileSystem.exists((URL)jrtfs)) {
                return ModularizedJdkClassLocator.getInstance((URL)jrtfs);
            }
            URL src = URLFactory.newURL((URL)parent, (String)"release");
            if (src != null && URLFileSystem.exists((URL)src)) break;
            parent = URLFileSystem.getParent((URL)parent);
        }
        return null;
    }

    private static BaseClassLocator getFileTableLocator(Workspace workspace, FileSet fileSet, FileTableClassLocator.Type type) {
        Storage storage = Storages.getApplicationStorage((Workspace)workspace);
        FileSetTable table = FileSetTable.getInstance((Storage)storage, (FileSet)fileSet);
        JavaTypeTable typeTable = JavaTypeTable.getInstance(table);
        if (typeTable != null) {
            return new JavaTypeTableClassLocator(typeTable, type);
        }
        return new FileTableClassLocator(table, type);
    }

    private static boolean useFileTables() {
        return USE_FILE_TABLES && !Boolean.getBoolean("jbo.kava");
    }
}

