/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.java.provider.BaseFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public class JdevProviderContext
extends ProviderContext {
    private static final String ISSUED_IN_MEMORY_NODE_WARNING = "issued.in.memory.node.warning";
    protected static final Class JAVACLASSNODE_CLASS = JavaClassNode.class;
    protected static final Class JAVASOURCENODE_CLASS = JavaSourceNode.class;
    private final boolean allowInMemory;
    private static WeakReference preferencesRef = null;
    protected Map<URL, NodeObserver> _urlToObserverMap = new Maps.CacheMap(100);

    public JdevProviderContext(boolean allowInMemoryIn) {
        this.allowInMemory = allowInMemoryIn;
    }

    protected final int getFileType(URL url) {
        Class nodeClass = Recognizer.recognizeURL((URL)url);
        if (nodeClass != null) {
            if (JAVASOURCENODE_CLASS.isAssignableFrom(nodeClass)) {
                return 2;
            }
            if (JAVACLASSNODE_CLASS.isAssignableFrom(nodeClass)) {
                return 1;
            }
        }
        return super.getFileType(url);
    }

    protected final SourcePreferences getSourcePreferences() {
        SourcePreferences p = this.getSourcePreferencesImpl();
        if (p == null) {
            return null;
        }
        SourcePreferences copy = SourcePreferences.createCascadingPreferences((SourcePreferences)p);
        return copy;
    }

    private SourcePreferences getSourcePreferencesImpl() {
        SourcePreferences p;
        WeakReference ref = preferencesRef;
        if (ref != null && (p = (SourcePreferences)ref.get()) != null) {
            return p;
        }
        try {
            CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
            if (csm == null) {
                return null;
            }
            CodingStyleOptions o = csm.getCodingStyleOptions();
            SourcePreferences p2 = o.getSourcePreferences();
            if (p2 == null) {
                return null;
            }
            return p2;
        }
        catch (NullPointerException e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    public SourceFile createSourceFile(URL sourceURL, JdkVersion jdkVersion) throws IOException, IllegalArgumentException {
        try {
            Node node = NodeFactory.findOrCreate((URL)sourceURL);
            if (node != null) {
                if (!node.isNew()) {
                    return null;
                }
                boolean isSource = node instanceof JavaSourceNode;
                boolean isText = node instanceof TextNode;
                if (!isSource && isText) {
                    String suffix = URLFileSystem.getSuffix((URL)sourceURL);
                    isSource = suffix.equals(".java");
                }
                if (isSource) {
                    OutputStream os = URLFileSystem.openOutputStream((URL)sourceURL);
                    os.close();
                    return this.getSourceFile(sourceURL, jdkVersion);
                }
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unrecognized url: " + sourceURL);
    }

    @Deprecated
    public SourceFile createSourceFile(URL sourceURL, int j2se) throws IOException, IllegalArgumentException {
        return this.createSourceFile(sourceURL, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    public SourceFile getSourceFile(URL url, JdkVersion jdkVersion) {
        return this.getSourceFileImpl(url, jdkVersion);
    }

    @Deprecated
    public SourceFile getSourceFile(URL url, int j2se) {
        return this.getSourceFile(url, JdkVersion.getJdkVersion((byte)((byte)j2se)));
    }

    public boolean writeSourceFile(SourceFile file) {
        Node node;
        URL url;
        if (!Ide.isRunning() && (url = file.getURL()) != null && (node = NodeFactory.find((URL)url)) instanceof TextNode) {
            try {
                node.save();
            }
            catch (IOException e) {
                Assert.println((String)("Error saving: " + url));
                Assert.printStackTrace((Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected TextBuffer getTextBuffer(URL url) {
        Class nodeClass = Recognizer.recognizeURL((URL)url);
        if (nodeClass != null) {
            boolean isText;
            boolean isSource = JavaSourceNode.class.isAssignableFrom(nodeClass);
            boolean isClass = !isSource && JavaClassNode.class.isAssignableFrom(nodeClass);
            boolean bl = isText = !isSource && !isClass && TextNode.class.isAssignableFrom(nodeClass);
            if (isText) {
                String suffix = URLFileSystem.getSuffix((URL)url);
                isSource = suffix.equals(".java");
            }
            if (isSource || isClass) {
                try {
                    boolean existsOnDisk = URLFileSystem.exists((URL)url);
                    Node node = NodeFactory.find((URL)url);
                    if (node != null && !existsOnDisk) {
                        if (!this.allowInMemory) {
                            Map transientProperties = node.getTransientProperties();
                            if (!transientProperties.containsKey(ISSUED_IN_MEMORY_NODE_WARNING)) {
                                Assert.println((String)("Warning: in-memory only Node: " + url.toString()));
                                transientProperties.put(ISSUED_IN_MEMORY_NODE_WARNING, true);
                            }
                            if (!node.isDirty()) {
                                return null;
                            }
                        }
                    } else if (node == null && existsOnDisk) {
                        node = NodeFactory.findOrCreate((URL)url);
                    }
                    if (node != null) {
                        if (node instanceof TextNode) {
                            return ((TextNode)node).acquireTextBuffer();
                        }
                        Assert.println((String)("Warning, unexpected node type: " + node.getClass().getName()));
                        Assert.println((String)("  url = " + url.toString()));
                        return null;
                    }
                }
                catch (InstantiationException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTracking(URL url) {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            Node node;
            if (!this._urlToObserverMap.containsKey(url) && (node = NodeFactory.find((URL)url)) != null) {
                NodeObserver observer = new NodeObserver(node, url);
                this._urlToObserverMap.put(url, observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTracking(URL url) {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            this._urlToObserverMap.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTracking() {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            for (NodeObserver observer : this._urlToObserverMap.values()) {
                if (observer == null) continue;
                observer.detachSelf(null);
            }
            this._urlToObserverMap.clear();
        }
    }

    protected class NodeObserver
    extends NodeListener {
        private URL _sourceURL;

        protected NodeObserver(Node node, URL sourceURL) {
            this._sourceURL = sourceURL;
            node.addNodeListener((NodeListener)this);
        }

        private void detachSelf(Node node) {
            if (node == null) {
                node = NodeFactory.find((URL)this._sourceURL);
            }
            if (node != null) {
                node.removeNodeListener((NodeListener)this);
            }
        }

        private void initiateExpire() {
            BaseFileProvider provider = JdevProviderContext.this.getProvider();
            if (provider != null) {
                provider.notifyOfChange(this._sourceURL);
            }
        }

        private void initiateDetach(Node node) {
            JdevProviderContext.this.stopTracking(this._sourceURL);
            this.detachSelf(node);
        }

        public void nodeClosed(NodeEvent event) {
            this.initiateDetach(event.getNode());
            this.initiateExpire();
        }

        public void nodeRenamed(NodeEvent event, URL oldURL, URL newURL) {
            this.initiateDetach(event.getNode());
            this.initiateExpire();
        }
    }
}

