/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.datatransfer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.share.RefCounter;
import oracle.bali.xml.share.UnmodifiableIterator;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.logging.LogUtils;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.datatransfer.DataAndPositions;
import oracle.jdeveloper.uieditor.datatransfer.Operation;
import oracle.jdeveloper.uieditor.datatransfer.UIPosition;

public class OperationProcessor {
    public static final int SHOW_ALL_OPERATIONS = -1;
    private ExtendedTransferable _transferable = null;
    private int _actionMask = -1;
    private boolean _editable = true;
    private View _view = null;
    private CmtModel _targetModel = null;
    private transient List _potentialOps = null;
    private transient Map _currentInfo = null;
    private final Map _locationsToInfoCache = new HashMap();
    private static final Logger _LOGGER = Logger.getLogger(OperationProcessor.class.getName());
    private static final Comparator _BY_RANK_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            Operation opA = (Operation)a;
            Operation opB = (Operation)b;
            float rankDiff = opB.getSuitabilityRank() - opA.getSuitabilityRank();
            if (rankDiff < 0.0f) {
                return -1;
            }
            if (rankDiff > 0.0f) {
                return 1;
            }
            if (opA.equals(opB)) {
                return 0;
            }
            return opA.hashCode() - opB.hashCode();
        }
    };

    public OperationProcessor(View view) {
        this.setView(view);
    }

    public void setTransferable(ExtendedTransferable transferable) {
        if (transferable != this._transferable) {
            this._transferable = transferable;
            this._clearCaches();
        }
    }

    public void setView(View view) {
        this._view = view;
        if (view instanceof UIEditor) {
            view = ((UIEditor)((Object)view)).getActiveCanvas();
        } else if (view instanceof ExplorerWindow) {
            view = ((ExplorerWindow)view).getExplorer();
        }
        if (view instanceof UIEditorCanvas) {
            Element[] selection = view.getSelection();
            if (selection != null && selection.length > 0) {
                this.setTargetModel(((CmtModelNode)selection[0]).getCmtModel());
            } else {
                this.setTargetModel(null);
            }
        } else {
            this.setTargetModel(null);
        }
    }

    public void setTargetModel(CmtModel targetModel) {
        if (this._targetModel != targetModel) {
            this._targetModel = targetModel;
            this._clearCaches();
        }
    }

    public void setActionMask(int actionMask) {
        if (actionMask != this._actionMask) {
            this._actionMask = actionMask;
            this._clearCaches();
        }
    }

    public void setEditable(boolean editable) {
        if (editable != this._editable) {
            this._editable = editable;
            this._clearCaches();
        }
    }

    public void update(List positions) {
        Map info = (Map)this._locationsToInfoCache.get(positions);
        if (info == null) {
            info = this._computeInfo(positions);
            if (_LOGGER.isLoggable(Level.FINE)) {
                _LOGGER.log(Level.FINE, "Computed info for {0}: {1}", new Object[]{positions, info});
            }
            positions = new ArrayList(positions);
            this._locationsToInfoCache.put(positions, info);
        }
        if (info != this._currentInfo) {
            this._currentInfo = info;
        }
    }

    public boolean hasSupportedOperation() {
        return this._currentInfo != null && !this._currentInfo.isEmpty();
    }

    public UIPosition getRepresentativeOperationPosition() {
        if (this._currentInfo != null) {
            RefCounter counter = new RefCounter();
            for (List dapList : this._currentInfo.values()) {
                for (DataAndPositions dataAndPos : dapList) {
                    counter.addCount(dataAndPos.getPositions().get(0));
                }
            }
            return (UIPosition)counter.getMaxValue();
        }
        return null;
    }

    public Iterator getSupportedOperations() {
        if (this._currentInfo != null) {
            return new UnmodifiableIterator(this._currentInfo.keySet().iterator());
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getListOfDataAndPositions(Operation operation) {
        if (this._currentInfo != null) {
            return (List)this._currentInfo.get(operation);
        }
        return null;
    }

    public boolean forceSimpleApply() throws IOException {
        if (((SourceFile)this._targetModel.getComponent().getFile()).getTransaction() != null) {
            throw new IllegalStateException("model is in transaction!");
        }
        if (!this.hasSupportedOperation()) {
            throw new IllegalStateException("! hasSupportedOperation()");
        }
        return this._forceSimpleApplyImpl();
    }

    private boolean _forceSimpleApplyImpl() throws IOException {
        Iterator opItor = this.getSupportedOperations();
        while (opItor.hasNext()) {
            Operation op = (Operation)opItor.next();
            List listOfDap = this.getListOfDataAndPositions(op);
            for (DataAndPositions dap : listOfDap) {
                for (UIPosition pos : dap.getPositions()) {
                    boolean ok;
                    if (_LOGGER.isLoggable(Level.FINE)) {
                        _LOGGER.log(Level.FINE, "Considering op {0}, data {1}, pos {2} in forceSimplyApply", new Object[]{op, dap.getData(), pos});
                    }
                    if (ok = op.apply(this._targetModel, pos, dap.getData())) {
                        _LOGGER.fine("last apply succeeded");
                        return true;
                    }
                    _LOGGER.fine("last apply returned false");
                }
            }
        }
        return false;
    }

    private Map _computeInfo(List positions) {
        TreeMap<Operation, List> opsMap = null;
        for (Operation operation : this._getPotentialOperations()) {
            boolean considerOp;
            if (!this._editable && operation.doesActionMutateModel() || !(considerOp = this._actionMask == -1 || (this._actionMask & operation.getSupportedActions()) > 0)) continue;
            try {
                List list = operation.getApplicableDataAndPositions(this._targetModel, positions, this._transferable);
                if (list.isEmpty()) continue;
                if (opsMap == null) {
                    opsMap = new TreeMap<Operation, List>(_BY_RANK_COMPARATOR);
                }
                opsMap.put(operation, list);
            }
            catch (Exception e) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception querying operation {0}", (Object)operation, (Throwable)e);
            }
        }
        if (opsMap == null) {
            opsMap = Collections.EMPTY_MAP;
        }
        return opsMap;
    }

    private List _getPotentialOperations() {
        if (this._potentialOps == null) {
            if (this._transferable == null) {
                return Collections.EMPTY_LIST;
            }
            this._potentialOps = UIManager.createApplicableOperations(this._view.getContext(), this._transferable);
        }
        return this._potentialOps;
    }

    private void _clearCaches() {
        _LOGGER.finer("clearing caches");
        this._potentialOps = null;
        this._currentInfo = null;
        this._locationsToInfoCache.clear();
    }
}

