/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.PeekHelper;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.jdeveloper.java.JavaManager;

public class JavaCodePeek {
    public static CodePeek createCodePeek(JComponent comp, String fileName, String text, String labelText, Rectangle rect) {
        CodePeek peek = null;
        peek = new CodePeek(comp, fileName);
        rect.grow(1, 0);
        rect.translate(-1, -1);
        rect.x = Math.max(rect.x, 0);
        rect.y = Math.max(rect.y, 0);
        peek.setRectangle(rect);
        peek.setText(text);
        peek.setLabelText(labelText);
        return peek;
    }

    public static CodePeek createCodePeek(JComponent comp, SourceElement se, Rectangle rect) {
        JavaFile file = se.getOwningSourceFile().getFile();
        if (file == null || file.getURL() == null) {
            return null;
        }
        String fileName = file.getURL().toExternalForm();
        CodePeek peek = null;
        try {
            JavaClass cls;
            String name = null;
            String text = JavaCodePeek.getPeekText(se);
            if (text == null) {
                return null;
            }
            SourceFile sf = se.getOwningSourceFile();
            if (sf != null && (cls = sf.getPrimaryClass()) != null) {
                name = cls.getQualifiedName();
            }
            if (se instanceof SourceLambdaExpression) {
                name = ((SourceLambdaExpression)se).getTargetMethod().getOwningClass().getQualifiedName();
            }
            if (se instanceof SourceLambdaParameter) {
                name = ((SourceLambdaParameter)se).getOwningLambdaExpression().getTargetMethod().getOwningClass().getQualifiedName();
            }
            if (name != null) {
                peek = PeekHelper.createCodePeek((JComponent)comp, (String)fileName, (String)text, (String)name, (Rectangle)rect);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        return peek;
    }

    public static void showPeek(CodePeek peek) {
        peek.showPeek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPeekText(Project project, URL url, int line, int padLines) {
        JavaManager jm;
        SourceFile sf;
        String text = null;
        if (project != null && (sf = (jm = JavaManager.getInstance(project)).getSourceFile(url)) != null) {
            TextBuffer tb = sf.getTextBuffer();
            tb.readLock();
            try {
                int sOff = tb.getLineMap().getLineStartOffset(Math.max(0, line - padLines));
                int eOff = tb.getLineMap().getLineEndOffset(Math.min(line + padLines, tb.getLineMap().getLineCount() - 1));
                text = sf.getTextBuffer().getString(sOff, eOff - sOff - 1);
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
            }
            finally {
                tb.readUnlock();
            }
        }
        if (text == null) {
            JavaCodePeek.getPeekText(url, line, padLines);
        }
        return text;
    }

    public static CodePeek createCodePeek(Project project, URL url, int line, String labelText, JComponent comp, Rectangle rect, String styleName) {
        String text;
        int pad = 4;
        if ((text = JavaCodePeek.getPeekText(project, url, --line, pad)) == null) {
            return null;
        }
        CodePeek peek = PeekHelper.createCodePeek((JComponent)comp, (String)url.getFile(), (String)text, (String)labelText, (Rectangle)rect);
        HighlightLayer hl = peek.getEditor().createHighlightLayer();
        int hiLine = line < pad ? line : pad;
        EditorProperties properties = EditorProperties.getProperties();
        HighlightStyle style = properties.getHighlightRegistry().lookupStyle(styleName);
        hl.addLineHighlight(style, hiLine);
        return peek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPeekText(URL url, int line, int padLines) {
        if (url == null) {
            return null;
        }
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            JavaManager jm;
            SourceFile sf;
            Project project;
            Node node;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || (node = context.getNode()) == null || !node.getURL().equals(url) || (project = context.getProject()) == null || (sf = (jm = JavaManager.getInstance(project)).getSourceFile(url)) == null) continue;
            return JavaCodePeek.getPeekText(project, url, line, padLines);
        }
        Reader r = null;
        String text = null;
        try {
            r = new FileReader(new File(url.toURI()));
            r = new BufferedReader(r);
            int firstLine = Math.max(0, line - padLines);
            int lastLine = line + padLines;
            String aLine = ((BufferedReader)r).readLine();
            for (int curLine = 0; aLine != null && curLine <= lastLine; ++curLine) {
                if (curLine >= firstLine && curLine <= lastLine) {
                    text = text + aLine;
                }
                aLine = ((BufferedReader)r).readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return text;
    }

    private static String getPeekText(SourceElement se) {
        switch (se.getSymbolKind()) {
            case 10: 
            case 17: {
                se = se.getParent();
                break;
            }
            case 31: {
                SourceLambdaParameter lambdaParam = (SourceLambdaParameter)se;
                SourceLambdaExpression lambdaExp = lambdaParam.getOwningLambdaExpression();
                JavaMethod method = lambdaExp.getTargetMethod();
                if (method == null) {
                    return null;
                }
                SourceMethod sourceMethod = method.getSourceElement();
                if (sourceMethod == null) break;
                se = sourceMethod;
                break;
            }
            case 79: {
                SourceLambdaExpression lambdaExp = (SourceLambdaExpression)se;
                JavaMethod method = lambdaExp.getTargetMethod();
                if (method == null) {
                    return null;
                }
                JavaClass javaClass = method.getOwningClass();
                SourceClass sourceClass = javaClass.getSourceElement();
                if (sourceClass == null) break;
                se = sourceClass;
            }
        }
        return se.getText();
    }
}

