/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.editor;

import ilog.views.IlvManagerView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.EditorScrollManagerView;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.controller.ControllerChain;
import oracle.diagram.framework.inspector.InspectorPlugin;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramContextMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.menu.ViewDiagramContextMenuPlugin;
import oracle.diagram.framework.palette.EditorPaletteEventDispatch;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.thumbnail.DefaultThumbnailClient;
import oracle.ide.thumbnail.ThumbnailClient;
import oracle.ide.thumbnail.ThumbnailClientListener;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.MainWindowImpl;

public class IdeDiagramEditor
extends JViewsEditor
implements ThumbnailClient {
    static final String CONTEXT_INITIALIZED = "oracle.diagram.framework.IdeDiagramEditor.initialised";
    private Diagram[] _diagrams;
    private State _editorState = State.CREATED;
    private volatile boolean _contentLoaded = false;
    private final Controller _controller;
    private final ViewSelectionHack _vsh = new ViewSelectionHack();
    private Component _guiComponent = null;
    private JScrollBar _hsb = null;
    private JScrollBar _vsb = null;
    private JPanel _toolbarParent = null;
    private StructuredPropertyAccess _settings = null;
    private DefaultThumbnailClient _thumbnailClientDelegate = new DefaultThumbnailClient();
    private final Object _openLock = new Object();
    private boolean _diagramOpen;

    public IdeDiagramEditor(Diagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException("diagram must not be null");
        }
        this._diagrams = new Diagram[]{diagram};
        this._hsb = new JScrollBar(0);
        this._hsb.setValues(0, 0, 0, 0);
        this._vsb = new JScrollBar(1);
        this._vsb.setValues(0, 0, 0, 0);
        this._controller = new HostController(super.getController());
    }

    public Component getDefaultFocusComponent() {
        if (this.getDiagram() != null) {
            IlvManagerView view = this.getDiagram().getDiagramContext().getManagerView();
            if (view == null) {
                return super.getDefaultFocusComponent();
            }
            if (view != null && "view".equals(view.getName())) {
                view.setName(null);
            }
            if (view.getInteractor() instanceof InPlaceEditor) {
                Component currentFocusComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                return currentFocusComp;
            }
            return view;
        }
        return super.getDefaultFocusComponent();
    }

    private Context setupEditorContext(Context context) {
        Context editorContext = context == null ? Context.newIdeContext((View)this) : (context.getProperty(CONTEXT_INITIALIZED) == this ? new Context(context) : new Context((View)this, context.getWorkspace(), context.getProject(), context.getNode()));
        editorContext.setProperty(CONTEXT_INITIALIZED, (Object)this);
        this.initContext(context, editorContext);
        return editorContext;
    }

    protected void getEditorContent(Context context) {
        Context editorContext = this.setupEditorContext(context);
        for (Diagram diagram : this.getDiagrams()) {
            this.setDiagramContext(diagram, context, editorContext);
        }
        this._contentLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl(boolean contentAvailable) throws OpenAbortedException {
        if (!contentAvailable) {
            return;
        }
        Diagram[] diagrams = this.getDiagrams();
        int lastSuccessfulOrPartialOpen = -1;
        try {
            for (int i = 0; i < diagrams.length; ++i) {
                lastSuccessfulOrPartialOpen = i;
                Diagram diagram = diagrams[i];
                this.openDiagram(diagram);
            }
            this._editorState = State.OPENED;
            Object i = this._openLock;
            synchronized (i) {
                this._diagramOpen = true;
                this._openLock.notifyAll();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i <= lastSuccessfulOrPartialOpen; ++i) {
                try {
                    diagrams[i].close();
                    continue;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().closeEditors(Collections.singletonList(IdeDiagramEditor.this));
                }
            });
        }
    }

    public final void waitForOpenDiagram() throws InterruptedException {
        this.waitForOpenDiagram(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForOpenDiagram(long timeMillis) throws InterruptedException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("IdeDiagramEditor.waitForOpenDiagram cannot be called from the Event Thread");
        }
        Object object = this._openLock;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long elapsed = 0L;
            while (!this._diagramOpen) {
                this._openLock.wait(timeMillis > 0L ? timeMillis - elapsed : 0L);
                if (timeMillis <= 0L || (elapsed = System.currentTimeMillis() - startTime) < timeMillis) continue;
            }
        }
    }

    protected void openDiagram(Diagram diagram) throws OpenAbortedException {
        this.installEditorPlugins(diagram);
        EditorPaletteEventDispatch paletteEventHelper = this.createPaletteEventHelper(diagram);
        diagram.getDiagramContext().addPlugin(PaletteEventDispatchPlugin.class, new PaletteEventDispatchPlugin(paletteEventHelper));
        try {
            diagram.open();
        }
        catch (Exception ex) {
            diagram.getDiagramContext().removePlugin(PaletteEventDispatchPlugin.class);
            IdeDiagramEditor.rethrowOpenException(ex);
        }
    }

    protected static void rethrowOpenException(Throwable th) throws OpenAbortedException {
        if (th instanceof OpenAbortedException) {
            throw (OpenAbortedException)th;
        }
        OpenAbortedException oaex = new OpenAbortedException();
        oaex.initCause(th);
        oaex.printStackTrace();
        throw oaex;
    }

    protected EditorPaletteEventDispatch createPaletteEventHelper(Diagram diagram) {
        return new EditorPaletteEventDispatch((Editor)this, diagram.getDiagramContext()){

            @Override
            protected boolean isActive() {
                if (super.isActive()) {
                    if (IdeDiagramEditor.this.getDiagrams().length == 1) {
                        return true;
                    }
                    Diagram diagram = IdeDiagramEditor.this.getDiagram();
                    return diagram != null && diagram.getDiagramContext() == this.getDiagramContext();
                }
                return false;
            }
        };
    }

    protected void installEditorPlugins(Diagram diagram) {
        DiagramContext dc = diagram.getDiagramContext();
        dc.addPlugin(DiagramMainMenuPlugin.class, DefaultDiagramMainMenuPlugin.getInstance());
        dc.addPlugin(DiagramContextMenuPlugin.class, new ViewDiagramContextMenuPlugin(dc, (View)this));
        dc.addPlugin(SelectionChangeNotificationPlugin.class, new SelectionPlugin());
    }

    @Override
    public Object getEditorAttribute(String attribute) {
        DiagramMainMenuPlugin p;
        if (this.getDiagram() != null && "menu_id".equals(attribute) && (p = this.getDiagram().getDiagramContext().getPlugin(DiagramMainMenuPlugin.class)) != null) {
            return p.getDiagramMenuName();
        }
        return super.getEditorAttribute(attribute);
    }

    protected Component getGUIComponent() {
        if (!this.isContentModelLoaded()) {
            return null;
        }
        if (this._guiComponent == null && this._editorState == State.OPENED) {
            this._guiComponent = this.createGUI();
            this._editorState = State.GET_GUI_CALLED;
        }
        return this._guiComponent;
    }

    protected Component createGUI() {
        if (this.getDiagrams().length == 1) {
            return new EditorScrollManagerView(this.getDiagrams()[0].getDiagramContext().getManagerView(), this._hsb, this._vsb);
        }
        throw new IllegalStateException("Must override createGUI() to use multiple diagrams");
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
    }

    public final void saveSettings(StructuredPropertyAccess element) {
        super.saveSettings(element);
        if (this._editorState == State.GET_GUI_CALLED) {
            this.saveSettingsImpl(element);
        }
    }

    protected void saveSettingsImpl(StructuredPropertyAccess element) {
        for (Diagram diagram : this.getDiagrams()) {
            this.saveDiagramSettings(diagram, element);
        }
    }

    protected void saveDiagramSettings(Diagram diagram, StructuredPropertyAccess element) {
        diagram.saveSettings(element);
    }

    public final void loadSettings(StructuredPropertyAccess element) {
        super.loadSettings(element);
        if (this._editorState == State.GET_GUI_CALLED) {
            this.loadSettingsImpl(element);
        } else {
            this._settings = element;
        }
    }

    protected void loadSettingsImpl(StructuredPropertyAccess element) {
        for (Diagram diagram : this.getDiagrams()) {
            this.loadDiagramSettings(diagram, element);
        }
    }

    protected void loadDiagramSettings(Diagram diagram, StructuredPropertyAccess element) {
        diagram.loadSettings(element);
    }

    protected Element[] getSelectionFromUI() {
        DiagramIdeSelectionPlugin esp;
        if (this.getDiagram() != null && (esp = this.getDiagram().getDiagramContext().getPlugin(DiagramIdeSelectionPlugin.class)) != null) {
            esp.fetchSelectionFromUI();
            return esp.getSelection();
        }
        return super.getSelectionFromUI();
    }

    protected void activateImpl(boolean contentAvailable) {
        if (!contentAvailable) {
            return;
        }
        super.activateImpl(contentAvailable);
        if (this.getDiagram() != null) {
            Toolbar tb;
            this.getDiagram().activate();
            ToolbarPlugin plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
            if (plugin != null && (tb = plugin.getToolbar()) != null) {
                tb.repaint();
            }
        }
    }

    protected void closeImpl(boolean contentAvailable) {
        if (!contentAvailable) {
            return;
        }
        super.closeImpl(contentAvailable);
        for (Diagram diagram : this.getDiagrams()) {
            diagram.close();
        }
        this._editorState = State.CLOSED;
        this._guiComponent = null;
    }

    public Node[] getDependentNodes() {
        if (this._editorState == State.OPENED || this._editorState == State.GET_GUI_CALLED) {
            Diagram[] diagrams = this.getDiagrams();
            HashSet<Node> nodes = new HashSet<Node>();
            for (Diagram diagram : diagrams) {
                nodes.add(diagram.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext().getNode());
            }
            return nodes.toArray(new Node[nodes.size()]);
        }
        return new Node[0];
    }

    protected void deactivateImpl(boolean contentAvailable) {
        if (!contentAvailable) {
            return;
        }
        super.deactivateImpl(contentAvailable);
        if (this.getDiagram() != null) {
            Toolbar tb;
            this.getDiagram().deactivate();
            ToolbarPlugin plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
            if (plugin != null && (tb = plugin.getToolbar()) != null) {
                tb.repaint();
            }
        }
    }

    public Controller getController() {
        if (this._controller != null) {
            return this._controller;
        }
        return super.getController();
    }

    @Override
    public IlvManagerView getActiveManagerView() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            return diagram.getDiagramContext().getManagerView();
        }
        return null;
    }

    @Override
    protected Component getHorizontalScrollBar() {
        Component gui = this.getGUI();
        if (this._hsb != null) {
            return this._hsb;
        }
        if (gui instanceof EditorScrollManagerView) {
            return ((EditorScrollManagerView)gui).getHorizontalScrollBar();
        }
        if (!this.isContentModelLoaded()) {
            return null;
        }
        throw new IllegalStateException("getHorizontalScrollBar() must be overridden with getGUI()");
    }

    @Override
    protected Component getVerticalScrollBar() {
        Component gui = this.getGUI();
        if (this._vsb != null) {
            return this._vsb;
        }
        if (gui instanceof EditorScrollManagerView) {
            return ((EditorScrollManagerView)gui).getVerticalScrollBar();
        }
        if (!this.isContentModelLoaded()) {
            return null;
        }
        throw new IllegalStateException("getVerticalScrollBar() must be overridden with getGUI()");
    }

    protected boolean canMorphContext() {
        Diagram[] diagrams = this.getDiagrams();
        if (diagrams != null) {
            for (Diagram diagram : diagrams) {
                if (diagram.canMorphContext()) continue;
                return false;
            }
        }
        return true;
    }

    protected final void doSetContext(Context context) {
        Context editorContext = this.setupEditorContext(context);
        this._editorState = State.CONTEXT_SET;
        this.doSetContextImpl(editorContext);
    }

    protected void doSetContextImpl(Context context) {
        this.delayContextSet(context);
    }

    protected void setDiagramContext(Diagram diagram, Context srcContext, Context editorContext) {
        diagram.initContext(srcContext, editorContext);
        diagram.getDiagramContext().addPlugin(IdeContextPlugin.class, new ContextPlugin());
    }

    protected void initContext(Context context, Context editorContext) {
        editorContext.setProperty("oracle.diagram.inspector.ActiveInspectedView", (Object)this);
    }

    protected void diagramActivated() {
        this.forceViewSelectionChange();
        this.getDiagram().activate();
        this._thumbnailClientDelegate.fireClientViewChanged((ThumbnailClient)this);
    }

    protected void diagramDeactivated() {
        final PalettePlugin pp = this.getDiagram().getDiagramContext().getPlugin(PalettePlugin.class);
        if (pp != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pp.reset();
                }
            });
        }
    }

    public HelpInfo getHelpInfo() {
        if (this.getDiagram() != null) {
            return this.getDiagram().getHelpInfo();
        }
        return super.getHelpInfo();
    }

    public Component getFixedTopMargin() {
        if (this.getDiagrams().length == 1) {
            ToolbarPlugin plugin = this.getDiagrams()[0].getDiagramContext().getPlugin(ToolbarPlugin.class);
            if (plugin != null) {
                Toolbar tb = plugin.getToolbar();
                if (tb == null) {
                    plugin.createToolbar((View)this);
                    tb = plugin.getToolbar();
                }
                plugin.update(this.getContext());
                if (this._toolbarParent != null && this._toolbarParent.equals(tb.getParent())) {
                    this._toolbarParent.remove((Component)tb);
                    this._toolbarParent = null;
                }
                return tb;
            }
            if (!this.isContentModelLoaded()) {
                this._toolbarParent = new JPanel(new BorderLayout());
                this._toolbarParent.setOpaque(false);
                return this._toolbarParent;
            }
            return null;
        }
        return super.getFixedTopMargin();
    }

    public Toolbar getToolbar() {
        ToolbarPlugin plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (plugin != null) {
            Toolbar tb = plugin.getToolbar();
            return tb;
        }
        return null;
    }

    protected void switchEditorGUI(Component newEditorGUI) {
        if (newEditorGUI != null) {
            JComponent oldEditorGUI = (JComponent)this.getGUI();
            if (oldEditorGUI == newEditorGUI) {
                oldEditorGUI = (JComponent)this.getEditorNotInitializedGUI();
            }
            if (oldEditorGUI != null) {
                IdeMainWindow mainWindow;
                Component newFocusComp;
                JComponent oldFocusComp;
                boolean transferFocus = this.isActivated();
                String name = oldEditorGUI.getName();
                if (name == null && (oldFocusComp = GraphicsUtils.getFocusableComponentOrChild((Component)oldEditorGUI, (boolean)true)) != null) {
                    name = oldFocusComp.getName();
                }
                if (newEditorGUI.getName() == null) {
                    newEditorGUI.setName(name);
                }
                if ((newFocusComp = this.getDefaultFocusComponent()) != null && newFocusComp.getName() == null) {
                    newFocusComp.setName(name);
                }
                oldEditorGUI.removeAll();
                oldEditorGUI.setLayout(new BorderLayout());
                oldEditorGUI.add(newEditorGUI, "Center");
                if (this._toolbarParent != null) {
                    ToolbarPlugin plugin;
                    Toolbar tb = this.getToolbar();
                    if (tb == null && (plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class)) != null) {
                        plugin.createToolbar((View)this);
                        tb = plugin.getToolbar();
                        plugin.update(this.getContext());
                    }
                    if (tb != null) {
                        this._toolbarParent.add((Component)tb, "Center");
                    }
                }
                if (this._settings != null) {
                    this.loadSettingsImpl(this._settings);
                    this._settings = null;
                }
                if ((mainWindow = Ide.getMainWindow()) instanceof MainWindowImpl) {
                    EventListener[] listeners;
                    ActiveViewEvent e = new ActiveViewEvent((Object)this, (View)this, (View)this);
                    for (EventListener l : listeners = mainWindow.getListeners(ActiveViewListener.class)) {
                        String lname = l.getClass().getName();
                        if (!lname.startsWith("oracle.ideimpl.MainWindowImpl") && !lname.startsWith("oracle.ide.thumbnail.ThumbnailDockable")) continue;
                        ((ActiveViewListener)l).activeViewChanged(e);
                    }
                }
                this.forceViewSelectionChange();
                if (transferFocus && this.getDefaultFocusComponent() != null) {
                    this.getDefaultFocusComponent().requestFocus();
                }
            }
        }
    }

    protected Diagram getDiagram() {
        return this.getDiagrams()[0];
    }

    protected final Diagram[] getDiagrams() {
        return this._diagrams;
    }

    protected int addDiagram(Diagram diagram) {
        return this.addDiagram(diagram, this._diagrams.length);
    }

    protected int addDiagram(Diagram diagram, int index) {
        Diagram[] old = this._diagrams;
        int insertPoint = index > old.length ? old.length : (index < 0 ? 0 : index);
        Diagram[] tmp = new Diagram[old.length + 1];
        System.arraycopy(old, 0, tmp, 0, insertPoint);
        System.arraycopy(old, insertPoint, tmp, insertPoint + 1, old.length - insertPoint);
        tmp[insertPoint] = diagram;
        this._diagrams = tmp;
        if (this._editorState == State.CREATED || this._editorState == State.CLOSED) {
            return insertPoint;
        }
        if (this._editorState == State.CONTEXT_SET || this._editorState == State.OPENED || this._editorState == State.GET_GUI_CALLED) {
            Context c = super.getContext(null);
            this.setDiagramContext(diagram, c, new Context(c));
        }
        if (this._editorState == State.OPENED || this._editorState == State.GET_GUI_CALLED) {
            this.openDiagram(diagram);
        }
        if (this._editorState == State.GET_GUI_CALLED) {
            this.addDiagramGUI(diagram, insertPoint);
        }
        return insertPoint;
    }

    protected int removeDiagram(Diagram diagram) {
        int index;
        Diagram[] old = this._diagrams;
        if (old.length < 2) {
            throw new IllegalArgumentException("Unable to remove the last diagram");
        }
        for (index = old.length - 1; index >= 0 && old[index] != diagram; --index) {
        }
        int removePoint = index;
        Diagram[] tmp = new Diagram[old.length - 1];
        System.arraycopy(old, 0, tmp, 0, index);
        System.arraycopy(old, index + 1, tmp, index, old.length - index - 1);
        this._diagrams = tmp;
        if (this._editorState == State.GET_GUI_CALLED) {
            this.removeDiagramGUI(diagram, removePoint);
        }
        diagram.close();
        return removePoint;
    }

    protected void addDiagramGUI(Diagram diagram, int insertIndex) {
    }

    protected void removeDiagramGUI(Diagram diagram, int removeIndex) {
    }

    protected synchronized Context getBaseContext() {
        return this.getBaseContext(null);
    }

    protected synchronized Context getBaseContext(EventObject event) {
        return super.getContext(event);
    }

    public synchronized Context getContext(EventObject event) {
        Context c = this.getDiagram().getContext();
        if (c != null) {
            Node node;
            c.setEvent(event);
            c.setSelection(null);
            Element[] sel = this.getSelection();
            if ((sel == null || sel.length == 0) && (node = c.getNode()) != null) {
                sel = new Element[]{node};
            }
            c.setSelection(sel);
        } else {
            c = super.getContext(event);
        }
        return c;
    }

    public void addThumbnailClientListener(ThumbnailClientListener listener) {
        this._thumbnailClientDelegate.addThumbnailClientListener(listener);
    }

    public void removeThumbnailClientListener(ThumbnailClientListener listener) {
        this._thumbnailClientDelegate.removeThumbnailClientListener(listener);
    }

    protected boolean isContentModelLoaded() {
        return this._contentLoaded;
    }

    private void forceViewSelectionChange() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewSelectionHack vsh = new ViewSelectionHack();
                    IdeDiagramEditor.this.addViewSelectionListener(vsh);
                    try {
                        vsh.reset();
                        IdeDiagramEditor.this.updateSelection();
                    }
                    finally {
                        IdeDiagramEditor.this.removeViewSelectionListener(vsh);
                        if (!vsh.isTriggered()) {
                            IdeDiagramEditor.this.fireViewSelectionChanged(new ViewSelectionEvent((View)IdeDiagramEditor.this));
                        }
                    }
                }
            });
        } else {
            this.addViewSelectionListener(this._vsh);
            try {
                this._vsh.reset();
                this.updateSelection();
            }
            finally {
                this.removeViewSelectionListener(this._vsh);
                if (!this._vsh.isTriggered()) {
                    this.fireViewSelectionChanged(new ViewSelectionEvent((View)this));
                }
            }
        }
    }

    static {
        InspectorFactory.getInstance().addInspectableFactory(new InspectableFactory(){

            public Inspectable getInspectable(Context originalContext) {
                View view = (View)originalContext.getProperty("oracle.diagram.inspector.ActiveInspectedView");
                if (view instanceof IdeDiagramEditor) {
                    IdeDiagramEditor editor = (IdeDiagramEditor)view;
                    InspectorPlugin ip = PluginUtil.getPlugin(editor.getActiveManagerView(), InspectorPlugin.class);
                    DiagramIdeSelectionPlugin isp = PluginUtil.getPlugin(editor.getActiveManagerView(), DiagramIdeSelectionPlugin.class);
                    if (ip != null && isp != null) {
                        Context context = new Context(originalContext);
                        Element[] inspectorSelection = isp.getInspectorSelection();
                        if (inspectorSelection != null && inspectorSelection.length != 0) {
                            context.setProperty("oracle.diagram.inspector.InspectorSelectionProperty", (Object)inspectorSelection);
                            originalContext.setProperty("oracle.diagram.inspector.InspectorSelectionProperty", (Object)inspectorSelection);
                        }
                        return ip.getInspectable(context);
                    }
                }
                return null;
            }
        });
    }

    private static enum State {
        CREATED,
        CONTEXT_SET,
        OPENED,
        GET_GUI_CALLED,
        CLOSED;

    }

    private class PaletteEventDispatchPlugin
    extends AbstractPlugin {
        private final EditorPaletteEventDispatch _helper;

        public PaletteEventDispatchPlugin(EditorPaletteEventDispatch dispatch) {
            this._helper = dispatch;
        }

        public final EditorPaletteEventDispatch getPaletteEventHelper() {
            return this._helper;
        }

        @Override
        public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
            super.attach(pluginManager, pluginType);
            this._helper.attachToPalette();
        }

        @Override
        public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
            this._helper.detachFromPalette();
            super.detach(pluginManager, pluginType);
        }
    }

    private class HostController
    extends ControllerChain {
        public HostController(Controller ... delegates) {
            super(delegates);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (IdeDiagramEditor.this.getDiagram() != null) {
                if (!IdeDiagramEditor.this.getDiagram().getController().handleEvent(action, context)) {
                    return super.handleEvent(action, context);
                }
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (IdeDiagramEditor.this.getDiagram() != null) {
                if (!IdeDiagramEditor.this.getDiagram().getController().update(action, context)) {
                    return super.update(action, context);
                }
                return true;
            }
            return super.update(action, context);
        }
    }

    private static class ViewSelectionHack
    implements ViewSelectionListener {
        private boolean m_triggered = false;

        private ViewSelectionHack() {
        }

        public void viewSelectionChanged(ViewSelectionEvent e) {
            this.m_triggered = true;
        }

        public void reset() {
            this.m_triggered = false;
        }

        public boolean isTriggered() {
            return this.m_triggered;
        }
    }

    private class SelectionPlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private int _disabled = 0;
        private boolean selectionChangedWhileDisabled = false;

        private SelectionPlugin() {
        }

        @Override
        public void selectionChanged(DiagramContext context) {
            boolean isEnabled = this.isEnabled();
            boolean bl = this.selectionChangedWhileDisabled = !isEnabled;
            if (!isEnabled) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                DiagramIdeSelectionPlugin dsp = context.getPlugin(DiagramIdeSelectionPlugin.class);
                Element[] cachedSelection = dsp.getSelection();
                Element[] cachedInspectorSelection = dsp.getInspectorSelection();
                dsp.fetchSelectionFromUI();
                Element[] newSelection = dsp.getSelection();
                Element[] newInspectorSelection = dsp.getInspectorSelection();
                if (cachedSelection.length == newSelection.length && cachedInspectorSelection.length == newInspectorSelection.length && this.isEqual(cachedSelection, newSelection) && this.isEqual(cachedInspectorSelection, newInspectorSelection)) {
                    return;
                }
            }
            IdeDiagramEditor.this.forceViewSelectionChange();
        }

        private boolean isEqual(Element[] array1, Element[] array2) {
            boolean isSame = true;
            for (Element tmp1 : array1) {
                boolean isEqual = false;
                for (Element te2 : array2) {
                    if (!tmp1.equals(te2)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                isSame = false;
                break;
            }
            return isSame;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (!enabled) {
                ++this._disabled;
            } else if (this._disabled > 0) {
                --this._disabled;
                if (this.isEnabled() && this.selectionChangedWhileDisabled) {
                    this.selectionChangedWhileDisabled = false;
                    IdeDiagramEditor.this.forceViewSelectionChange();
                }
            } else {
                throw new IllegalStateException("error: Mismatch between setEnabled(true) and setEnabled(false) calls");
            }
        }

        @Override
        public boolean isEnabled() {
            return this._disabled == 0;
        }
    }

    private class ContextPlugin
    extends AbstractPlugin
    implements IdeContextPlugin {
        private ContextPlugin() {
        }

        @Override
        public Context getContext() {
            return IdeDiagramEditor.super.getContext(null);
        }
    }
}

