/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.row;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.manager.ManagerUtil;

public class RowLayout
extends AbstractLayout {
    public void layoutGroup(IlvAttachable parent) {
        IlvRect bounds = new IlvRect(((IlvAttachableGraphic)parent).getGraphic().boundingBox(null));
        IlvGraphic parentGraphic = ((IlvAttachableGraphic)parent).getGraphic();
        bounds.x += this.getLeftMargin();
        bounds.width = bounds.width - this.getLeftMargin() - this.getRightMargin();
        bounds.y += this.getTopMargin();
        bounds.height = bounds.height - this.getTopMargin() - this.getBottomMargin();
        IlvAttachable[] children = parent.getAttachables();
        float y = bounds.y;
        for (IlvAttachable child : children) {
            IlvRect childBBox;
            IlvGraphic g = ((IlvAttachableGraphic)child).getGraphic();
            if (g instanceof ExtendedGraphic) {
                childBBox = new IlvRect(g.boundingBox(null));
                DimensionFloat d = ((ExtendedGraphic)g).getPreferedSize(new DimensionFloat());
                IlvRect r = new IlvRect(bounds);
                r.height = d.height;
                r.x = bounds.x;
                r.y = y;
                if (childBBox.width != r.width || childBBox.height != r.height || childBBox.x != r.x || childBBox.y != r.y) {
                    child.move(r.x, r.y);
                    child.resize(new IlvPoint(r.width, r.height));
                    g.moveResize(r);
                }
                y += r.height;
                continue;
            }
            if (!(g instanceof IlvLine)) continue;
            childBBox = new IlvRect(child.getAttachmentBounds());
            IlvLine divider = (IlvLine)g;
            float width = divider.getLineWidth();
            float x0 = bounds.x;
            float x1 = bounds.x + bounds.width - 1.0f;
            float y0 = y;
            if (width > 1.0f) {
                y0 += width / 2.0f;
                x0 += width / 2.0f;
                x1 -= width / 2.0f;
            }
            divider.setFrom(new IlvPoint(x0, y0));
            divider.setTo(new IlvPoint(x1, y0));
            IlvManager mgr = ManagerUtil.getManager(parentGraphic);
            if (mgr != null) {
                mgr.invalidateRegion(childBBox);
            }
            y += width;
        }
        this.fireLayoutPerformed(((IlvAttachableGraphic)parent).getGraphic());
    }
}

