/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import oracle.diagram.framework.highlight.HighlightHelper;
import oracle.diagram.framework.notification.Notification;

public abstract class MultiSpotHighlightHelper
implements HighlightHelper {
    private static final String HIGHLIGHTABLE_ID_SET = "oracle.diagram.framework.highlight.highlightableIdSet";

    @Override
    public void drawHighlighted(Graphics2D graphics2D, IlvManager mgr, IlvGraphic graphic, IlvRect rect, IlvTransformer t) {
        Collection highlightableIDs = (Collection)graphic.getProperty(HIGHLIGHTABLE_ID_SET);
        if (highlightableIDs == null || highlightableIDs.isEmpty()) {
            return;
        }
        for (String highlightableID : highlightableIDs) {
            this.drawHighlightableSpot(graphics2D, mgr, graphic, rect, t, highlightableID);
        }
    }

    @Override
    public boolean shouldHighlight(Notification notification, IlvGraphic graphic) {
        Set highlightableIDs = this.getHighlightableSpotIDs(notification, graphic);
        if (highlightableIDs == null) {
            highlightableIDs = Collections.EMPTY_SET;
        }
        graphic.setProperty(HIGHLIGHTABLE_ID_SET, (Object)highlightableIDs);
        return !highlightableIDs.isEmpty();
    }

    @Override
    public void willUnhighlightGraphic(IlvGraphic g) {
        g.removeProperty(HIGHLIGHTABLE_ID_SET);
    }

    @Override
    public boolean shouldHighlightDefault(IlvGraphic ilvGraphic) {
        return false;
    }

    @Override
    public void willHighlightGraphic(IlvGraphic g) {
    }

    protected abstract Set<String> getHighlightableSpotIDs(Notification var1, IlvGraphic var2);

    protected abstract void drawHighlightableSpot(Graphics2D var1, IlvManager var2, IlvGraphic var3, IlvRect var4, IlvTransformer var5, String var6);
}

