/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.interaction.MoveGraphicsHelper;
import oracle.diagram.framework.interaction.MoveGraphicsHelperProvider;
import oracle.diagram.framework.interaction.MoveGraphicsPlugin;

public class DefaultMoveGraphicsPlugin
extends AbstractPlugin
implements MoveGraphicsPlugin {
    private DiagramContext _context;
    private LinkedList<MoveGraphicsHelperProvider> _providers;

    public DefaultMoveGraphicsPlugin(DiagramContext context) {
        this._context = context;
        this._providers = new LinkedList();
    }

    public void addMoveGraphicsHelperProvider(MoveGraphicsHelperProvider provider) {
        if (!this._providers.contains(provider)) {
            this._providers.add(provider);
        }
    }

    public void removeMoveGraphicsHelperProvider(MoveGraphicsHelperProvider provider) {
        if (this._providers.contains(provider)) {
            this._providers.remove(provider);
        }
    }

    @Override
    public List<MoveGraphicsHelper> createMoveGraphicsHelpers(Set<IlvGraphic> graphics) {
        LinkedList<MoveGraphicsHelper> helpers = new LinkedList<MoveGraphicsHelper>();
        for (MoveGraphicsHelperProvider provider : this._providers) {
            MoveGraphicsHelper helper = provider.createMoveGraphicsHelper(graphics);
            if (helper == null) continue;
            helpers.add(helper);
        }
        return helpers;
    }
}

