/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStoreListener;
import oracle.diagram.framework.preference.event.PreferenceStoreEvent;

public class MultiPreferenceStore
implements PreferenceStore {
    private final List<PreferenceStoreListener> _listeners = new ArrayList<PreferenceStoreListener>();
    private List<PreferenceStore> _stores = new ArrayList<PreferenceStore>(32);
    private List<PreferenceDefinition[]> _defs = new ArrayList<PreferenceDefinition[]>(32);
    private boolean _rebuild = true;
    private final Map<PreferenceDefinition, List<PreferenceStore>> _storesByPref = new LinkedHashMap<PreferenceDefinition, List<PreferenceStore>>();
    private final Map<PreferenceDefinition, Object> _conflictMap = new HashMap<PreferenceDefinition, Object>();
    private PreferenceDefinition[] _supportedPrefs = null;

    public void addPreferenceStore(PreferenceStore ps, PreferenceDefinition[] pd) {
        this._stores.add(ps);
        this._defs.add(pd);
        this._rebuild = true;
    }

    public PreferenceDefinition[] getSupportedPreferences() {
        this.rebuildIfRequired();
        return this._supportedPrefs;
    }

    @Override
    public void addPreferenceStoreListener(PreferenceStoreListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removePreferenceStoreListener(PreferenceStoreListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        this.rebuildIfRequired();
        return !this._storesByPref.get(preference.getRootDefinition()).isEmpty();
    }

    public boolean hasConflictingValues(PreferenceDefinition preference) {
        this.rebuildIfRequired();
        return this._conflictMap.containsKey(preference.getRootDefinition());
    }

    public boolean isCommon(PreferenceDefinition preference) {
        this.rebuildIfRequired();
        List<PreferenceStore> stores = this._storesByPref.get(preference.getRootDefinition());
        if (stores == null) {
            return true;
        }
        return stores.size() == this._stores.size();
    }

    @Override
    public Object getPreferenceValue(PreferenceDefinition preference) {
        this.rebuildIfRequired();
        if (this._conflictMap.containsKey(preference.getRootDefinition())) {
            return this._conflictMap.get(preference.getRootDefinition());
        }
        List<PreferenceStore> stores = this._storesByPref.get(preference.getRootDefinition());
        if (!stores.isEmpty()) {
            return stores.get(0).getPreferenceValue(preference.getRootDefinition());
        }
        return null;
    }

    @Override
    public Object setPreferenceValue(PreferenceDefinition preference, Object value) {
        Object oldValue = this.getPreferenceValue(preference);
        Object newValue = this.setPreferenceValueImpl(preference, value);
        this.firePreferenceChange(new PreferenceDefinition[]{preference}, new Object[]{oldValue}, new Object[]{newValue});
        return newValue;
    }

    protected Object setPreferenceValueImpl(PreferenceDefinition pd, Object value) {
        this.rebuildIfRequired();
        Object result = null;
        List<PreferenceStore> stores = this._storesByPref.get(pd.getRootDefinition());
        if (!stores.isEmpty()) {
            boolean first = true;
            for (PreferenceStore ps : stores) {
                Object tmp = ps.setPreferenceValue(pd.getRootDefinition(), value);
                if (!first) continue;
                first = false;
                result = tmp;
            }
        }
        this._conflictMap.remove(pd.getRootDefinition());
        return result;
    }

    @Override
    public void setPreferenceValues(PreferenceDefinition[] preferences, Object[] values) {
        this.rebuildIfRequired();
        Object[] oldValues = new Object[values.length];
        for (int i = 0; i < preferences.length; ++i) {
            oldValues[i] = this.setPreferenceValueImpl(preferences[i], values[i]);
        }
        this.firePreferenceChange(preferences, oldValues, values);
    }

    protected void rebuildIfRequired() {
        if (!this._rebuild) {
            return;
        }
        this._storesByPref.clear();
        for (PreferenceDefinition[] pds : this._defs) {
            for (PreferenceDefinition pd : pds) {
                PreferenceDefinition root = pd.getRootDefinition();
                if (this._storesByPref.containsKey(root)) continue;
                this._storesByPref.put(root, new ArrayList(32));
            }
        }
        int isize = this._stores.size();
        for (int i = 0; i < isize; ++i) {
            PreferenceDefinition[] defs;
            PreferenceStore store = this._stores.get(i);
            for (PreferenceDefinition pd : defs = this._defs.get(i)) {
                if (!store.hasPreferenceValue(pd)) continue;
                this._storesByPref.get(pd.getRootDefinition()).add(store);
            }
        }
        Set<PreferenceDefinition> keys = this._storesByPref.keySet();
        ArrayList<PreferenceDefinition> usedKeys = new ArrayList<PreferenceDefinition>(keys.size());
        for (PreferenceDefinition pd : keys) {
            if (this._storesByPref.get(pd).isEmpty()) continue;
            usedKeys.add(pd);
        }
        this._supportedPrefs = usedKeys.toArray(new PreferenceDefinition[usedKeys.size()]);
        Object baseValue = null;
        boolean hadValue = false;
        for (PreferenceDefinition pd : this._supportedPrefs) {
            List<PreferenceStore> stores = this._storesByPref.get(pd);
            hadValue = false;
            for (PreferenceStore ps : stores) {
                Object tmpValue = ps.getPreferenceValue(pd);
                if (!hadValue) {
                    baseValue = tmpValue;
                    hadValue = true;
                    continue;
                }
                if (tmpValue == null && baseValue == null || baseValue != null && tmpValue != null && baseValue.equals(tmpValue)) continue;
                this._conflictMap.put(pd, baseValue);
            }
        }
        this._rebuild = false;
    }

    protected final void firePreferenceChange(PreferenceDefinition[] prefs, Object[] oldValues, Object[] newValues) {
        PreferenceStoreListener[] copy;
        PreferenceStoreEvent event = new PreferenceStoreEvent(this, prefs, oldValues, newValues);
        for (PreferenceStoreListener l : copy = this._listeners.toArray(new PreferenceStoreListener[this._listeners.size()])) {
            try {
                l.preferenceStoreChanged(event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

