/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.print;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.Locale;

public final class DefaultPageFormat {
    private static final DefaultPageFormat INSTANCE = new DefaultPageFormat();
    private PageFormat _formatPortrait = null;
    private PageFormat _formatLandscape = null;
    private PageFormat _formatReverseLandscape = null;
    private final Object _sync = new Object();
    private final Thread _initThread = new Thread((Runnable)new InitRunnable(), "Default Page Size");

    public static DefaultPageFormat getInstance() {
        return INSTANCE;
    }

    private DefaultPageFormat() {
    }

    public synchronized void initialize() {
        this.initialize(false);
    }

    protected synchronized void initialize(boolean wait) {
        if (this._initThread.getState() == Thread.State.NEW) {
            this._initThread.start();
        }
        while (wait && this._initThread.isAlive()) {
            try {
                this._initThread.join();
                break;
            }
            catch (InterruptedException e) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageFormat getPageFormat(int type) {
        this.initialize(true);
        Object object = this._sync;
        synchronized (object) {
            switch (type) {
                case 0: {
                    return (PageFormat)this._formatLandscape.clone();
                }
                case 2: {
                    return (PageFormat)this._formatReverseLandscape.clone();
                }
            }
            return (PageFormat)this._formatPortrait.clone();
        }
    }

    private void initializeFormats(PageFormat pf) {
        this._formatPortrait = (PageFormat)pf.clone();
        this._formatPortrait.setOrientation(1);
        this._formatLandscape = (PageFormat)pf.clone();
        this._formatLandscape.setOrientation(0);
        this._formatReverseLandscape = (PageFormat)pf.clone();
        this._formatReverseLandscape.setOrientation(2);
    }

    private static PageFormat getFactoryDefaultFormat() {
        PageFormat format = new PageFormat();
        if (Locale.getDefault().equals(Locale.US)) {
            Paper paper = new Paper();
            paper.setSize(612.0, 792.0);
            paper.setImageableArea(72.0, 72.0, 540.0, 720.0);
            format.setPaper(paper);
            format.setOrientation(1);
        } else {
            Paper paper = new Paper();
            paper.setSize(DefaultPageFormat.mm2Points(210.0), DefaultPageFormat.mm2Points(297.0));
            paper.setImageableArea(DefaultPageFormat.mm2Points(12.5), DefaultPageFormat.mm2Points(12.5), DefaultPageFormat.mm2Points(185.0), DefaultPageFormat.mm2Points(272.0));
            format.setPaper(paper);
            format.setOrientation(1);
        }
        return format;
    }

    private static final double mm2Points(double mm) {
        return mm / 25.4 * 72.0;
    }

    private class InitRunnable
    implements Runnable {
        private InitRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DefaultPageFormat.this._sync;
            synchronized (object) {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (job.getPrintService() != null) {
                        DefaultPageFormat.this.initializeFormats(job.defaultPage());
                    } else {
                        DefaultPageFormat.this.initializeFormats(DefaultPageFormat.getFactoryDefaultFormat());
                    }
                }
                catch (Exception ex) {
                    DefaultPageFormat.this.initializeFormats(DefaultPageFormat.getFactoryDefaultFormat());
                }
            }
        }
    }
}

