/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.readonly;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import java.awt.datatransfer.Transferable;
import oracle.diagram.core.util.GenericContext;

public class ModificationContext
extends GenericContext {
    protected static final String PREFIX = "oracle.diagram.";
    protected static final String GRAPHIC_PROPERTY = "oracle.diagram.IlvGraphic";
    protected static final String MULTIPLE_GRAPHICS_PROPERTY = "oracle.diagram.Multiple-IlvGraphics";
    protected static final String SUB_GRAPHIC_PROPERTY = "oracle.diagram.Sub-IlvGraphic";
    protected static final String CREATION_GRAPHIC_PROPERTY = "oracle.diagram.Creation-IlvGraphic";
    protected static final String FROM_GRAPHIC_PROPERTY = "oracle.diagram.From-IlvGraphic";
    protected static final String TO_GRAPHIC_PROPERTY = "oracle.diagram.To-IlvGraphic";
    protected static final String OLD_TARGET_PROPERTY = "oracle.diagram.Old-Target";
    protected static final String NEW_TARGET_PROPERTY = "oracle.diagram.New-Target";
    protected static final String IS_SOURCE_TARGET_PROPERTY = "oracle.diagram.Is-Source-Target";
    protected static final String TRANSFERABLE_PROPERTY = "oracle.diagram.Transferable";

    protected ModificationContext() {
    }

    public static class DropContext
    extends TransferContext {
        public DropContext(IlvGraphic target, Transferable transferable) {
            super(transferable);
            this.setProperty(ModificationContext.GRAPHIC_PROPERTY, target);
        }

        @Override
        public Transferable getTransferable() {
            return (Transferable)this.getProperty(ModificationContext.TRANSFERABLE_PROPERTY);
        }

        public IlvGraphic getTargetGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.GRAPHIC_PROPERTY);
        }
    }

    public static class PasteContext
    extends TransferContext {
        public PasteContext(Transferable transferable) {
            super(transferable);
        }
    }

    public static class TransferContext
    extends ModificationContext {
        public TransferContext(Transferable transferable) {
            this.setProperty(ModificationContext.TRANSFERABLE_PROPERTY, transferable);
        }

        public Transferable getTransferable() {
            return (Transferable)this.getProperty(ModificationContext.TRANSFERABLE_PROPERTY);
        }
    }

    public static class CutContext
    extends MultipleGraphicsContext {
        public CutContext(IlvGraphic ... graphics) {
            super(graphics);
        }
    }

    public static class DeleteContext
    extends GraphicContext {
        public DeleteContext(IlvGraphic graphic) {
            super(graphic);
        }
    }

    public static class ReconnectLinkContext
    extends GraphicContext {
        public ReconnectLinkContext(IlvLinkImage link, IlvGraphic oldTarget, IlvGraphic newTarget, boolean isSource) {
            super((IlvGraphic)link);
            this.setProperty(ModificationContext.OLD_TARGET_PROPERTY, oldTarget);
            this.setProperty(ModificationContext.NEW_TARGET_PROPERTY, newTarget);
            this.setProperty(ModificationContext.IS_SOURCE_TARGET_PROPERTY, isSource);
        }

        public IlvLinkImage getLink() {
            return (IlvLinkImage)this.getGraphic();
        }

        public IlvGraphic getOldTarget() {
            return (IlvGraphic)this.getProperty(ModificationContext.OLD_TARGET_PROPERTY);
        }

        public IlvGraphic getNewTarget() {
            return (IlvGraphic)this.getProperty(ModificationContext.NEW_TARGET_PROPERTY);
        }

        public boolean isReconnectingSource() {
            return this.getBooleanProperty(ModificationContext.IS_SOURCE_TARGET_PROPERTY, true);
        }
    }

    public static class CreateLinkContext
    extends CreateGraphicContext {
        public CreateLinkContext(IlvGraphic parent, IlvGraphic link, IlvGraphic from, IlvGraphic to) {
            super(parent);
            this.setProperty(ModificationContext.CREATION_GRAPHIC_PROPERTY, link);
            this.setProperty(ModificationContext.FROM_GRAPHIC_PROPERTY, from);
            this.setProperty(ModificationContext.TO_GRAPHIC_PROPERTY, to);
        }

        public IlvGraphic getCreationGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.CREATION_GRAPHIC_PROPERTY);
        }

        public IlvGraphic getFromGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.FROM_GRAPHIC_PROPERTY);
        }

        public IlvGraphic getToGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.TO_GRAPHIC_PROPERTY);
        }
    }

    public static class CreateNodeContext
    extends CreateGraphicContext {
        public CreateNodeContext(IlvGraphic parent) {
            super(parent);
        }
    }

    public static abstract class CreateGraphicContext
    extends GraphicContext {
        protected CreateGraphicContext(IlvGraphic parent) {
            super(parent);
        }

        public IlvGraphic getParent() {
            return this.getGraphic();
        }
    }

    public static class EditContext
    extends GraphicContext {
        public EditContext(IlvGraphic graphic) {
            super(graphic);
        }

        public EditContext(IlvGraphic graphic, IlvGraphic subGraphic) {
            super(graphic);
            this.setProperty(ModificationContext.SUB_GRAPHIC_PROPERTY, subGraphic);
        }

        public IlvGraphic getSubGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.SUB_GRAPHIC_PROPERTY);
        }
    }

    public static class ReshapeLinkContext
    extends GraphicContext {
        public ReshapeLinkContext(IlvLinkImage link) {
            super((IlvGraphic)link);
        }

        public IlvLinkImage getLink() {
            return (IlvLinkImage)this.getGraphic();
        }
    }

    public static class ResizeNodeContext
    extends GraphicContext {
        public ResizeNodeContext(IlvGraphic node) {
            super(node);
        }
    }

    public static class MoveGraphicsContext
    extends MultipleGraphicsContext {
        public MoveGraphicsContext(IlvGraphic ... graphics) {
            super(graphics);
        }
    }

    public static class MultipleGraphicsContext
    extends ModificationContext {
        public MultipleGraphicsContext(IlvGraphic ... graphics) {
            this.setProperty(ModificationContext.MULTIPLE_GRAPHICS_PROPERTY, graphics);
        }

        public IlvGraphic[] getGraphics() {
            return (IlvGraphic[])this.getProperty(ModificationContext.MULTIPLE_GRAPHICS_PROPERTY);
        }
    }

    public static class GraphicContext
    extends ModificationContext {
        public GraphicContext(IlvGraphic graphic) {
            this.setProperty(ModificationContext.GRAPHIC_PROPERTY, graphic);
        }

        public IlvGraphic getGraphic() {
            return (IlvGraphic)this.getProperty(ModificationContext.GRAPHIC_PROPERTY);
        }
    }

    public static enum OperationCode {
        EditorOnly,
        MoveGraphics,
        ResizeNode,
        ReshapeLink,
        Edit,
        CreateNode,
        CreateLink,
        Delete,
        ReconnectLink,
        Cut,
        Paste,
        Drop,
        Layout,
        AddToDiagram;

    }
}

