/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.graphic.layout.LayoutListener;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneLayoutListener;

public abstract class SwimlanesGraphicManager {
    private HashMap<IlvManager, Listener> _listeners = new HashMap();
    protected static final String PROPERTY_OFFSET = "SwimlanesGraphicManager.Property.OFFSET";

    public void setTopSwimlane(IlvManager mgr, SwimlaneGraphic sg) {
        if (this._listeners.get(mgr) != null) {
            Listener current = this._listeners.get(mgr);
            current.cleanUp();
            this._listeners.remove(mgr);
        }
        if (sg != null) {
            Listener newListener = new Listener(mgr, sg);
            this._listeners.put(mgr, newListener);
            ((AbstractLayout)sg.getLayout()).addLayoutListener(newListener);
        }
    }

    public void addGraphicToSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
        IlvRect gbbox = g.boundingBox(null);
        IlvRect sgbbox = sg.getInteriorBoundingBox(null);
        IlvPoint p = new IlvPoint(gbbox.x - sgbbox.x, gbbox.y - sgbbox.y);
        g.setProperty(PROPERTY_OFFSET, (Object)p);
    }

    protected final Listener getListener(IlvManager mgr) {
        return this._listeners.get(mgr);
    }

    protected abstract Collection<IlvGraphic> getGraphicsInSwimlane(SwimlaneGraphic var1);

    protected abstract SwimlaneGraphic getSwimlaneForGraphic(IlvGraphic var1);

    protected void updateOffsets(SwimlaneGraphic sg) {
        SwimlaneGraphic pool;
        Collection<IlvGraphic> graphics = this.getGraphicsInSwimlane(sg);
        if (graphics != null) {
            IlvRect sgbbox = sg.getInteriorBoundingBox(null);
            for (IlvGraphic g : graphics) {
                IlvRect gbbox = g.boundingBox(null);
                IlvPoint p = new IlvPoint(gbbox.x - sgbbox.x, gbbox.y - sgbbox.y);
                g.setProperty(PROPERTY_OFFSET, (Object)p);
            }
        }
        if (sg instanceof PoolGraphic) {
            pool = (PoolGraphic)sg;
            List<SwimlaneGraphic> lanes = pool.getLanes();
            for (SwimlaneGraphic lane : lanes) {
                this.updateOffsets(lane);
            }
        } else if (sg instanceof ExtendedSwimlaneGraphic && (pool = ((ExtendedSwimlaneGraphic)sg).getPool()) != null) {
            this.updateOffsets(pool);
        }
    }

    protected void translateContents(SwimlaneGraphic sg) {
        SwimlaneGraphic pool;
        Collection<IlvGraphic> children;
        if (!sg.isValid()) {
            sg.doLayout();
        }
        if ((children = this.getGraphicsInSwimlane(sg)) != null && !children.isEmpty()) {
            IlvRect topSGRect = sg.getTopSwimlane().getInteriorBoundingBox(null);
            IlvRect sgRect = sg.getInteriorBoundingBox(null);
            HashSet<IlvLinkImage> movedLinks = new HashSet<IlvLinkImage>();
            for (IlvGraphic g : children) {
                Object prop = g.getProperty(PROPERTY_OFFSET);
                if (prop == null) continue;
                IlvPoint p = (IlvPoint)prop;
                IlvRect gBBox = new IlvRect(g.boundingBox(null));
                float newX = sgRect.x + p.x;
                if (sg.getFlowDirection() == 8) {
                    newX = Math.min(newX, sgRect.x + sgRect.width - 1.0f - gBBox.width);
                }
                float newY = sgRect.y + p.y;
                if (sg.getFlowDirection() == 2) {
                    newY = Math.min(newY, sgRect.y + sgRect.height - 1.0f - gBBox.height);
                }
                float dx = newX - gBBox.x;
                float dy = newY - gBBox.y;
                if (dx == 0.0f && dy == 0.0f) continue;
                IlvManager mgr = ManagerUtil.getManager(g);
                mgr.moveObject(g, newX, newY, false);
                IlvRect oldSGRect = new IlvRect(sgRect);
                oldSGRect.x -= dx;
                oldSGRect.y -= dy;
                for (int j = 0; j < 2; ++j) {
                    IlvGraphicEnumeration iter2;
                    IlvGraphicEnumeration ilvGraphicEnumeration = iter2 = j == 0 ? ((IlvGrapher)mgr).getLinksFrom(g) : ((IlvGrapher)mgr).getLinksTo(g);
                    while (iter2.hasMoreElements()) {
                        IlvLinkImage link = (IlvLinkImage)iter2.nextElement();
                        if (movedLinks.contains(link)) continue;
                        IlvPoint[] oldPoints = link.getLinkPoints(null);
                        if (oldPoints.length > 2) {
                            IlvPoint[] newPoints = new IlvPoint[oldPoints.length];
                            System.arraycopy(oldPoints, 0, newPoints, 0, oldPoints.length);
                            for (int i = 0; i < oldPoints.length; ++i) {
                                if (!oldSGRect.contains((Point2D)newPoints[i])) continue;
                                newPoints[i].x += dx;
                                newPoints[i].y += dy;
                            }
                            link.setIntermediateLinkPoints(newPoints, 1, newPoints.length - 2);
                        }
                        movedLinks.add(link);
                    }
                }
            }
        }
        if (sg instanceof PoolGraphic) {
            pool = (PoolGraphic)sg;
            List<SwimlaneGraphic> lanes = pool.getLanes();
            for (SwimlaneGraphic lane : lanes) {
                this.translateContents(lane);
            }
        } else if (sg instanceof ExtendedSwimlaneGraphic && (pool = ((ExtendedSwimlaneGraphic)sg).getPool()) != null) {
            this.translateContents(pool);
        }
    }

    private class Listener
    implements LayoutListener,
    Runnable,
    SwimlaneLayoutListener,
    ManagerContentChangedListener {
        private IlvManager _mgr;
        private SwimlaneGraphic _sg;
        boolean _ignoreManagerEvents;
        boolean _isCorrectSize;

        public Listener(IlvManager mgr, SwimlaneGraphic sg) {
            this._mgr = mgr;
            this._sg = sg;
            this._isCorrectSize = false;
            this.layoutPerformed((IlvGraphic)this._sg);
        }

        public void cleanUp() {
            ((AbstractLayout)this._sg.getLayout()).removeLayoutListener(this);
            this._sg.removeLayoutListener(this);
            this._mgr.removeManagerContentChangedListener((ManagerContentChangedListener)this);
            this._ignoreManagerEvents = true;
            this._mgr = null;
            this._sg = null;
        }

        @Override
        public void layoutPerformed(IlvGraphic container) {
            if (this._sg != null && !this._isCorrectSize) {
                IlvRect newBBox = this._sg.boundingBox(null);
                DimensionFloat prefSize = this._sg.getPreferedSize(new DimensionFloat());
                if (newBBox.width >= prefSize.width && newBBox.height >= prefSize.height) {
                    this._isCorrectSize = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void run() {
            if (this._sg != null) {
                ((AbstractLayout)this._sg.getLayout()).removeLayoutListener(this);
                SwimlanesGraphicManager.this.updateOffsets(this._sg);
                this._sg.addLayoutListener(this);
                this._mgr.addManagerContentChangedListener((ManagerContentChangedListener)this);
            }
        }

        @Override
        public void layoutChanged(SwimlaneGraphic swimlane) {
            this._ignoreManagerEvents = true;
            SwimlanesGraphicManager.this.translateContents(this._sg);
            this._ignoreManagerEvents = false;
        }

        public void contentsChanged(ManagerContentChangedEvent evt) {
            SwimlaneGraphic sg;
            ObjectBBoxChangedEvent obbevt;
            IlvGraphic g;
            if (!(this._ignoreManagerEvents || evt.getType() != 4 || (g = (obbevt = (ObjectBBoxChangedEvent)evt).getGraphicObject()) instanceof SwimlaneGraphic || g instanceof IlvLinkImage || (sg = SwimlanesGraphicManager.this.getSwimlaneForGraphic(g)) == null)) {
                IlvRect gbbox = g.boundingBox(null);
                IlvRect sgbbox = sg.getInteriorBoundingBox(null);
                g.setProperty(SwimlanesGraphicManager.PROPERTY_OFFSET, (Object)new IlvPoint(gbbox.x - sgbbox.x, gbbox.y - sgbbox.y));
            }
        }
    }
}

