/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import java.util.List;
import oracle.diagram.framework.testability.ISearchGoal;
import oracle.diagram.framework.testability.ISearchSolution;
import oracle.diagram.framework.testability.ISearchStrategy;
import oracle.diagram.framework.testability.ITreeNode;
import oracle.diagram.framework.testability.ITreeSearch;

abstract class AbstractDepthFirstSearch<T extends ITreeNode<T>>
implements ITreeSearch<T> {
    protected AbstractDepthFirstSearch() {
    }

    @Override
    public boolean search(T startNode, ISearchGoal<T> searchGoal, ISearchStrategy<T> searchStrategy, ISearchSolution<T> solution) {
        if (startNode == null) {
            throw new IllegalArgumentException("Argument startNode must not be null");
        }
        if (searchGoal == null) {
            throw new IllegalArgumentException("Argument searchGoal must not be null");
        }
        if (searchStrategy == null) {
            throw new IllegalArgumentException("Argument searchStrategy must not be null");
        }
        if (solution == null) {
            throw new IllegalArgumentException("Argument solution must not be null");
        }
        boolean b = this.dfsRecursiveSearch(startNode, searchGoal, searchStrategy, solution);
        return b;
    }

    private boolean dfsRecursiveSearch(T startNode, ISearchGoal<T> searchGoal, ISearchStrategy<T> searchStrategy, ISearchSolution<T> solution) {
        if (searchGoal.evaluate(startNode)) {
            solution.found(startNode);
            return true;
        }
        List<T> fringe = searchStrategy.expand(startNode);
        assert (fringe != null);
        for (ITreeNode node : fringe) {
            assert (node != null);
            if (!this.dfsRecursiveSearch(node, searchGoal, searchStrategy, solution)) continue;
            return true;
        }
        return false;
    }
}

