/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPElementReference;
import oracle.diagram.oppparse.OPPInsets;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OPPParseUtil
implements OPPParseConstants {
    private OPPParseUtil() {
    }

    public static final String getNameAttribute(XMLElement xmlSource) {
        return xmlSource.getAttribute("name");
    }

    public static String getValueAttribute(XMLElement xmlSource) {
        return xmlSource.getAttribute("value");
    }

    public static final XMLElement getSingleChild(XMLElement xml, String tag) {
        NodeList children = xml.getChildrenByTagName(tag);
        if (children != null && children.getLength() > 0) {
            return (XMLElement)children.item(0);
        }
        return null;
    }

    public static XMLElement getNamedChild(XMLElement element, String tag, String name) {
        NodeList found = tag != null ? element.getChildrenByTagName(tag) : element.getChildNodes();
        int isize = found.getLength();
        for (int i = 0; i < isize; ++i) {
            XMLElement el;
            Node node = found.item(i);
            if (node.getNodeType() != 1 || !name.equals(OPPParseUtil.getNameAttribute(el = (XMLElement)node))) continue;
            return el;
        }
        return null;
    }

    public static Object parseTypedProperty(XMLElement xmlSource) {
        if (xmlSource == null) {
            return null;
        }
        String type = xmlSource.getLocalName();
        String value = OPPParseUtil.getValueAttribute(xmlSource);
        if ("null".equals(type)) {
            return null;
        }
        if ("integer".equals(type)) {
            return new Integer(value);
        }
        if ("float".equals(type)) {
            return new Float(value);
        }
        if ("boolean".equals(type)) {
            return new Boolean(value);
        }
        if ("long".equals(type)) {
            return new Long(value);
        }
        if ("string".equals(type)) {
            return xmlSource.getText();
        }
        if ("dimension".equals(type)) {
            if (value != null && value.length() > 0) {
                float[] arr = OPPParseUtil.convertStringToFloats(value);
                return new OPPDimension(arr[0], arr[1]);
            }
            return new OPPDimension(Float.parseFloat(xmlSource.getAttribute("width")), Float.parseFloat(xmlSource.getAttribute("height")));
        }
        if ("insets".equals(type)) {
            if (value != null && value.length() > 0) {
                float[] arr = OPPParseUtil.convertStringToFloats(value);
                return new OPPInsets(arr[0], arr[1], arr[2], arr[3]);
            }
            return new OPPInsets(Float.parseFloat(xmlSource.getAttribute("top")), Float.parseFloat(xmlSource.getAttribute("left")), Float.parseFloat(xmlSource.getAttribute("bottom")), Float.parseFloat(xmlSource.getAttribute("right")));
        }
        if ("rect".equals(type)) {
            if (value != null && value.length() > 0) {
                float[] arr = OPPParseUtil.convertStringToFloats(value);
                return new Rectangle2D.Float(arr[0], arr[1], arr[2], arr[3]);
            }
            return new Rectangle2D.Float(Float.parseFloat(xmlSource.getAttribute("x")), Float.parseFloat(xmlSource.getAttribute("y")), Float.parseFloat(xmlSource.getAttribute("width")), Float.parseFloat(xmlSource.getAttribute("height")));
        }
        if ("point".equals(type)) {
            if (value != null && value.length() > 0) {
                float[] arr = OPPParseUtil.convertStringToFloats(value);
                return new Point2D.Float(arr[0], arr[1]);
            }
            return new Point2D.Float(Float.parseFloat(xmlSource.getAttribute("x")), Float.parseFloat(xmlSource.getAttribute("y")));
        }
        if ("elemRef".equals(type)) {
            String clazz = xmlSource.getAttribute("class");
            String erType = xmlSource.getAttribute("type");
            String sValue = xmlSource.getAttribute("sValue");
            String sType = xmlSource.getAttribute("sType");
            return new OPPElementReference(clazz, value, erType, sValue, sType);
        }
        if ("color".equals(type)) {
            String rgb = xmlSource.getAttribute("rgb");
            String legacyValue = xmlSource.getAttribute("value");
            if (legacyValue != null && legacyValue.length() > 0) {
                int[] values = OPPParseUtil.convertStringToInts(legacyValue);
                rgb = "0x" + Integer.toHexString(values[0] << 16 | values[1] << 8 | values[2]);
            }
            return Color.decode(rgb);
        }
        if ("font".equals(type)) {
            String family = xmlSource.getAttribute("fontFamily");
            int size = (int)Float.parseFloat(xmlSource.getAttribute("fontSize"));
            String weight = xmlSource.getAttribute("fontWeight");
            String style = xmlSource.getAttribute("fontStyle");
            int styleMask = 0;
            if ("italic".equals(style)) {
                styleMask |= 2;
            }
            if ("bold".equals(weight)) {
                styleMask |= 1;
            }
            return new Font(family, styleMask, size);
        }
        throw new IllegalArgumentException("unrecognized node type: " + type);
    }

    static List<OPPTopLevelShape> getShapesUsed(OPPContainer parent, XMLElement source) {
        XMLElement child;
        int i;
        int isize;
        NodeList s1 = source.getChildrenByTagName("shapeMap");
        NodeList s2 = source.getChildrenByTagName("infoMap");
        int size = (s1 != null ? s1.getLength() : 0) + (s2 != null ? s2.getLength() : 0);
        ArrayList<OPPTopLevelShape> shapes = new ArrayList<OPPTopLevelShape>(size);
        if (s1 != null) {
            isize = s1.getLength();
            for (i = 0; i < isize; ++i) {
                child = (XMLElement)s1.item(i);
                shapes.add(OPPTopLevelShape.newInstance(parent, child));
            }
        }
        if (s2 != null) {
            isize = s2.getLength();
            for (i = 0; i < isize; ++i) {
                child = (XMLElement)s2.item(i);
                shapes.add(OPPTopLevelShape.newInstance(parent, child));
            }
        }
        return shapes;
    }

    private static int[] convertStringToInts(String toConvert) {
        StringTokenizer st = new StringTokenizer(toConvert, ",", false);
        int[] arr = new int[st.countTokens()];
        for (int counter = 0; counter < arr.length; ++counter) {
            arr[counter] = Integer.parseInt(st.nextToken());
        }
        return arr;
    }

    private static float[] convertStringToFloats(String toConvert) {
        StringTokenizer st = new StringTokenizer(toConvert, ",", false);
        float[] arr = new float[st.countTokens()];
        for (int counter = 0; counter < arr.length; ++counter) {
            arr[counter] = Float.parseFloat(st.nextToken());
        }
        return arr;
    }
}

