/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.undo;

import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvFilterSDMModel;
import java.util.Collection;
import java.util.Collections;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.ide.Context;

public final class SDMUndoUtil {
    private SDMUndoUtil() {
    }

    public static void captureModelUndo(Context context, IlvSDMModel model, Runnable task) {
        SDMUndoUtil.captureModelUndo(context, model, task, 65535);
    }

    public static void captureModelUndo(Context context, IlvSDMModel model, Runnable task, int mask) {
        SDMUndoFilter filter = SDMUndoUtil.getUndoFilter(model);
        if (filter == null) {
            throw new IllegalStateException("No undo filter found!");
        }
        filter.captureUndo(context, mask, task);
    }

    public static SDMUndoFilter getUndoFilter(IlvSDMModel model) {
        if (model instanceof SDMUndoFilter) {
            return (SDMUndoFilter)model;
        }
        if (model instanceof IlvFilterSDMModel) {
            return SDMUndoUtil.getUndoFilter(((IlvFilterSDMModel)model).getFilteredModel());
        }
        return null;
    }

    public static Collection<StateHelper> getStateHelpers(IlvSDMModel model) {
        SDMUndoFilter filter = SDMUndoUtil.getUndoFilter(model);
        if (filter != null) {
            return filter.getStateHelpers();
        }
        return Collections.emptyList();
    }
}

