/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.changeset.cmd.BaseChangeSetCommand;
import oracle.jdeveloper.vcs.spi.VCSHashURL;

public class RemoveFromChangeSetCommand
extends BaseChangeSetCommand {
    public RemoveFromChangeSetCommand() {
        super(ChangeSetChangeList.REMOVE_FROM_CHANGE_SET_COMMAND_ID, 1);
    }

    public int doit() throws Exception {
        ChangeSetAdapter adapter = this.getContextChangeSetAdapter();
        if (adapter == null) {
            return 1;
        }
        if (!MessageDialog.optionalConfirm((String)"VCS.RemoveFromChangeSetConfirm", (Component)IdeUtil.getMainWindow(), (Object)VCSArb.get("CONFIRM_REMOVE_FROM_CHANGE_SET"), (String)VCSArb.get("CONFIRM_REMOVE_FROM_CHANGE_SET_TITLE"), null)) {
            return 1;
        }
        URL[] urls = this.getContextURLs();
        Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls);
        for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
            adapter.removeFromChangeSet(VCSHashURL.convertToURLs(entry.getValue()).toArray(new URL[0]), entry.getKey());
        }
        adapter.fireChangeSetsChanged();
        return 0;
    }
}

