/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.util.ArrayList;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;

public class VCSEventBus {
    private static ArrayList<VCSEBComponent> _components = new ArrayList();
    private static VCSEBComponent[] _copyComponents;

    private VCSEventBus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToBus(VCSEBComponent component) {
        ArrayList<VCSEBComponent> arrayList = _components;
        synchronized (arrayList) {
            _components.add(component);
            _copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromBus(VCSEBComponent component) {
        ArrayList<VCSEBComponent> arrayList = _components;
        synchronized (arrayList) {
            _components.remove(component);
            _copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VCSEBComponent[] getComponents() {
        ArrayList<VCSEBComponent> arrayList = _components;
        synchronized (arrayList) {
            if (_copyComponents == null) {
                _copyComponents = _components.toArray(new VCSEBComponent[_components.size()]);
            }
            return _copyComponents;
        }
    }

    public static void send(VCSEBMessage message) {
        VCSEBComponent[] components = VCSEventBus.getComponents();
        for (int i = 0; i < components.length; ++i) {
            try {
                components[i].handleMessage(message);
                continue;
            }
            catch (Throwable t) {
                Assert.printStackTrace((Throwable)t);
            }
        }
    }
}

