/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.MasterListEntry;
import oracle.ideimpl.webupdate.parser.InputStreamLocator;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.SAXException;

public final class MasterListParser
extends ExtensibleSAXParser {
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/jdeveloper/update/master";
    static final Key KEY_CENTERS_COLL = new Key("centers-coll");
    static final Key KEY_CURRENT_ENTRY = new Key("centers-entry");

    public List parse(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputStreamLocator locator = new InputStreamLocator(inputStream);
        this.getContext().putValue(KEY_CENTERS_COLL, new ArrayList());
        this.getContext().registerChildHandler(NAMESPACE_URI, "centers", (ElementHandler)new CentersHandler());
        this.parse(locator);
        return Collections.unmodifiableList((List)this.getContext().getValue(KEY_CENTERS_COLL));
    }

    private static class NameHandler
    extends ElementHandler {
        private NameHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            MasterListEntry entry = (MasterListEntry)context.getValue(KEY_CURRENT_ENTRY);
            entry.getUpdateCenter().setName(UpdateHandler.getText(context));
        }
    }

    private static class UrlHandler
    extends ElementHandler {
        private UrlHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            MasterListEntry entry = (MasterListEntry)context.getValue(KEY_CURRENT_ENTRY);
            entry.getUpdateCenter().setURL(UpdateHandler.getText(context));
        }
    }

    private static class DomainHandler
    extends ElementHandler {
        private DomainHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            MasterListEntry entry = (MasterListEntry)context.getValue(KEY_CURRENT_ENTRY);
            entry.setDomainRegexp(UpdateHandler.getText(context));
        }
    }

    private static class CenterHandler
    extends ElementHandler {
        private CenterHandler() {
        }

        public void handleStart(ElementStartContext context) {
            MasterListEntry entry = new MasterListEntry();
            String isProtected = context.getAttributeValue("protected");
            boolean bProtected = false;
            if (isProtected != null) {
                bProtected = Boolean.valueOf(isProtected);
            }
            entry.getUpdateCenter().setProtected(bProtected);
            String masterId = context.getAttributeValue("id").trim();
            entry.getUpdateCenter().setMasterId(masterId);
            String isSelected = context.getAttributeValue("selected");
            boolean bSelected = false;
            if (isSelected != null) {
                bSelected = Boolean.valueOf(isSelected);
            }
            entry.getUpdateCenter().setSelectedByDefault(bSelected);
            context.putValue(KEY_CURRENT_ENTRY, (Object)entry);
            Collection centers = (Collection)context.getValue(KEY_CENTERS_COLL);
            centers.add(entry);
            context.registerChildHandler(MasterListParser.NAMESPACE_URI, "domain", (ElementHandler)new DomainHandler());
            context.registerChildHandler(MasterListParser.NAMESPACE_URI, "url", (ElementHandler)new UrlHandler());
            context.registerChildHandler(MasterListParser.NAMESPACE_URI, "name", (ElementHandler)new NameHandler());
        }
    }

    private static class CentersHandler
    extends ElementHandler {
        private CentersHandler() {
        }

        public void handleStart(ElementStartContext context) {
            context.registerChildHandler(MasterListParser.NAMESPACE_URI, "center", (ElementHandler)new CenterHandler());
        }
    }
}

