/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Version;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ideimpl.webupdate.AbstractProgressMonitor;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskProgress;
import oracle.ideimpl.webupdate.task.TaskStack;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class TaskList
extends ArrayList {
    private static final String NS = Version.BASE_NAMESPACE_URI + "updatetasks";
    private static final String ROOT_NAME = "updatetasks";

    public void save(URL url) throws IOException {
        ListStructure lsTasks = ListStructure.newInstance();
        for (AtomicTask task : this) {
            lsTasks.add((Object)task.getClass().getName());
            lsTasks.add((Object)task.getProperties());
        }
        ListStructureIO io = new ListStructureIO(NS, ROOT_NAME);
        io.save(url, (Object)lsTasks);
    }

    public void load(URL url) throws IOException {
        ArrayList<AtomicTask> tasks = new ArrayList<AtomicTask>();
        ListStructureIO io = new ListStructureIO(NS, ROOT_NAME);
        ListStructure lsTasks = (ListStructure)io.load(url);
        AtomicTask lastTask = null;
        for (Object o : lsTasks) {
            if (o instanceof String) {
                try {
                    Class<?> c = Class.forName((String)o);
                    lastTask = (AtomicTask)c.newInstance();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Failed to create instance of class " + o);
                }
            }
            if (!(o instanceof HashStructure)) continue;
            lastTask.setProperties((HashStructure)o);
            tasks.add(lastTask);
            lastTask = null;
        }
        this.clear();
        this.addAll(tasks);
    }

    public void executeAll(TaskContext tc, final AbstractProgressMonitor mon) throws TaskFailedException {
        tc.setProgress(new TaskProgress(){

            @Override
            public void setPercentProgress(double progress) {
                mon.setStepProgress(progress);
            }
        });
        mon.setMajorStepCount(this.size());
        TaskStack ts = new TaskStack();
        int step = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            try {
                mon.startStep(step);
                ts.performTask((AtomicTask)i.next(), tc);
                mon.endStep(step);
            }
            catch (TaskFailedException tfe) {
                ts.rollbackTasks(tc);
                throw tfe;
            }
        }
        ts.commitTasks(tc);
    }
}

