/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import oracle.javatools.exports.command.ClassesSource;

public interface CommandInterface {
    public Operation getOperation();

    public boolean isValidating();

    public String getOwner();

    public List<String> getConsumers();

    public Path getDomainFile();

    public List<Path> getClassPath();

    public boolean isFailOnClassPathError();

    public List<ClassesSource> getLibraries();

    public Path getMiddlewareHome();

    public List<ClassesSource> getDependencies();

    public Path getBaseline0();

    public Path getBaseline1();

    public List<Path> getBootClassPath();

    public String getLibraryName();

    public String getLibraryId();

    public String getLibraryDescription();

    public Path getOutputDirectory();

    public Path getAddedFile();

    public Path getBaselineFile();

    public Path getConcealedFile();

    public Path getCommentsFile();

    public Path getExportedFile();

    public Path getExportsFile();

    public Path getIssuesFile();

    public Path getLibraryFile();

    public Path getLibrariesFile();

    public Path getProblemsFile();

    public Path getRemovedFile();

    public Path getUnusedExportedFile();

    public Path getUsedCommentedFile();

    public Path getUsedConcealedFile();

    public Path getUsedUncommentedFile();

    public void error(String var1, Object ... var2);

    public void warning(String var1, Object ... var2);

    public void note(String var1, Object ... var2);

    public void coarse(String var1, Object ... var2);

    public void fine(String var1, Object ... var2);

    public String parameter(String var1);

    public String option(String var1);

    public String output(Output var1);

    public String libraryOrExtension(String var1, String var2);

    public static enum Operation {
        GENERATE,
        ANALYZE,
        MERGE,
        CAPTURE,
        COMPARE;


        public EnumSet<Output> getDefaults() {
            switch (this) {
                case GENERATE: {
                    return Operation.set(Output.COMMENTS, Output.CONCEALED, Output.EXPORTED, Output.EXPORTS, Output.ISSUES, Output.LIBRARY, Output.PROBLEMS);
                }
                case ANALYZE: {
                    return Operation.set(Output.CONCEALED, Output.EXPORTED, Output.ISSUES, Output.LIBRARIES, Output.PROBLEMS);
                }
                case MERGE: {
                    return Operation.set(Output.CONCEALED, Output.EXPORTED, Output.EXPORTS, Output.ISSUES, Output.LIBRARIES, Output.LIBRARY, Output.PROBLEMS);
                }
                case CAPTURE: {
                    return Operation.set(Output.BASELINE, Output.ISSUES, Output.LIBRARIES);
                }
                case COMPARE: {
                    return Operation.set(Output.ADDED, Output.ISSUES, Output.REMOVED);
                }
            }
            throw new IllegalStateException();
        }

        public EnumSet<Output> getAllowed() {
            switch (this) {
                case GENERATE: {
                    return Operation.set(Output.COMMENTS, Output.CONCEALED, Output.EXPORTED, Output.EXPORTS, Output.ISSUES, Output.LIBRARIES, Output.LIBRARY, Output.PROBLEMS, Output.UNUSED_EXPORTED, Output.USED_COMMENTED, Output.USED_CONCEALED, Output.USED_UNCOMMENTED);
                }
                case ANALYZE: {
                    return Operation.set(Output.COMMENTS, Output.CONCEALED, Output.EXPORTED, Output.EXPORTS, Output.ISSUES, Output.LIBRARIES, Output.LIBRARY, Output.PROBLEMS, Output.UNUSED_EXPORTED, Output.USED_COMMENTED, Output.USED_CONCEALED, Output.USED_UNCOMMENTED);
                }
                case MERGE: {
                    return Operation.set(Output.COMMENTS, Output.CONCEALED, Output.EXPORTED, Output.EXPORTS, Output.ISSUES, Output.LIBRARIES, Output.LIBRARY, Output.PROBLEMS, Output.UNUSED_EXPORTED, Output.USED_COMMENTED, Output.USED_CONCEALED, Output.USED_UNCOMMENTED);
                }
                case CAPTURE: {
                    return Operation.set(Output.BASELINE, Output.ISSUES, Output.LIBRARIES);
                }
                case COMPARE: {
                    return Operation.set(Output.ADDED, Output.ISSUES, Output.REMOVED);
                }
            }
            throw new IllegalStateException();
        }

        private static EnumSet<Output> set(Output ... outputs) {
            return EnumSet.copyOf(Arrays.asList(outputs));
        }
    }

    public static enum Output {
        ADDED("added.lis"),
        BASELINE("baseline.xsig"),
        COMMENTS("lib-comments.xml"),
        CONCEALED("concealed-signatures.lis"),
        EXPORTED("exported-signatures.lis"),
        EXPORTS("lib-exports.xml"),
        ISSUES("exports.log"),
        LIBRARY("lib-exports.library"),
        LIBRARIES("libraries.lis"),
        PROBLEMS("problem-types.lis"),
        REMOVED("removed.lis"),
        UNUSED_EXPORTED("unused-exported-signatures.lis"),
        USED_COMMENTED("used-concealed-annotated.lis"),
        USED_CONCEALED("used-concealed-signatures.lis"),
        USED_UNCOMMENTED("used-concealed-unannotated.lis");

        private final String fileName;
        private static Map<String, Output> nameToOutput;

        private Output(String fileName) {
            this.fileName = fileName;
        }

        public String getTypeName() {
            return this.toString().toLowerCase().replace("_", "");
        }

        public String getPropertyName() {
            String name = this.toString().toLowerCase();
            int i = name.indexOf(95);
            if (i >= 0) {
                name = name.substring(0, i) + Character.toUpperCase(name.charAt(i + 1)) + name.substring(i + 2);
            }
            return name + "File";
        }

        public String getFileName() {
            return this.fileName;
        }

        public static Output outputFor(String typeName) {
            if (nameToOutput == null) {
                for (Output output : (Output[])Output.class.getEnumConstants()) {
                    nameToOutput.put(output.getTypeName(), output);
                }
            }
            return nameToOutput.get(typeName.toLowerCase());
        }
    }
}

