/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.FileExportSpecificationReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportLibraryReader
extends DefaultHandler {
    private boolean schemaValidating;
    private ExportSpecificationReader exportSpecificationReader = new FileExportSpecificationReader();
    private SAXParser parser;
    private Path path;
    private Map<String, String> macros;
    private URL contextUrl;
    private Locator locator;
    private int line;
    private int column;
    private String extensionId;
    private String id;
    private String name;
    private Set<FileExportLibrary.LibraryFlag> flags;
    private String description;
    private Map<ClassPathEntry, ClassPathEntry> classPath;
    private ClassPathEntry.EntryType classPathType;
    private String classPathKey;
    private boolean classPathManifest;
    private Map<String, List<URL>> exportSpecificationPaths;
    private String exportPathKey;
    private StringBuilder characters;
    private List<URL> sourcePath;
    private List<URL> docPath;
    private List<LibraryDependency> dependencies;
    private boolean reexport;
    private FileExportLibrary library;
    private List<String> validationIssues;
    private Consumer<FileExportLibrary> libraryCompletionHandler;
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public ExportSpecificationReader getExportSpecificationReader() {
        return this.exportSpecificationReader;
    }

    public void setExportSpecificationReader(ExportSpecificationReader exportSpecificationReader) {
        this.exportSpecificationReader = exportSpecificationReader;
    }

    public boolean isSchemaValidating() {
        return this.schemaValidating;
    }

    public void setSchemaValidating(boolean schemaValidating) {
        if (schemaValidating != this.schemaValidating) {
            this.schemaValidating = schemaValidating;
            this.parser = null;
        }
    }

    public FileExportLibrary read(URL url, Map<String, String> macros, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        return this.read(new File(url.getPath()).toPath(), macros, issues);
    }

    public FileExportLibrary read(Path path, Map<String, String> macros, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (this.schemaValidating) {
                InputStream schemaInputStream = ExportLibraryReader.class.getResourceAsStream("manifest-library.xsd");
                StreamSource schemaSource = new StreamSource(schemaInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaSource);
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setSchema(schema);
            }
            this.parser = factory.newSAXParser();
        }
        this.beginExtension(path, path.getParent(), macros, issues, null, null);
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            this.parser.parse((InputStream)stream, (DefaultHandler)this);
        }
        catch (LegacyFormatException | LocatorSAXException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new LocatorSAXException(e.getMessage() + this.at(), e);
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + this.at(), e);
        }
        return this.endLibrary();
    }

    public void beginExtension(Path path, Path contextPath, Map<String, String> macros, List<String> issues, String extensionId, Consumer<FileExportLibrary> libraryCompletionHandler) {
        this.path = path;
        this.contextUrl = Paths.toUrl(contextPath);
        this.macros = macros;
        this.validationIssues = issues;
        this.extensionId = extensionId;
        this.libraryCompletionHandler = libraryCompletionHandler;
    }

    public FileExportLibrary endLibrary() {
        return this.library;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "JLibraryNode": {
                throw new LegacyFormatException();
            }
            case "library": {
                this.id = this.optional(attributes, "id");
                this.name = this.required(attributes, "name", "library");
                if ("${COHERENCE_RUNTIME_LIB_NAME}".equals(this.name)) {
                    this.name = "Coherence Runtime";
                }
                this.description = null;
                this.flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
                if (Boolean.parseBoolean(this.optional(attributes, "deployed"))) {
                    this.flags.add(FileExportLibrary.LibraryFlag.DEPLOYED);
                }
                if (Boolean.parseBoolean(this.optional(attributes, "locked"))) {
                    this.flags.add(FileExportLibrary.LibraryFlag.LOCKED);
                }
                this.classPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
                this.exportSpecificationPaths = new HashMap<String, List<URL>>();
                this.dependencies = new ArrayList<LibraryDependency>();
                this.sourcePath = new ArrayList<URL>();
                this.docPath = new ArrayList<URL>();
                break;
            }
            case "description": {
                this.characters = new StringBuilder();
                break;
            }
            case "dependency": {
                this.reexport = Boolean.parseBoolean(this.optional(attributes, "reexport"));
                this.characters = new StringBuilder();
                break;
            }
            case "classpath": {
                String exportText = this.optional(attributes, "export");
                if (exportText != null) {
                    switch (exportText.toLowerCase()) {
                        case "none": {
                            this.classPathType = ClassPathEntry.EntryType.SUPPLIED_NONE;
                            break;
                        }
                        case "embedded": {
                            this.classPathType = ClassPathEntry.EntryType.SUPPLIED_EMBEDDED;
                            break;
                        }
                        case "library": {
                            this.classPathType = ClassPathEntry.EntryType.SUPPLIED_LIBRARY;
                            break;
                        }
                        case "all": {
                            this.classPathType = ClassPathEntry.EntryType.SUPPLIED_ALL;
                            break;
                        }
                        default: {
                            this.error("<classpath> export attribute value \"" + exportText + "\" must be \"none\", \"embedded\", \"library\", or \"all\"", new Object[0]);
                            break;
                        }
                    }
                } else {
                    this.classPathType = ClassPathEntry.EntryType.SUPPLIED_ABSENT;
                }
                this.classPathManifest = Boolean.parseBoolean(this.optional(attributes, "manifest"));
                this.classPathKey = this.optional(attributes, "name");
                if (this.classPathKey == null) {
                    this.classPathKey = "";
                }
                this.characters = new StringBuilder();
                break;
            }
            case "export-specification": {
                this.exportPathKey = this.optional(attributes, "name");
                if (this.exportPathKey == null) {
                    this.exportPathKey = "";
                }
                this.characters = new StringBuilder();
                break;
            }
            case "sourcepath": 
            case "srcpath": {
                this.characters = new StringBuilder();
                break;
            }
            case "docpath": {
                this.characters = new StringBuilder();
                break;
            }
            default: {
                this.error("unexpected element name " + qualifiedName + this.at(), new Object[0]);
            }
        }
    }

    @Override
    public void characters(char[] text, int offset, int length) throws SAXException {
        if (text != null && this.characters != null) {
            this.characters.append(text, offset, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "library": {
                this.library = new FileExportLibrary(Paths.toUrl(Paths.getDefaultPath(this.path)), this.extensionId, this.name, this.id, this.description, this.flags, new ArrayList<ClassPathEntry>(this.classPath.keySet()), this.exportSpecificationPaths, this.dependencies, this.sourcePath, this.docPath, null, null, null);
                this.library.resolveManifestClassPaths(this.exportSpecificationReader, this.validationIssues);
                if (this.libraryCompletionHandler == null) break;
                this.libraryCompletionHandler.accept(this.library);
                break;
            }
            case "dependency": {
                this.dependencies.add(new LibraryDependency(this.characters.toString(), this.reexport));
                this.characters = null;
                break;
            }
            case "description": {
                this.description = this.characters.toString();
                this.characters = null;
                break;
            }
            case "classpath": {
                for (URL uRL : this.toUrls(this.characters, this.contextUrl)) {
                    ClassPathEntry entry = new ClassPathEntry(uRL, this.classPathType, this.classPathKey, this.classPathManifest);
                    ClassPathEntry predecessor = this.classPath.putIfAbsent(entry, entry);
                    if (predecessor == null) continue;
                    this.error("duplicate classpath entry %s%s", URLFileSystem.getPlatformPathName((URL)uRL), this.at());
                }
                this.classPathType = null;
                this.classPathKey = null;
                this.classPathManifest = false;
                this.characters = null;
                break;
            }
            case "sourcepath": 
            case "srcpath": {
                this.sourcePath.addAll(this.toUrls(this.characters, this.contextUrl));
                this.characters = null;
                break;
            }
            case "docpath": {
                this.docPath.addAll(this.toUrls(this.characters, this.contextUrl));
                this.characters = null;
                break;
            }
            case "export-specification": {
                URL url = this.toUrl(this.characters.toString().trim(), this.contextUrl);
                this.exportSpecificationPaths.computeIfAbsent(this.exportPathKey, v -> new ArrayList()).add(url);
                this.characters = null;
                break;
            }
            default: {
                throw new SAXException("unexpected element name " + qualifiedName + this.at());
            }
        }
    }

    private String optional(Attributes attributes, String name) {
        String text = attributes.getValue(name);
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    private String required(Attributes attributes, String name, String element) {
        String text = attributes.getValue(name);
        if (text != null) {
            if ((text = text.trim()).isEmpty()) {
                this.error("<" + element + "> requires non-empty " + name + " attribute value", new Object[0]);
                text = null;
            }
        } else {
            this.error("<" + element + "> requires " + name + " attribute", new Object[0]);
        }
        return text;
    }

    private void note(String message, Object ... arguments) {
        this.validationIssues.add(String.format(message, arguments) + this.at());
    }

    private void warning(String message, Object ... arguments) {
        this.validationIssues.add("Warning: " + String.format(message, arguments) + this.at());
    }

    private void error(String message, Object ... arguments) {
        this.validationIssues.add("Error:   " + String.format(message, arguments) + this.at());
    }

    @Override
    public void warning(SAXParseException e) {
        this.validationIssues.add("Error:   " + e.getMessage() + " (" + Paths.toString(this.path) + ":" + e.getLineNumber() + ')');
    }

    @Override
    public void error(SAXParseException e) {
        this.validationIssues.add("Error:   " + e.getMessage() + " (" + Paths.toString(this.path) + ":" + e.getLineNumber() + ')');
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected String at() {
        return " (" + Paths.toString(this.path) + ", line " + this.line + ", column " + this.column + ')';
    }

    protected List<? extends URL> toUrls(StringBuilder text, URL contextUrl) {
        int end;
        ArrayList<URL> list = new ArrayList<URL>();
        int start = 0;
        while ((end = text.indexOf(",", start)) >= 0) {
            URL url = this.toUrl(text.substring(start, end), contextUrl);
            if (url != null) {
                list.add(url);
            }
            start = end + 1;
        }
        URL url = this.toUrl(text.substring(start), contextUrl);
        if (url != null) {
            list.add(url);
        }
        return list;
    }

    protected URL toUrl(String text, URL contextUrl) {
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        int dollar = text.indexOf("${");
        if (dollar >= 0) {
            int to;
            StringBuilder builder = new StringBuilder();
            int mark = 0;
            do {
                builder.append(text.substring(mark, dollar));
                mark = dollar;
                to = text.indexOf(125, dollar + 2);
                if (to < 0) break;
                String name = text.substring(dollar + 2, to);
                String value = this.macros.get(name);
                if (value != null) {
                    builder.append(value);
                    continue;
                }
                builder.append("${").append(name).append("}");
            } while ((dollar = text.indexOf("${", mark = to + 1)) >= 0);
            builder.append(text, mark, text.length());
            text = builder.toString();
        }
        String path = text;
        String scheme = "";
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ':') {
                scheme = path.substring(0, i);
                path = path.substring(i + 1);
                break;
            }
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') break;
        }
        String authority = "";
        if (path.startsWith("//")) {
            for (int i = 2; i < path.length(); ++i) {
                if (i == path.length()) {
                    authority = path;
                    path = "";
                    break;
                }
                char c = path.charAt(i);
                if (c != '/' && c != '?' && c != '#') continue;
                authority = path.substring(2, i);
                path = path.substring(i);
                break;
            }
        }
        if (!authority.isEmpty()) {
            return URLFactory.newURL((String)text);
        }
        switch (scheme) {
            case "jar": 
            case "zip": 
            case "ear": 
            case "war": {
                String entryPath;
                String filePath;
                int entryIndex = path.indexOf("!/");
                if (entryIndex >= 0) {
                    filePath = path.substring(0, entryIndex);
                    entryPath = path.substring(entryIndex + 2);
                } else {
                    filePath = path;
                    entryPath = "";
                }
                return URLFactory.newJarURL((URL)this.resolve(filePath, contextUrl), (String)entryPath);
            }
            case "": 
            case "file": {
                String entryPath;
                String filePath;
                int entryIndex = path.indexOf("!/");
                if (entryIndex >= 0) {
                    filePath = path.substring(0, entryIndex);
                    entryPath = path.substring(entryIndex + 2);
                } else {
                    filePath = path;
                    int dot = filePath.lastIndexOf(46);
                    entryPath = dot >= 0 && ARCHIVE_SUFFIXES.contains(filePath.substring(dot)) ? "" : null;
                }
                URL fileUrl = this.resolve(filePath, contextUrl);
                return entryPath == null ? fileUrl : URLFactory.newJarURL((URL)fileUrl, (String)entryPath);
            }
        }
        return URLFactory.newURL((String)text);
    }

    private URL resolve(String path, URL contextUrl) {
        URL fileUrl = this.isAbsolute(path) ? URLFactory.newFileURL((String)path) : URLFactory.newURL((URL)contextUrl, (String)path);
        return fileUrl;
    }

    protected boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() >= 2 && path.charAt(1) == ':';
    }

    private static class LocatorSAXException
    extends SAXException {
        public LocatorSAXException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class LegacyFormatException
    extends SAXException {
        public LegacyFormatException() {
            super("Legacy file format: use JLibraryNode to read");
        }
    }
}

