/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.FileExportSpecification;
import org.xml.sax.SAXException;

public class FileExportLibrary
implements ExportLibrary {
    private final URL origin;
    private final String extensionId;
    private final String name;
    private final String syntheticId;
    private final String id;
    private final String description;
    private final Set<LibraryFlag> flags;
    private final Collection<ClassPathEntry> suppliedClassPath;
    private final Map<String, List<URL>> exportSpecificationPaths;
    private final Collection<LibraryDependency> dependencies;
    private final List<URL> sourcePath;
    private final List<URL> docPath;
    private final List<URL> endorsedDirectoriesPath;
    private final List<URL> endorsedSourcePath;
    private final List<URL> endorsedDocPath;
    private boolean resolvedExportSpecifications;
    private Set<ClassPathEntry> resolvedClassPath;
    private boolean resolvedDependencies;
    private static AtomicInteger namelessCount = new AtomicInteger();
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public FileExportLibrary(URL origin, String extensionId, String name, String id, String description, Set<LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        this(origin, extensionId, name, null, id, description, flags, suppliedClassPath, exportSpecificationPaths, dependencies, sourcePath, docPath, endorsedDirectoriesPath, endorsedSourcePath, endorsedDocPath);
    }

    public FileExportLibrary(URL origin, String extensionId, String name, String syntheticId, String id, String description, Set<LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        assert (!exportSpecificationPaths.containsKey(null));
        if (name == null) {
            String string = name = origin != null ? URLFileSystem.getName((URL)origin) : "unnamed-" + namelessCount.incrementAndGet();
        }
        if (syntheticId == null) {
            syntheticId = extensionId != null ? ExportLibrary.syntheticId(extensionId, name) : ExportLibrary.syntheticId(origin, name);
        }
        this.origin = origin;
        this.extensionId = extensionId;
        this.syntheticId = syntheticId;
        this.id = id;
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.suppliedClassPath = suppliedClassPath;
        this.exportSpecificationPaths = exportSpecificationPaths;
        this.dependencies = dependencies;
        this.sourcePath = sourcePath;
        this.docPath = docPath;
        this.endorsedDirectoriesPath = endorsedDirectoriesPath;
        this.endorsedSourcePath = endorsedSourcePath;
        this.endorsedDocPath = endorsedDocPath;
    }

    public void resolveExportSpecifications(ExportSpecificationReader<FileExportSpecification, FileExportSpecification.FilePackageExportSpecification, FileExportSpecification.FileTypeExportSpecification> reader, List<String> issues) {
        if (this.resolvedExportSpecifications) {
            return;
        }
        this.resolvedExportSpecifications = true;
        HashMap<String, ExportSpecification> resolvedExportSpecifications = new HashMap<String, ExportSpecification>();
        for (Map.Entry<String, List<URL>> entry : this.exportSpecificationPaths.entrySet()) {
            ExportSpecification exportSpecification;
            ArrayList<FileExportSpecification> exportSpecifications = new ArrayList<FileExportSpecification>();
            for (URL url : entry.getValue()) {
                String key;
                try {
                    exportSpecifications.add(reader.read(url, URLFileSystem.openInputStream((URL)url), issues));
                }
                catch (FileNotFoundException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    issues.add("Error: library export specification " + URLFileSystem.getPlatformPathName((URL)url) + " for " + key + " not found");
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    issues.add("Error: library export specification " + URLFileSystem.getPlatformPathName((URL)url) + " for " + key + " not read: " + e);
                }
            }
            switch (exportSpecifications.size()) {
                case 0: {
                    exportSpecification = null;
                    break;
                }
                case 1: {
                    exportSpecification = (ExportSpecification)exportSpecifications.get(0);
                    break;
                }
                default: {
                    exportSpecification = FileExportSpecification.mergeExportSpecifications(this.id + "#" + entry.getKey(), exportSpecifications, issues, reader);
                }
            }
            resolvedExportSpecifications.put(entry.getKey(), exportSpecification);
        }
        for (ClassPathEntry classPathEntry : this.suppliedClassPath) {
            classPathEntry.resolve(reader, resolvedExportSpecifications, issues);
        }
    }

    public void resolveManifestClassPaths(ExportSpecificationReader<FileExportSpecification, FileExportSpecification.FilePackageExportSpecification, FileExportSpecification.FileTypeExportSpecification> reader, List<String> issues) {
        if (this.resolvedClassPath != null) {
            return;
        }
        this.resolveExportSpecifications(reader, issues);
        this.resolvedClassPath = new LinkedHashSet<ClassPathEntry>();
        HashMap<ClassPathEntry, ClassPathEntry> suppliedEntries = new HashMap<ClassPathEntry, ClassPathEntry>();
        for (ClassPathEntry entry : this.suppliedClassPath) {
            suppliedEntries.put(entry, entry);
        }
        HashSet<ClassPathEntry> expandedEntries = new HashSet<ClassPathEntry>();
        for (ClassPathEntry entry : this.suppliedClassPath) {
            this.resolvedClassPath.add(entry);
            if (!entry.isManifest() || !expandedEntries.add(entry)) continue;
            FileExportLibrary.accumulateManifestClasspath(entry, suppliedEntries, expandedEntries, this.resolvedClassPath, issues);
        }
    }

    public void resolveDependencies(ExportSpecificationReader<FileExportSpecification, FileExportSpecification.FilePackageExportSpecification, FileExportSpecification.FileTypeExportSpecification> reader, Function<String, ? extends Object> libraryResolver, List<String> issues) {
        if (this.resolvedDependencies) {
            return;
        }
        this.resolvedDependencies = true;
        this.resolveManifestClassPaths(reader, issues);
        this.resolveDependenciesRecursively(new IdentityHashMap<ExportLibrary, Boolean>(), reader, libraryResolver, issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependenciesRecursively(Map<ExportLibrary, Boolean> resolvingLibraries, ExportSpecificationReader<?, ?, ?> exportSpecificationReader, Function<String, ? extends Object> libraryResolver, List<String> issues) {
        if (this.resolvedClassPath != null) {
            return;
        }
        resolvingLibraries.put(this, true);
        try {
            for (LibraryDependency dependency : this.getDependencies()) {
                Object resolvedLibrary = dependency.resolve(libraryResolver);
                if (resolvedLibrary == null) {
                    issues.add(String.format("library dependency %s not found in library %s (\"%s\"): %s", dependency.getId(), this.getId(), this.getName(), this.getOrigin()));
                    continue;
                }
                if (resolvedLibrary instanceof ExportLibrary) {
                    if (resolvedLibrary instanceof FileExportLibrary) {
                        FileExportLibrary exportLibrary = (FileExportLibrary)resolvedLibrary;
                        Boolean resolving = resolvingLibraries.putIfAbsent(exportLibrary, true);
                        if (resolving == null) {
                            exportLibrary.resolveDependenciesRecursively(resolvingLibraries, exportSpecificationReader, libraryResolver, issues);
                        } else if (resolving.booleanValue()) {
                            issues.add(String.format("dependency cycle at library %s (%s)", exportLibrary.getName(), exportLibrary.getId()));
                            continue;
                        }
                    }
                    for (ClassPathEntry dependencyEntry : ((ExportLibrary)resolvedLibrary).getResolvedClassPath()) {
                        this.resolvedClassPath.add(new ClassPathEntry(dependencyEntry, dependency));
                    }
                    continue;
                }
                try {
                    for (URL url : (URLPath)resolvedLibrary.getClass().getMethod("getClassPath", new Class[0]).invoke(resolvedLibrary, new Object[0])) {
                        ClassPathEntry entry = new ClassPathEntry(url, dependency);
                        this.resolvedClassPath.add(new ClassPathEntry(entry, dependency));
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                }
            }
        }
        finally {
            resolvingLibraries.put(this, false);
        }
    }

    public boolean isResolved() {
        return this.resolvedDependencies;
    }

    @Override
    public URL getOrigin() {
        return this.origin;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String getId() {
        return this.id != null && !this.id.isEmpty() ? this.id : this.syntheticId;
    }

    public String getSyntheticId() {
        return this.syntheticId;
    }

    public boolean isIdSynthetic() {
        return this.id == null || this.id.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Set<LibraryFlag> getFlags() {
        return this.flags;
    }

    public boolean isSet(LibraryFlag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public Collection<ClassPathEntry> getSuppliedClassPath() {
        return this.suppliedClassPath;
    }

    @Override
    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.exportSpecificationPaths;
    }

    @Override
    public Collection<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    public List<URL> getSourcePath() {
        return this.sourcePath;
    }

    public List<URL> getDocPath() {
        return this.docPath;
    }

    public List<URL> getEndorsedDirectoriesPath() {
        return this.endorsedDirectoriesPath;
    }

    public List<URL> getEndorsedSourcePath() {
        return this.endorsedSourcePath;
    }

    public List<URL> getEndorsedDocPath() {
        return this.endorsedDocPath;
    }

    @Override
    public Set<ClassPathEntry> getResolvedClassPath() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return this.resolvedClassPath;
    }

    public String toString() {
        return this.name + " (" + this.getId() + " at " + URLFileSystem.getPlatformPathName((URL)this.origin) + ")";
    }

    public static void accumulateManifestClasspath(ClassPathEntry container, Map<ClassPathEntry, ClassPathEntry> suppliedEntries, Set<ClassPathEntry> expandedEntries, Set<ClassPathEntry> resolvedClassPath, List<String> issues) {
        URL containerUrl = container.getUrl();
        URL manifestUrl = URLFactory.newJarURL((URL)containerUrl, (String)"META-INF/MANIFEST.MF");
        try {
            String paths;
            String[] stringArray = null;
            try (InputStream stream = URLFileSystem.openInputStream((URL)manifestUrl);){
                paths = new Manifest(stream).getMainAttributes().getValue("Class-Path");
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            if (paths == null) {
                return;
            }
            URL context = FileExportLibrary.getContextUrl(containerUrl);
            for (String entryPath : paths.split(" +")) {
                ClassPathEntry entry;
                ClassPathEntry suppliedEntry;
                boolean archive;
                URL entryUrl;
                if (entryPath.isEmpty() || !URLFileSystem.exists((URL)(entryUrl = FileExportLibrary.resolve(entryPath, context)))) continue;
                int dot = entryPath.lastIndexOf(46);
                boolean bl = archive = dot >= 0 && ARCHIVE_SUFFIXES.contains(entryPath.substring(dot));
                if (archive) {
                    entryUrl = URLFactory.newJarURL((URL)entryUrl, (String)"");
                }
                if ((suppliedEntry = suppliedEntries.get(entry = new ClassPathEntry(entryUrl, container))) != null && !resolvedClassPath.contains(entry)) {
                    entry = new ClassPathEntry(suppliedEntry, container);
                }
                resolvedClassPath.add(entry);
                if (!expandedEntries.add(entry)) continue;
                FileExportLibrary.accumulateManifestClasspath(entry, suppliedEntries, expandedEntries, resolvedClassPath, issues);
            }
        }
        catch (FileNotFoundException paths) {
        }
        catch (IOException e) {
            issues.add("Error:   " + String.format("manifest of %s not read: %s", container, e));
        }
    }

    private static URL resolve(String path, URL contextUrl) {
        URL fileUrl = FileExportLibrary.isAbsolute(path) ? URLFactory.newFileURL((String)path) : URLFactory.newURL((URL)contextUrl, (String)path);
        return fileUrl;
    }

    protected static boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() >= 2 && path.charAt(1) == ':';
    }

    private static URL getContextUrl(URL url) {
        if (JarUtil.isJarURL((URL)url) && JarUtil.getJarEntry((URL)url).isEmpty()) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        return URLFileSystem.getParent((URL)url);
    }

    public static enum LibraryFlag {
        DEPLOYED,
        LOCKED,
        HIDDEN,
        LAZY;


        public String getAttributeName() {
            return this.toString().toLowerCase();
        }
    }
}

