/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.ArraySortedSet;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ExportSpecificationReader<E extends ExportSpecification, P extends ExportSpecification.PackageExportSpecification, T extends ExportSpecification.TypeExportSpecification>
extends DefaultHandler {
    private boolean schemaValidating;
    private boolean domainValidating;
    private SAXParser parser;
    private Object fileName;
    private Locator locator;
    private int line;
    private int column;
    private List<String> validationIssues;
    private T TYPE_ALL_EXPORTED;
    private T TYPE_ALL_EXPORTED_FINAL;
    private T TYPE_EXPORTED_MEMBERS_CONCEALED;
    private T TYPE_EXPORTED_FINAL_MEMBERS_CONCEALED;
    private T TYPE_ALL_CONCEALED;
    private T TYPE_ALL_NULL;
    private P PACKAGE_ALL_EXPORTED;
    private P PACKAGE_ALL_CONCEALED;
    private P PACKAGE_ALL_NULL;
    private E ALL_EXPORTED;
    private E ALL_CONCEALED;
    private String owner;
    private String source;
    private ExportDomains domains;
    private String domainName;
    private Set<String> exceptionNames;
    private Set<String> unusedDomains;
    private Map<String, P> rootPackages;
    private String packageName;
    private Access packageExtension;
    private Map<String, T> packageTypes;
    private Set<String> packageResources;
    private String typeName;
    private Access typeExtension;
    private Access typeMemberAccess;
    private Set<String> typeMembers;

    public abstract E createAccessModel(Object var1, String var2, String var3, ExportDomains var4, Map<String, P> var5, P var6, P var7);

    public abstract P createPackageAccessModel(Access var1, Map<String, T> var2, Set<String> var3, T var4);

    public abstract T createTypeAccessModel(Access var1, Access var2, Set<String> var3, Access var4);

    public E createFixedAccessModel(Access access) {
        T typeAccessModel = this.createTypeAccessModel(access, access, null, access);
        P packageAccessModel = this.createPackageAccessModel(access, null, null, typeAccessModel);
        return this.createAccessModel((Object)access, "", null, null, null, packageAccessModel, packageAccessModel);
    }

    public E getFixedAccessModel(Access access) {
        return access == Access.EXPORTED ? this.ALL_EXPORTED : this.ALL_CONCEALED;
    }

    public void setSchemaValidating(boolean schemaValidating) {
        if (schemaValidating != this.schemaValidating) {
            this.schemaValidating = schemaValidating;
            this.parser = null;
        }
    }

    public void setDomainValidating(boolean domainValidating) {
        if (domainValidating != this.schemaValidating) {
            this.domainValidating = domainValidating;
            this.parser = null;
        }
    }

    public E read(Path path, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream exportsStream = Files.newInputStream(path, new OpenOption[0]);){
            E e = this.read(Paths.toString(path), exportsStream, issues);
            return e;
        }
    }

    public E read(Object exportsName, InputStream exportsStream, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        if (exportsStream == null) {
            throw new IOException("null input stream for " + exportsName);
        }
        this.validationIssues = issues;
        this.fileName = exportsName;
        if (this.ALL_EXPORTED == null) {
            this.TYPE_ALL_EXPORTED = this.createTypeAccessModel(Access.EXPORTED, Access.EXPORTED, null, Access.EXPORTED);
            this.TYPE_ALL_EXPORTED_FINAL = this.createTypeAccessModel(Access.EXPORTED, Access.CONCEALED, null, Access.EXPORTED);
            this.TYPE_EXPORTED_MEMBERS_CONCEALED = this.createTypeAccessModel(Access.EXPORTED, Access.EXPORTED, null, Access.CONCEALED);
            this.TYPE_EXPORTED_FINAL_MEMBERS_CONCEALED = this.createTypeAccessModel(Access.EXPORTED, Access.CONCEALED, null, Access.CONCEALED);
            this.TYPE_ALL_CONCEALED = this.createTypeAccessModel(Access.CONCEALED, Access.CONCEALED, null, Access.CONCEALED);
            this.TYPE_ALL_NULL = this.createTypeAccessModel(null, Access.CONCEALED, null, null);
            this.PACKAGE_ALL_EXPORTED = this.createPackageAccessModel(Access.EXPORTED, null, null, this.TYPE_ALL_EXPORTED);
            this.PACKAGE_ALL_CONCEALED = this.createPackageAccessModel(Access.CONCEALED, null, null, this.TYPE_ALL_CONCEALED);
            this.PACKAGE_ALL_NULL = this.createPackageAccessModel(null, null, null, this.TYPE_ALL_NULL);
            this.ALL_EXPORTED = this.createAccessModel((Object)Access.EXPORTED, null, null, null, null, this.PACKAGE_ALL_EXPORTED, this.PACKAGE_ALL_EXPORTED);
            this.ALL_CONCEALED = this.createAccessModel((Object)Access.CONCEALED, null, null, null, null, this.PACKAGE_ALL_CONCEALED, this.PACKAGE_ALL_CONCEALED);
        }
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (this.schemaValidating) {
                InputStream schemaInputStream = ExportSpecification.class.getResourceAsStream("lib-exports.xsd");
                StreamSource schemaSource = new StreamSource(schemaInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaSource);
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setSchema(schema);
                this.parser = factory.newSAXParser();
            } else {
                this.parser = factory.newSAXParser();
            }
        }
        this.column = 0;
        this.line = 0;
        try {
            this.parser.parse(exportsStream, (DefaultHandler)this);
        }
        catch (LocatorSAXException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new LocatorSAXException(e.getMessage() + this.at(), e);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + this.at(), e);
        }
        return this.createAccessModel(exportsName, this.owner, this.source, this.domains, this.rootPackages, this.PACKAGE_ALL_CONCEALED, this.PACKAGE_ALL_NULL);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "lib-exports": {
                this.owner = attributes.getValue("owner");
                this.source = attributes.getValue("source");
                this.domains = new ExportDomains(new String[0]);
                this.unusedDomains = new LinkedHashSet<String>();
                this.rootPackages = new LinkedHashMap<String, P>();
                this.packageTypes = new LinkedHashMap<String, T>();
                this.packageResources = new ArraySortedSet();
                this.typeMembers = new ArraySortedSet();
                break;
            }
            case "domains": {
                break;
            }
            case "domain": {
                if (!this.rootPackages.isEmpty()) {
                    throw new LocatorSAXException("<domain> element not allowed after <package> element" + this.at());
                }
                this.domainName = this.getNameAttribute(attributes, qualifiedName);
                if (!this.domainName.endsWith(".")) {
                    this.domainName = this.domainName + '.';
                }
                this.exceptionNames = new ArraySortedSet();
                break;
            }
            case "except": {
                if (this.domainName == null) {
                    throw new LocatorSAXException("<except> element not allowed outside <domain> element" + this.at());
                }
                String exceptionName = this.getNameAttribute(attributes, qualifiedName);
                if (!exceptionName.endsWith(".")) {
                    exceptionName = exceptionName + '.';
                }
                if (this.exceptionNames.add(exceptionName)) break;
                this.warning("duplicate exception name %s", exceptionName.substring(0, exceptionName.length() - 1));
                break;
            }
            case "package": {
                this.packageName = this.getNameAttribute(attributes, qualifiedName);
                this.packageExtension = this.access(attributes.getValue("extension"), Access.EXPORTED, "extension");
                break;
            }
            case "class": 
            case "interface": {
                this.typeName = this.getNameAttribute(attributes, qualifiedName);
                this.typeExtension = this.access(attributes.getValue("extension"), this.packageExtension, "extension");
                this.typeMemberAccess = this.access(attributes.getValue("members"), Access.EXPORTED, "members");
                break;
            }
            case "constructor": 
            case "method": 
            case "field": {
                this.typeMembers.add(this.getNameAttribute(attributes, qualifiedName));
                break;
            }
            case "resource": {
                this.packageResources.add(this.getNameAttribute(attributes, qualifiedName));
                break;
            }
            default: {
                throw new LocatorSAXException("unexpected element name " + qualifiedName + this.at());
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "lib-exports": {
                if (this.unusedDomains.isEmpty()) break;
                StringBuilder builder = new StringBuilder(91);
                String prefix = "";
                for (String domain : this.unusedDomains) {
                    builder.append(prefix).append(domain, 0, domain.length() - 1);
                    prefix = ",";
                }
                builder.append(']');
                this.warning("%d of %d domain names unused: %s", this.unusedDomains.size(), this.domains.getDomainCount(), builder);
                break;
            }
            case "domains": {
                break;
            }
            case "domain": {
                this.domains.add(this.domainName, this.exceptionNames);
                if (!this.exceptionNames.isEmpty()) {
                    this.exceptionNames = new ArraySortedSet();
                }
                if (this.domainValidating) {
                    this.unusedDomains.add(this.domainName);
                }
                this.domainName = null;
                break;
            }
            case "except": {
                break;
            }
            case "package": {
                P packageAccessNode;
                if (!this.domains.controlsAll()) {
                    ExportDomains.Domain domain = this.domains.getDomain(this.packageName);
                    if (domain == null) {
                        if (!this.domainValidating) break;
                        this.warning("package name %s not in domains %s", this.packageName, this.domains);
                        break;
                    }
                    this.unusedDomains.remove(domain.getName());
                }
                if (this.packageTypes.isEmpty() && this.packageResources.isEmpty()) {
                    packageAccessNode = this.PACKAGE_ALL_EXPORTED;
                } else {
                    Map<String, Object> types = this.packageTypes;
                    if (types.isEmpty()) {
                        types = Collections.emptyMap();
                    } else {
                        this.packageTypes = new ArrayMap();
                    }
                    Set<String> resources = this.packageResources;
                    if (resources.isEmpty()) {
                        resources = Collections.emptySet();
                    } else {
                        this.packageResources = new ArraySortedSet();
                    }
                    packageAccessNode = this.createPackageAccessModel(Access.EXPORTED, types, resources, this.TYPE_ALL_CONCEALED);
                }
                this.rootPackages.put(this.packageName, packageAccessNode);
                break;
            }
            case "class": 
            case "interface": {
                T typeAccessNode;
                if (this.typeMembers.isEmpty()) {
                    typeAccessNode = this.typeExtension == Access.EXPORTED ? (this.typeMemberAccess == Access.EXPORTED ? this.TYPE_ALL_EXPORTED : this.TYPE_EXPORTED_MEMBERS_CONCEALED) : (this.typeMemberAccess == Access.EXPORTED ? this.TYPE_ALL_EXPORTED_FINAL : this.TYPE_EXPORTED_FINAL_MEMBERS_CONCEALED);
                } else {
                    typeAccessNode = this.createTypeAccessModel(Access.EXPORTED, this.typeExtension, this.typeMembers, null);
                    this.typeMembers = new ArraySortedSet();
                }
                this.packageTypes.put(this.typeName, typeAccessNode);
                break;
            }
            case "constructor": 
            case "method": 
            case "field": {
                break;
            }
            case "resource": {
                break;
            }
            default: {
                throw new SAXException("unexpected element name " + qualifiedName);
            }
        }
    }

    private String getNameAttribute(Attributes attributes, String elementName) throws LocatorSAXException {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new LocatorSAXException("name attribute required" + this.at());
        }
        if ((name = name.trim()).isEmpty()) {
            throw new LocatorSAXException("non-empty name attribute required" + this.at());
        }
        return name;
    }

    public void warning(String format, Object ... arguments) throws SAXException {
        this.validationIssues.add("Warning: " + String.format(format, arguments) + this.at());
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.validationIssues.add("Warning: " + e.getMessage() + " (" + this.fileName() + ":" + e.getLineNumber());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.validationIssues.add("Error:   " + e.getMessage() + " (" + this.fileName() + ":" + e.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected String at() {
        return " (" + this.fileName() + ", line " + this.line + ", column " + this.column + ')';
    }

    private String fileName() {
        if (this.fileName instanceof URL) {
            return URLFileSystem.getPlatformPathName((URL)((URL)this.fileName));
        }
        if (this.fileName instanceof Path) {
            return Paths.toString((Path)this.fileName);
        }
        return String.valueOf(this.fileName);
    }

    private Access access(String value, Access defaultValue, String attributeName) throws SAXException {
        if (value == null) {
            return defaultValue;
        }
        switch (value) {
            case "exported": {
                return Access.EXPORTED;
            }
            case "concealed": {
                return Access.CONCEALED;
            }
        }
        throw new SAXException(attributeName + " attribute value \"" + value + "\" must be \"exported\" or \"concealed\"" + this.at());
    }

    private static class LocatorSAXException
    extends SAXException {
        public LocatorSAXException(String message) {
            super(message);
        }

        public LocatorSAXException(Exception e) {
            super(e);
        }

        public LocatorSAXException(String message, Exception e) {
            super(message, e);
        }
    }
}

