/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWObject;
import oracle.AWXML.Attribute;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.CalculatedMember;
import oracle.AWXML.CalculatedMemberRef;
import oracle.AWXML.DimensionMapGroup;
import oracle.AWXML.ExtendedProperty;
import oracle.AWXML.ExternalSourceExpression;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Index;
import oracle.AWXML.Level;
import oracle.AWXML.MemberSelection;
import oracle.AWXML.Model;
import oracle.AWXML.PermanentCalculatedMember;
import oracle.AWXML.RestrictedSourceExpression;
import oracle.AWXML.SessionCalculatedMember;
import oracle.AWXML.SourceColumn;
import oracle.AWXML.WhereClause;

public class Dimension
extends AWObject {
    private Vector m_memberSelection = new Vector(0);
    private Vector m_hierarchies = new Vector(0);
    private Vector m_members = new Vector(0);
    private Vector m_models = new Vector(0);
    private boolean m_isTime = false;
    private boolean m_isMeasure = false;
    private boolean m_useNativeKey = false;
    private String m_hierListObj = null;
    private String m_levelListObj = null;
    private String m_hierLevelObj = null;
    private String m_isUniqueObj = null;
    private String m_hierIsValueObj = null;
    private String calculatedMemberObj = null;
    private String calculatedMemberPropObj = null;
    private String calculatedMemberCatalogObj = null;
    private String m_gidColumnName = null;
    private String m_prntetColumnName = null;
    private String m_prntgidColumnName = null;
    private Vector m_indexes = new Vector(0);

    public Dimension() {
        this.m_schema = "AW$DEFAULT";
    }

    public Dimension(BaseObject baseObject) {
        super(baseObject);
        this.m_schema = "AW$DEFAULT";
    }

    public String WriteToXML() {
        String string = null;
        string = Dimension.TAB() + this.WriteElementStart("Dimension");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Dimension.TAB() + this.WriteElementEndTag("Dimension") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string == null ? this.WriteAsAttribute("isTime", new Boolean(this.m_isTime).toString()) : string + this.WriteAsAttribute("isTime", new Boolean(this.m_isTime).toString());
        string = string == null ? this.WriteAsAttribute("isMeasure", new Boolean(this.m_isMeasure).toString()) : string + this.WriteAsAttribute("isMeasure", new Boolean(this.m_isMeasure).toString());
        string = string == null ? this.WriteAsAttribute("UseNativeKey", new Boolean(this.m_useNativeKey).toString()) : string + this.WriteAsAttribute("UseNativeKey", new Boolean(this.m_useNativeKey).toString());
        return string;
    }

    public String WriteContentsToXML() {
        BaseObject baseObject;
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_hierarchies.iterator();
        while (iterator.hasNext()) {
            baseObject = (Hierarchy)iterator.next();
            if (string == null) {
                string = baseObject.WriteToXML();
                continue;
            }
            string = string + baseObject.WriteToXML();
        }
        if (!this.m_memberSelection.isEmpty()) {
            string = string == null ? Dimension.TAB() + this.WriteElementStart("MemberSelection") + s_EndTag + s_NEWLINE : string + Dimension.TAB() + this.WriteElementStart("MemberSelection") + s_EndTag + s_NEWLINE;
            ++s_Indent;
            iterator = this.m_memberSelection.iterator();
            while (iterator.hasNext()) {
                baseObject = iterator.next();
                if (baseObject instanceof Level) {
                    string = string + ((Level)baseObject).WriteToXML();
                    continue;
                }
                string = string + ((MemberSelection)baseObject).WriteToXML();
            }
            --s_Indent;
            string = string + Dimension.TAB() + this.WriteElementEndTag("MemberSelection") + s_NEWLINE;
        }
        iterator = this.m_members.iterator();
        while (iterator.hasNext()) {
            baseObject = (CalculatedMember)iterator.next();
            if (string == null) {
                string = ((CalculatedMember)baseObject).WriteToXML();
                continue;
            }
            string = string + ((CalculatedMember)baseObject).WriteToXML();
        }
        iterator = this.m_models.iterator();
        while (iterator.hasNext()) {
            baseObject = (Model)iterator.next();
            if (string == null) {
                string = ((Model)baseObject).WriteToXML();
                continue;
            }
            string = string + ((Model)baseObject).WriteToXML();
        }
        iterator = this.m_indexes.iterator();
        while (iterator.hasNext()) {
            baseObject = (Index)iterator.next();
            if (string == null) {
                string = ((Index)baseObject).WriteToXML();
                continue;
            }
            string = string + ((Index)baseObject).WriteToXML();
        }
        return string;
    }

    public Dimension(String string, String string2) {
        super(string, string2);
        this.m_schema = "AW$DEFAULT";
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.toUpperCase();
        return this.m_name.toUpperCase() + "." + string.toUpperCase();
    }

    public String getParentId() {
        return this.m_name.toUpperCase();
    }

    public boolean getUseNativeKey() {
        return this.m_useNativeKey;
    }

    public void setUseNativeKey(boolean bl) {
        this.m_useNativeKey = bl;
    }

    public boolean isNativeKeyUnique() {
        return this.m_useNativeKey;
    }

    public void setIsNativeKeyUnique(boolean bl) {
        this.m_useNativeKey = bl;
    }

    public void setUseNativeKey(Boolean bl) {
        this.m_useNativeKey = bl;
    }

    public boolean isTime() {
        return this.m_isTime;
    }

    public void setIsTime(boolean bl) {
        this.m_isTime = bl;
    }

    public void setIsTime(Boolean bl) {
        this.m_isTime = bl;
    }

    public boolean isMeasure() {
        return this.m_isMeasure;
    }

    public void setIsMeasure(boolean bl) {
        this.m_isMeasure = bl;
    }

    public void setIsMeasure(Boolean bl) {
        this.m_isMeasure = bl;
    }

    public void addMemberSelection(MemberSelection memberSelection) {
        this.m_memberSelection.add(memberSelection);
        memberSelection.setOwner(this);
    }

    public void removeMemberSelection(MemberSelection memberSelection) {
        this.m_memberSelection.remove(memberSelection);
    }

    public Vector getMemberSelections() {
        return this.m_memberSelection;
    }

    public void addLevel(Level level) {
        this.m_memberSelection.add(level);
        level.setOwner(this);
    }

    public void removeLevel(Level level) {
        this.m_memberSelection.remove(level);
    }

    public Vector getLevels() {
        Vector vector = new Vector(0);
        Iterator iterator = this.m_memberSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Level)) continue;
            vector.add(e);
        }
        return vector;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        this.m_hierarchies.add(hierarchy);
        if (this.m_hierarchies.size() == 1) {
            hierarchy.setIsDefault(true);
        }
        hierarchy.setOwner(this);
    }

    public void removeHierarchy(Hierarchy hierarchy) {
        this.m_hierarchies.remove(hierarchy);
    }

    public Vector getHierarchies() {
        return this.m_hierarchies;
    }

    public MemberSelection createMemberSelection() {
        MemberSelection memberSelection = new MemberSelection(this);
        this.addMemberSelection(memberSelection);
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || attribute.getOwner() != this) continue;
            AttributeProjection attributeProjection = memberSelection.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return memberSelection;
    }

    public Level createLevel() {
        Level level = new Level(this);
        this.addLevel(level);
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || attribute.getOwner() != this) continue;
            AttributeProjection attributeProjection = level.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return level;
    }

    public Hierarchy createHierarchy() {
        Hierarchy hierarchy = new Hierarchy(this);
        this.addHierarchy(hierarchy);
        if (this.m_hierarchies.size() == 1) {
            hierarchy.setIsDefault(true);
        }
        Vector vector = AW.getCurAW().getExtendedProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            ExtendedProperty extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string2 = (string = extendedProperty.getReferencedObjectId()).substring(string.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE")) continue;
            String string3 = this.getNamePart(1, extendedProperty.getReferencedObjectId());
            Dimension dimension = AW.getCurAW().findDimension(string3);
            Attribute attribute = dimension.FindAttribute(this.getLogicalNamePart(extendedProperty.getReferencedObjectId()));
            if (attribute == null || attribute.getOwner() != this) continue;
            AttributeProjection attributeProjection = hierarchy.createAttributeProjection();
            attributeProjection.setAttribute(attribute);
        }
        return hierarchy;
    }

    public String Create(AWConnection aWConnection) {
        BaseObject baseObject;
        Object object;
        Object object2;
        String string = AWNULL;
        String string2 = AWNULL;
        if (this.m_isTime) {
            object2 = this.getAttributeBasedOnRole("TIME_SPAN");
            object = this.getAttributeBasedOnRole("END_DATE");
            if (object == null) {
                throw new AWException("AWXML-ERR-NUM-200002", new Object[]{this.m_name});
            }
            if (object2 == null) {
                throw new AWException("AWXML-ERR-NUM-200003", new Object[]{this.m_name});
            }
            string = this.quoteValue(((BaseObject)object2).getId());
            string2 = this.quoteValue(((BaseObject)object).getId());
        }
        object2 = AWNULL;
        if (this.m_isTime) {
            object2 = this.quoteValue("TIME");
        }
        aWConnection.executeCommand("call create_dimension(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + (String)object2 + "," + string2 + "," + string + "," + new Boolean(this.m_useNativeKey).toString() + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-200000", new Object[]{this.getId(), this.m_commandResultText});
        }
        object = this.getAttributes().iterator();
        while (object.hasNext()) {
            baseObject = (Attribute)object.next();
            ((Attribute)baseObject).Create(aWConnection);
        }
        object = this.getLevels().iterator();
        while (object.hasNext()) {
            baseObject = (Level)object.next();
            ((Level)baseObject).Create(aWConnection);
        }
        object = this.getHierarchies().iterator();
        while (object.hasNext()) {
            baseObject = (Hierarchy)object.next();
            ((Hierarchy)baseObject).Create(aWConnection);
        }
        object = this.m_members.iterator();
        while (object.hasNext()) {
            baseObject = (CalculatedMember)object.next();
            baseObject.Create(aWConnection);
        }
        object = this.m_models.iterator();
        while (object.hasNext()) {
            baseObject = (Model)object.next();
            ((Model)baseObject).Create(aWConnection);
        }
        object = this.getSourceMapGroup().iterator();
        while (object.hasNext()) {
            baseObject = (DimensionMapGroup)object.next();
            ((DimensionMapGroup)baseObject).Create(aWConnection);
        }
        object = this.m_indexes.iterator();
        while (object.hasNext()) {
            baseObject = (Index)object.next();
            ((Index)baseObject).Create(aWConnection);
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        ExtendedProperty extendedProperty;
        String string = aWConnection.executeCommand("call delete_dimension(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-200001", new Object[]{this.getId(), this.m_commandResultText});
        }
        Vector vector = AW.getCurAW().getExtendedProperties();
        Vector<ExtendedProperty> vector2 = new Vector<ExtendedProperty>(0);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3;
            String string4;
            extendedProperty = (ExtendedProperty)iterator.next();
            if (!extendedProperty.getCreator().equalsIgnoreCase("SYSTEM") || !extendedProperty.getExtensionName().equalsIgnoreCase("GLOBALATTRIBUTE") || !(string4 = (string3 = extendedProperty.getReferencedObjectId()).substring(string3.lastIndexOf(".") + 1)).equalsIgnoreCase("ATTRIBUTE") || !(string2 = this.getNamePart(1, extendedProperty.getReferencedObjectId())).equalsIgnoreCase(this.getName())) continue;
            vector2.add(extendedProperty);
        }
        if (vector2.size() > 0) {
            iterator = vector2.iterator();
            while (iterator.hasNext()) {
                extendedProperty = (ExtendedProperty)iterator.next();
                AW.getCurAW().removeExtendedProperty(extendedProperty);
            }
        }
        return "success";
    }

    public String Alter(AWConnection aWConnection) {
        Object object;
        String string = AWNULL;
        String string2 = AWNULL;
        if (this.m_isTime) {
            object = this.getAttributeBasedOnRole("TIME_SPAN");
            Attribute attribute = this.getAttributeBasedOnRole("END_DATE");
            if (attribute == null) {
                throw new AWException("AWXML-ERR-NUM-200002", new Object[]{this.m_name});
            }
            if (object == null) {
                throw new AWException("AWXML-ERR-NUM-200003", new Object[]{this.m_name});
            }
            string = this.quoteValue(((BaseObject)object).getId());
            string2 = this.quoteValue(attribute.getId());
        }
        object = AWNULL;
        if (this.m_isTime) {
            object = this.quoteValue("TIME");
        }
        aWConnection.executeCommand("call alter_dimension(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + (String)object + "," + string2 + "," + string + "," + new Boolean(this.m_useNativeKey).toString() + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-200009", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public String Rename(AWConnection aWConnection, String string) {
        try {
            aWConnection.executeCommand("rename " + this.getName() + " " + string);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return "success";
    }

    public Level FindLevel(String string) {
        Level level = null;
        Iterator iterator = this.getLevels().iterator();
        while (iterator.hasNext()) {
            Level level2 = (Level)iterator.next();
            if (!level2.getName().equals(string)) continue;
            level = level2;
            break;
        }
        return level;
    }

    public Attribute FindAttribute(String string) {
        Attribute attribute = null;
        Iterator iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getName().equals(string)) continue;
            attribute = attribute2;
            break;
        }
        return attribute;
    }

    public Hierarchy FindHierarchy(String string) {
        Hierarchy hierarchy = null;
        Iterator iterator = this.getHierarchies().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy2 = (Hierarchy)iterator.next();
            if (!hierarchy2.getName().equals(string)) continue;
            hierarchy = hierarchy2;
            break;
        }
        return hierarchy;
    }

    public void addPermanentCalculatedMember(PermanentCalculatedMember permanentCalculatedMember) {
        this.m_members.add(permanentCalculatedMember);
        permanentCalculatedMember.setOwner(this);
    }

    public void removePermanentCalculatedMember(PermanentCalculatedMember permanentCalculatedMember) {
        this.m_members.remove(permanentCalculatedMember);
    }

    public void addSessionCalculatedMember(SessionCalculatedMember sessionCalculatedMember) {
        this.m_members.add(sessionCalculatedMember);
        sessionCalculatedMember.setOwner(this);
    }

    public void removeSessionCalculatedMember(SessionCalculatedMember sessionCalculatedMember) {
        this.m_members.remove(sessionCalculatedMember);
    }

    public Vector getCalculatedMembers() {
        return this.m_members;
    }

    public PermanentCalculatedMember createPermanentCalculatedMember() {
        PermanentCalculatedMember permanentCalculatedMember = new PermanentCalculatedMember(this);
        this.addPermanentCalculatedMember(permanentCalculatedMember);
        return permanentCalculatedMember;
    }

    public SessionCalculatedMember createSessionCalculatedMember() {
        SessionCalculatedMember sessionCalculatedMember = new SessionCalculatedMember(this);
        this.addSessionCalculatedMember(sessionCalculatedMember);
        return sessionCalculatedMember;
    }

    public Attribute getAttributeBasedOnRole(String string) {
        Attribute attribute = null;
        Iterator iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getClassification().equals(string)) continue;
            attribute = attribute2;
            break;
        }
        return attribute;
    }

    public void readAWDefinitions(AWConnection aWConnection, boolean bl) {
        block42: {
            block41: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                if (this.m_dataRead) break block41;
                this.m_dataRead = true;
                aWConnection.limitDimension(AW.s_allDimsObj, "TO", this.getId());
                aWConnection.executeCommand("call __RTL_NAMETODIMOBJS('" + this.getName() + "')");
                String string = aWConnection.getValue("charlist(joincols(obj(property 'AW$ROLE') ':' name))");
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = string2.substring(0, string2.indexOf(":"));
                    String string4 = string2.substring(string2.indexOf(":") + 1);
                    if (string3.equalsIgnoreCase("HIERLIST")) {
                        this.m_hierListObj = string4;
                    }
                    if (string3.equalsIgnoreCase("LEVELLIST")) {
                        this.m_levelListObj = string4;
                    }
                    if (string3.equalsIgnoreCase("HIER_LEVELS")) {
                        this.m_hierLevelObj = string4;
                    }
                    if (string3.equalsIgnoreCase("DIMKEY_IS_UNIQUE")) {
                        this.m_isUniqueObj = string4;
                    }
                    if (string3.equalsIgnoreCase("HIER_IS_VALUE")) {
                        this.m_hierIsValueObj = string4;
                    }
                    if (string3.equalsIgnoreCase("ALL_CALC_MEMBERS")) {
                        this.calculatedMemberObj = string4;
                    }
                    if (string3.equalsIgnoreCase("CALC_MEMBER_PROP")) {
                        this.calculatedMemberPropObj = string4;
                    }
                    if (!string3.equalsIgnoreCase("CALC_MEMBER_CATALOG")) continue;
                    this.calculatedMemberCatalogObj = string4;
                }
                aWConnection.limitDimension(AW.s_allDimsObj, "TO", this.getId());
                String string5 = aWConnection.getValue("convert(" + AW.getCurAW().getName() + "!" + this.m_isUniqueObj + " integer)");
                if (!string5.equalsIgnoreCase("NA")) {
                    if (string5.equalsIgnoreCase("0")) {
                        this.setIsNativeKeyUnique(false);
                    }
                    if (string5.equalsIgnoreCase("1")) {
                        this.setIsNativeKeyUnique(true);
                    }
                }
                String string6 = aWConnection.getPhysicalObjectName("DIMDEF", this.m_name);
                String string7 = aWConnection.executeCommand("show obj(PROPERTY 'SORT_ATTRIBUTE' '" + string6 + "')");
                String string8 = aWConnection.executeCommand("show obj(PROPERTY 'DEFAULT_HIERARCHY' '" + string6 + "')");
                this.m_columnName = aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME_ET' '" + string6 + "')");
                this.m_gidColumnName = aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME_GID' '" + string6 + "')");
                this.m_prntetColumnName = aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME_PRNTET' '" + string6 + "')");
                this.m_prntgidColumnName = aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME_PRNTGID' '" + string6 + "')");
                Vector vector = aWConnection.getRoleBasedObjects("ATTRDEF", this.getName());
                Object object11 = vector.iterator();
                while (object11.hasNext()) {
                    object10 = this.createAttribute();
                    object9 = (String)object11.next();
                    ((BaseObject)object10).setName(aWConnection.getLogicalObjectName((String)object9));
                    aWConnection.getDescriptors((BaseObject)object10);
                    if (AW.s_relationalAttributeData != null) {
                        aWConnection.limitDimension(AW.s_allAttributesObject, "TO", ((BaseObject)object10).getId());
                        object8 = aWConnection.getValue(AW.s_relationalAttributeData);
                        if (!((String)object8).toUpperCase().equals("NA")) {
                            ((Attribute)object10).setDimensionDomain(AW.s_curAW.findDimension(this.getLogicalNamePart((String)object8)));
                        }
                    }
                    object8 = aWConnection.executeCommand("show obj(PROPERTY 'AW$TYPE' '" + (String)object9 + "')");
                    object7 = aWConnection.executeCommand("show obj(DATA '" + (String)object9 + "')");
                    object6 = aWConnection.executeCommand("show obj(PROPERTY 'AW$ATTR_INDEX' '" + (String)object9 + "')");
                    object5 = aWConnection.executeCommand("show obj(PROPERTY 'DATA_TYPE' '" + (String)object9 + "')");
                    if (((String)object6).equalsIgnoreCase("YES")) {
                        object4 = this.createIndex();
                        ((Index)object4).setAttribute((Attribute)object10);
                        ((Attribute)object10).setDataType((String)object5);
                    } else if (((Attribute)object10).getDimensionDomain() == null) {
                        ((Attribute)object10).setDataType((String)object7);
                    }
                    ((BaseObject)object10).setColumnName(aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME' '" + (String)object9 + "')"));
                    if (!((String)object8).toUpperCase().equals("NA")) {
                        ((Attribute)object10).setClassification((String)object8);
                    }
                    if (string7.equalsIgnoreCase(((BaseObject)object10).getName())) {
                        ((Attribute)object10).setIsDefaultOrder(true);
                    }
                    if (!((String)(object4 = aWConnection.executeCommand("show obj(PROPERTY 'AW$LNG_ATTRIBUTE' '" + (String)object9 + "')"))).equalsIgnoreCase("YES")) continue;
                    ((Attribute)object10).setIsMultiLingual(true);
                }
                aWConnection.limitDimension(AW.s_allHierarchiesObject, "TO", this.m_name + ".AW$NONE.HIERARCHY");
                aWConnection.limitDimension(AW.s_allLevelsObject, "TO", this.m_name + ".AW$NONE.LEVEL");
                this.readSourceMappings(aWConnection, this);
                object11 = this.getId();
                object11 = ((String)object11).substring(0, ((String)object11).lastIndexOf("."));
                object10 = aWConnection.getRoleBasedDimVals("LEVELLIST", this.getName());
                object9 = ((Vector)object10).iterator();
                while (object9.hasNext()) {
                    object8 = this.createLevel();
                    ((BaseObject)object8).setName((String)object9.next());
                    aWConnection.getDescriptors((BaseObject)object8);
                    aWConnection.limitDimension(AW.s_allLevelsObject, "TO", ((BaseObject)object8).getId());
                    object7 = aWConnection.getPhysicalObjectName("LEVELDEF", ((BaseObject)object8).getName(), this.getName());
                    ((BaseObject)object8).setColumnName(aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME' '" + (String)object7 + "')"));
                    object6 = new Vector(0);
                    if (AW.s_attrVisibleObject != null) {
                        aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_allAttributesObject + " TO " + AW.getCurAW().getName() + "!" + AW.s_attrVisibleObject + " EQ true");
                        object6 = aWConnection.getDimensionValues(AW.s_allAttributesObject);
                    }
                    object5 = ((Vector)object6).iterator();
                    while (object5.hasNext()) {
                        object4 = (String)object5.next();
                        object4 = ((String)object4).substring(0, ((String)object4).lastIndexOf("."));
                        object4 = ((String)object4).substring(((String)object4).lastIndexOf(".") + 1);
                        object3 = ((AWObject)object8).createAttributeProjection();
                        ((BaseObject)object3).setName((String)object4);
                        ((AttributeProjection)object3).setAttribute(this.findAttribute((String)object4));
                    }
                    this.readSourceMappings(aWConnection, (AWObject)object8);
                }
                object9 = aWConnection.getRoleBasedDimVals("HIERLIST", this.getName());
                object8 = ((Vector)object9).iterator();
                while (object8.hasNext()) {
                    object7 = this.createHierarchy();
                    ((BaseObject)object7).setDataRead(false);
                    ((BaseObject)object7).setName((String)object8.next());
                    aWConnection.getDescriptors((BaseObject)object7);
                    if (((BaseObject)object7).getName().equalsIgnoreCase(string8)) {
                        ((Hierarchy)object7).setIsDefault(new Boolean(true));
                    }
                    ((BaseObject)object7).setDataRead(false);
                    if (bl) {
                        ((Hierarchy)object7).readAWDefinitions(aWConnection, true);
                        continue;
                    }
                    ((BaseObject)object7).setDataRead(false);
                }
                object8 = new Vector(0);
                if (this.calculatedMemberObj != null) {
                    object8 = aWConnection.getDimensionValues(this.calculatedMemberObj);
                }
                object7 = ((Vector)object8).iterator();
                while (object7.hasNext()) {
                    object6 = (String)object7.next();
                    if (((String)object6).indexOf(this.getLogicalNamePart(this.getId()) + ".") < 0) continue;
                    aWConnection.limitDimension(this.calculatedMemberObj, "TO", (String)object6);
                    object5 = this.createPermanentCalculatedMember();
                    ((BaseObject)object5).setName(((BaseObject)object5).getLogicalNamePart((String)object6));
                    aWConnection.limitDimension(this.calculatedMemberPropObj, "TO", "INPUT_MEMBER");
                    object4 = aWConnection.getValue(AW.getCurAW().getName() + "!" + this.calculatedMemberCatalogObj);
                    object3 = null;
                    object2 = null;
                    if (((String)object4).indexOf("\n") > 0) {
                        object = new StringTokenizer((String)object4, "\n");
                        object3 = ((StringTokenizer)object).nextToken();
                        object2 = ((StringTokenizer)object).nextToken();
                        ((PermanentCalculatedMember)object5).setIsOverride(true);
                    } else {
                        object3 = object4;
                    }
                    ((PermanentCalculatedMember)object5).setMemberReference((String)object2);
                    ((BaseObject)object5).setName(this.getLogicalNamePart((String)object3));
                    aWConnection.limitDimension(this.calculatedMemberPropObj, "TO", "MEMBER_SHORT_DESCRIPTION");
                    ((BaseObject)object5).setShortName(aWConnection.getValue(AW.getCurAW().getName() + "!" + this.calculatedMemberCatalogObj));
                    aWConnection.limitDimension(this.calculatedMemberPropObj, "TO", "MEMBER_LONG_DESCRIPTION");
                    ((BaseObject)object5).setLongName(aWConnection.getValue(AW.getCurAW().getName() + "!" + this.calculatedMemberCatalogObj));
                    aWConnection.limitDimension(this.calculatedMemberPropObj, "TO", "INPUT_EQUATION");
                    ((CalculatedMember)object5).setExpressionText(aWConnection.getValue(AW.getCurAW().getName() + "!" + this.calculatedMemberCatalogObj));
                    aWConnection.limitDimension(this.calculatedMemberPropObj, "TO", "MEMBER_TYPE");
                    ((PermanentCalculatedMember)object5).setStorageType(aWConnection.getValue(AW.getCurAW().getName() + "!" + this.calculatedMemberCatalogObj));
                }
                aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_allModelsObj + " TO " + AW.getCurAW().getName() + "!" + AW.s_allDimsObj);
                object7 = aWConnection.getDimensionValues(AW.s_allModelsObj);
                object6 = ((Vector)object7).iterator();
                while (object6.hasNext()) {
                    object5 = (String)object6.next();
                    aWConnection.limitDimension(AW.s_allModelsObj, "TO", (String)object5);
                    object4 = this.createModel();
                    ((BaseObject)object4).setId((String)object5);
                    object3 = this.getLogicalNamePart((String)object5);
                    ((BaseObject)object4).setName((String)object3);
                    aWConnection.getDescriptors((BaseObject)object4);
                    object2 = aWConnection.getDimensionValues(AW.s_modelMembersObj);
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        String string9 = (String)object.next();
                        string9 = string9.substring(string9.indexOf(".") + 1);
                        CalculatedMember calculatedMember = null;
                        Object object12 = this.getCalculatedMembers().iterator();
                        while (object12.hasNext()) {
                            CalculatedMember calculatedMember2 = (CalculatedMember)object12.next();
                            if (!calculatedMember2.getName().equalsIgnoreCase(string9)) continue;
                            calculatedMember = calculatedMember2;
                            break;
                        }
                        if (calculatedMember == null) continue;
                        object12 = ((Model)object4).createCalculatedMemberRef();
                        ((CalculatedMemberRef)object12).setCalculatedMember(calculatedMember);
                    }
                }
                break block42;
            }
            if (!bl) break block42;
            aWConnection.limitDimension(AW.s_allDimsObj, "TO", this.getId());
            aWConnection.executeCommand("call __RTL_NAMETODIMOBJS('" + this.getName() + "')");
            String string = aWConnection.getValue("charlist(joincols(obj(property 'AW$ROLE') ':' name))");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string10 = stringTokenizer.nextToken();
                String string11 = string10.substring(0, string10.indexOf(":"));
                String string12 = string10.substring(string10.indexOf(":") + 1);
                if (string11.equalsIgnoreCase("HIERLIST")) {
                    this.m_hierListObj = string12;
                }
                if (string11.equalsIgnoreCase("LEVELLIST")) {
                    this.m_levelListObj = string12;
                }
                if (string11.equalsIgnoreCase("HIER_LEVELS")) {
                    this.m_hierLevelObj = string12;
                }
                if (string11.equalsIgnoreCase("DIMKEY_IS_UNIQUE")) {
                    this.m_isUniqueObj = string12;
                }
                if (string11.equalsIgnoreCase("HIER_IS_VALUE")) {
                    this.m_hierIsValueObj = string12;
                }
                if (string11.equalsIgnoreCase("ALL_CALC_MEMBERS")) {
                    this.calculatedMemberObj = string12;
                }
                if (string11.equalsIgnoreCase("CALC_MEMBER_PROP")) {
                    this.calculatedMemberPropObj = string12;
                }
                if (!string11.equalsIgnoreCase("CALC_MEMBER_CATALOG")) continue;
                this.calculatedMemberCatalogObj = string12;
            }
            aWConnection.limitDimension(AW.s_allDimsObj, "TO", this.getId());
            Iterator iterator = this.m_hierarchies.iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                hierarchy.readAWDefinitions(aWConnection, true);
            }
        }
    }

    private void readSourceMappings(AWConnection aWConnection, AWObject aWObject) {
        Vector vector = new Vector(0);
        if (AW.s_mapGroupListObject != null) {
            aWConnection.limitDimensionBasedOnData(AW.s_mapGroupListObject, "TO", AW.s_mapKeyObject, "NE", "NA");
            vector = aWConnection.getDimensionValues(AW.s_mapGroupListObject);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            BaseObject baseObject;
            Object object;
            Object object2;
            Object object3;
            DimensionMapGroup dimensionMapGroup = aWObject.createSourceDimensionMapGroup();
            String string = (String)iterator.next();
            aWConnection.limitDimension(AW.s_mapGroupListObject, "TO", string);
            String string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapKeyObject);
            dimensionMapGroup.setName(dimensionMapGroup.getLogicalNamePart(string));
            if (!string2.toUpperCase().equals("NA")) {
                object3 = dimensionMapGroup.CreateKeyMap();
                if (string2.indexOf("?") > 0) {
                    object2 = string2.substring(string2.indexOf("?") + 1);
                    string2 = string2.substring(0, string2.indexOf("?"));
                    object = ((RestrictedSourceExpression)object3).createRestriction();
                    ((WhereClause)object).setWhereClause((String)object2);
                }
                if (string2.indexOf(",") > 0) {
                    object2 = new StringTokenizer(string2, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        baseObject = ((ExternalSourceExpression)object3).CreateSourceColumn();
                        ((SourceColumn)baseObject).setColumn((String)object);
                    }
                } else {
                    object2 = ((ExternalSourceExpression)object3).CreateSourceColumn();
                    ((SourceColumn)object2).setColumn(string2);
                }
            }
            if (!(aWObject instanceof Dimension)) {
                try {
                    string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapParentObject);
                    if (!string2.equals("NA")) {
                        object3 = dimensionMapGroup.CreateParentMap();
                        if (string2.indexOf(",") > 0) {
                            object2 = new StringTokenizer(string2, ",");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                object = ((StringTokenizer)object2).nextToken();
                                baseObject = ((ExternalSourceExpression)object3).CreateSourceColumn();
                                ((SourceColumn)baseObject).setColumn((String)object);
                            }
                        } else {
                            object2 = ((ExternalSourceExpression)object3).CreateSourceColumn();
                            ((SourceColumn)object2).setColumn(string2);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                aWConnection.limitDimensionBasedOnData(AW.s_allAttributesObject, "TO", AW.s_mapAttrObject, "NE", "NA");
                object3 = aWConnection.getDimensionValues(AW.s_allAttributesObject);
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    Object object4;
                    Object object5;
                    object = (String)object2.next();
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
                    baseObject = this.findAttribute((String)object);
                    string2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapAttrObject + "(" + AW.getCurAW().getName() + "!" + AW.s_allAttributesObject + " '" + baseObject.getId() + "')");
                    if (string2.indexOf(":") < 0) {
                        object5 = dimensionMapGroup.CreateAttributeMap();
                        if (aWObject instanceof Dimension) {
                            ((AttributeSourceExpression)object5).setTargetObject(baseObject);
                        } else {
                            object4 = null;
                            if (aWObject instanceof Level) {
                                object4 = ((Level)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof Hierarchy) {
                                object4 = ((Hierarchy)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof HierarchyLevelAssociation) {
                                object4 = ((HierarchyLevelAssociation)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            ((AttributeSourceExpression)object5).setTargetObject((BaseObject)object4);
                        }
                        object4 = ((ExternalSourceExpression)object5).CreateSourceColumn();
                        ((SourceColumn)object4).setColumn(string2);
                        continue;
                    }
                    object5 = new StringTokenizer(string2, "\n");
                    while (((StringTokenizer)object5).hasMoreTokens()) {
                        BaseObject baseObject2;
                        object4 = ((StringTokenizer)object5).nextToken();
                        String string3 = ((String)object4).substring(0, ((String)object4).indexOf(":"));
                        String string4 = ((String)object4).substring(((String)object4).lastIndexOf(":") + 1);
                        AttributeSourceExpression attributeSourceExpression = dimensionMapGroup.CreateAttributeMap(string3);
                        if (aWObject instanceof Dimension) {
                            attributeSourceExpression.setTargetObject(baseObject);
                        } else {
                            baseObject2 = null;
                            if (aWObject instanceof Level) {
                                baseObject2 = ((Level)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof Hierarchy) {
                                baseObject2 = ((Hierarchy)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            if (aWObject instanceof HierarchyLevelAssociation) {
                                baseObject2 = ((HierarchyLevelAssociation)aWObject).findAttributeProjection((Attribute)baseObject);
                            }
                            attributeSourceExpression.setTargetObject(baseObject2);
                        }
                        baseObject2 = attributeSourceExpression.CreateSourceColumn();
                        baseObject2.setColumn(string4);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void addModel(Model model) {
        this.m_models.add(model);
    }

    public void removeModel(Model model) {
        this.m_models.remove(model);
    }

    public Vector getModels() {
        return this.m_models;
    }

    public Model createModel() {
        Model model = new Model(this);
        this.addModel(model);
        return model;
    }

    public boolean validateName(String string, BaseObject baseObject) {
        boolean bl = true;
        Iterator iterator = null;
        if (baseObject instanceof Attribute) {
            iterator = this.m_attributes.iterator();
        }
        if (baseObject instanceof Level) {
            iterator = this.m_memberSelection.iterator();
        }
        if (baseObject instanceof Hierarchy) {
            iterator = this.m_hierarchies.iterator();
        }
        if (baseObject instanceof Model) {
            iterator = this.m_models.iterator();
        }
        if (iterator != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                BaseObject baseObject2 = (BaseObject)iterator2.next();
                if (!baseObject2.getName().equalsIgnoreCase(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public String getHierListObj() {
        return this.m_hierListObj;
    }

    public String getHierLevelObj() {
        return this.m_hierLevelObj;
    }

    public String getHierIsValueObj() {
        return this.m_hierIsValueObj;
    }

    public String getGidColumnName() {
        return this.m_gidColumnName;
    }

    public String getParentETColumnName() {
        return this.m_prntetColumnName;
    }

    public String getParentGidColumnName() {
        return this.m_prntgidColumnName;
    }

    protected void removeAttributeReferences(Attribute attribute) {
        BaseObject baseObject;
        Iterator iterator;
        Object object;
        Object object2 = this.m_memberSelection.iterator();
        while (object2.hasNext()) {
            object = (AWObject)object2.next();
            ((AWObject)object).removeAttributeProjection(attribute);
        }
        object2 = this.m_hierarchies.iterator();
        while (object2.hasNext()) {
            object = (Hierarchy)object2.next();
            iterator = ((Hierarchy)object).getHierarchyLevels().iterator();
            while (iterator.hasNext()) {
                baseObject = (HierarchyLevelAssociation)iterator.next();
                ((AWObject)baseObject).removeAttributeProjection(attribute);
            }
            ((AWObject)object).removeAttributeProjection(attribute);
        }
        object2 = AW.getCurAW().getExtendedProperties();
        object = new Vector(0);
        iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            baseObject = (ExtendedProperty)iterator.next();
            if (!((ExtendedProperty)baseObject).getReferencedObjectId().equalsIgnoreCase(attribute.getId())) continue;
            ((Vector)object).add(baseObject);
        }
        if (((Vector)object).size() > 0) {
            iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                baseObject = (ExtendedProperty)iterator.next();
                AW.getCurAW().removeExtendedProperty((ExtendedProperty)baseObject);
            }
        }
    }

    protected void createGlobalAttributeReferences(Attribute attribute, AWConnection aWConnection) {
        AWObject aWObject;
        Iterator iterator = this.m_memberSelection.iterator();
        while (iterator.hasNext()) {
            aWObject = (AWObject)iterator.next();
            aWObject.addAttributeProjection(attribute, aWConnection);
        }
        iterator = this.m_hierarchies.iterator();
        while (iterator.hasNext()) {
            aWObject = (Hierarchy)iterator.next();
            Iterator iterator2 = ((Hierarchy)aWObject).getHierarchyLevels().iterator();
            while (iterator2.hasNext()) {
                HierarchyLevelAssociation hierarchyLevelAssociation = (HierarchyLevelAssociation)iterator2.next();
                hierarchyLevelAssociation.addAttributeProjection(attribute, aWConnection);
            }
            aWObject.addAttributeProjection(attribute, aWConnection);
        }
    }

    public Index createIndex() {
        Index index = new Index(this);
        this.m_indexes.add(index);
        return index;
    }

    public void addIndex(Index index) {
        this.m_indexes.add(index);
    }

    public void removeIndex(Index index) {
        this.m_indexes.remove(index);
    }

    public Vector getIndexes() {
        return this.m_indexes;
    }

    public String ValidateCalculatedMembers(AWConnection aWConnection) {
        String string = "success";
        aWConnection.executeCommand("call validate_dim_calcmember(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("Error Validating Calculated Members: " + this.m_commandResultText);
        }
        return string;
    }
}

