/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Cube;
import oracle.AWXML.Measure;

public class MeasureFolder
extends BaseObject {
    private Vector m_measures = new Vector(0);
    private Vector m_subFolders = new Vector(0);

    public MeasureFolder() {
    }

    public MeasureFolder(BaseObject baseObject) {
        super(baseObject);
        if (!(baseObject instanceof MeasureFolder)) {
            throw new AWException("AWXML-ERR-NUM-800002");
        }
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = null;
        if (this.m_owner != null) {
            string = this.m_owner.getName();
        }
        String string2 = this.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        string2 = string2.toUpperCase();
        if (string == null) {
            return this.m_name.toUpperCase() + "." + string2.toUpperCase();
        }
        return string.toUpperCase() + "." + this.m_name.toUpperCase() + "." + string2.toUpperCase();
    }

    public MeasureFolder createMeasureFolder() {
        MeasureFolder measureFolder = new MeasureFolder(this);
        this.m_subFolders.add(measureFolder);
        return measureFolder;
    }

    public void addMeasureFolder(MeasureFolder measureFolder) {
        this.m_subFolders.add(measureFolder);
    }

    public void removeMeasureFolder(MeasureFolder measureFolder) {
        this.m_subFolders.remove(measureFolder);
    }

    public Vector getMeasureFolders() {
        return this.m_subFolders;
    }

    public void addMeasure(Measure measure) {
        int n = this.m_measures.indexOf(measure);
        if (n < 0) {
            this.m_measures.add(measure);
        }
    }

    public void removeMeasure(Measure measure) {
        this.m_measures.remove(measure);
    }

    public Vector getMeasures() {
        return this.m_measures;
    }

    public String WriteToXML() {
        String string = null;
        string = MeasureFolder.TAB() + this.WriteElementStart("MeasureFolder");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + MeasureFolder.TAB() + this.WriteElementEndTag("MeasureFolder") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        return string;
    }

    public String WriteContentsToXML() {
        BaseObject baseObject;
        ++s_Indent;
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_measures.iterator();
        while (iterator.hasNext()) {
            baseObject = (Measure)iterator.next();
            if (string == null) {
                string = this.WriteAsIDRef("Measure", baseObject);
                continue;
            }
            string = string + this.WriteAsIDRef("Measure", baseObject);
        }
        iterator = this.m_subFolders.iterator();
        while (iterator.hasNext()) {
            baseObject = (MeasureFolder)iterator.next();
            if (string == null) {
                string = ((MeasureFolder)baseObject).WriteToXML();
                continue;
            }
            string = string + ((MeasureFolder)baseObject).WriteToXML();
        }
        --s_Indent;
        return string;
    }

    public String Create(AWConnection aWConnection) {
        BaseObject baseObject;
        Iterator iterator;
        String string;
        String string2 = "success";
        String string3 = "NA";
        boolean bl = aWConnection.isUsingLongArgProcessing();
        if (!bl) {
            string = aWConnection.getUsageBasedObjectName("CATALOGS", null, "ALL_MEASURES");
            if (this.m_measures.size() != 0) {
                string3 = "values(" + string + ")";
            }
            aWConnection.executeCommand("oknullstatus = true");
            aWConnection.executeCommand("limit " + string + " to null");
            iterator = this.m_measures.iterator();
            while (iterator.hasNext()) {
                baseObject = (Measure)iterator.next();
                aWConnection.executeCommand("limit " + string + " add '" + baseObject.getId() + "'");
            }
        } else if (this.m_measures.size() != 0) {
            string = aWConnection.executeCommand("call SET_LONG_ARG(NA,1)");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-800000", new Object[]{this.getId(), this.m_commandResultText});
            }
            string3 = this.quoteValue("AW$XML_ARG:1");
            iterator = this.m_measures.iterator();
            while (iterator.hasNext()) {
                baseObject = (Measure)iterator.next();
                String string4 = aWConnection.executeCommand("call SET_LONG_ARG(" + this.quoteValue(baseObject.getId()) + ",1)");
                this.m_listResults = aWConnection.getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) >= 0) continue;
                throw new AWException("AWXML-ERR-NUM-800000", new Object[]{this.getId(), this.m_commandResultText});
            }
        }
        string = aWConnection.executeCommand("call create_measurefolder(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + string3 + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-800000", new Object[]{this.getId(), this.m_commandResultText});
        }
        iterator = this.m_subFolders.iterator();
        while (iterator.hasNext()) {
            baseObject = (MeasureFolder)iterator.next();
            ((MeasureFolder)baseObject).Create(aWConnection);
        }
        return string2;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "success";
        String string2 = aWConnection.executeCommand("call delete_measurefolder(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-800001", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public void readAWMetaData(AWConnection aWConnection) {
        this.m_dataRead = true;
        aWConnection.executeCommand(" limit " + AW.getCurAW().getName() + "!" + AW.s_allMeasureFoldersObj + " TO " + this.quoteValue(this.getId()));
        aWConnection.executeCommand(" limit " + AW.getCurAW().getName() + "!" + AW.s_measureListObject + " TO " + AW.getCurAW().getName() + "!" + AW.s_measInFolderObj);
        Vector vector = aWConnection.getDimensionValues(AW.s_measureListObject);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Cube cube = AW.s_curAW.findCube(this.getNamePart(1, string));
            Measure measure = cube.findMeasure(this.getLogicalNamePart(string));
            if (measure == null) {
                measure = cube.findDerivedMeasure(this.getLogicalNamePart(string));
            }
            this.addMeasure(measure);
        }
    }
}

