/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleCallableStatement;

public class ApexDropAction
extends AbstractMenuAction {
    static final String COUNT_SQL = "select count(1) script from APEX_APPLICATION_SUPP_OBJECTS   where application_id = :APPLICATION_ID";
    static final String DROP_SQL = "begin   wwv_flow_api.set_security_group_id(p_security_group_id=>:SGID); wwv_flow_api.remove_flow(:APPLICATION_ID); end;";
    private static final Logger LOGGER = Logger.getLogger(ApexDropAction.class.getName());
    private JCheckBox _run;
    private ScriptExecutor _sr;
    private DBObject _dbo;
    private boolean isProcessed = false;

    @Override
    public void launch() {
        this._dbo = this.getDBObject();
        boolean bl = false;
        String string = DBUtil.getInstance((String)this._dbo.getConnectionName()).executeReturnOneCol(COUNT_SQL, this._dbo.getDictionary());
        if (string.equals("1")) {
            bl = true;
        }
        if (bl) {
            this.dropAppUninstall();
        } else {
            boolean bl2 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)(ApexImportArb.getString("CONFIRM_DROP_APPLICATION") + ":" + this._dbo.getObjectName()), (String)ApexImportArb.getString("CONFIRM_DROP_APPLICATION"), (String)"f1_dropapexapplication");
            if (bl2) {
                this.dropApp();
            } else {
                this.setBlockOACRefresh(true);
            }
        }
    }

    private void dropAppUninstall() {
        this._run = new JCheckBox(ApexImportArb.getString("RUN_UNINSTALL"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(ApexImportArb.getString("CONFIRM_DROP_APPLICATION")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        jPanel.add((Component)new JLabel(ApexImportArb.format("CONTAINS_UNINSTALL_SCRIPT", this._dbo.getObjectName())), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        jPanel.add((Component)this._run, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        URLHyperlinkButton uRLHyperlinkButton = new URLHyperlinkButton();
        uRLHyperlinkButton.setText(Messages.getString("ApexDropAction.5"));
        uRLHyperlinkButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ApexDropAction.this.showPreview();
            }
        });
        jPanel.add((Component)uRLHyperlinkButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        this.isProcessed = false;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = !((JEWTDialog)actionEvent.getSource()).isCancelled();
                if (bl && ApexDropAction.this._run.isSelected()) {
                    ApexDropAction.this.isProcessed = true;
                    ApexDropAction.this.runUninstall();
                } else if (bl && !ApexDropAction.this._run.isSelected()) {
                    ApexDropAction.this.isProcessed = true;
                    ApexDropAction.this.dropApp();
                } else {
                    ApexDropAction.this.isProcessed = false;
                }
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
            }
        };
        jPanel.putClientProperty("HELP_TEXT", ApexImportArb.getString("DROP_HELP"));
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)ApexImportArb.getString("CONFIRM_DROP_APPLICATION"), (ActionListener)actionListener);
        if (!this.isProcessed) {
            this.setBlockOACRefresh(true);
        }
    }

    private void dropApp() {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this._dbo.getConnection().prepareCall(DROP_SQL);
            oracleCallableStatement.setBigDecimalAtName("SGID", (BigDecimal)this._dbo.getDictionary().get("WORKSPACE_ID"));
            oracleCallableStatement.setBigDecimalAtName("APPLICATION_ID", (BigDecimal)this._dbo.getDictionary().get("APPLICATION_ID"));
            oracleCallableStatement.execute();
            this._dbo.getConnection().commit();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void runUninstall() {
        final Connection connection = this._dbo.getConnection();
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        final DBObject dBObject = this._dbo;
        final DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(ApexImportArb.getString("RUN_UNINSTALL"), null, 500, null, (Component)basicEditorPane);
        basicEditorPane.setText("");
        this.setBlockOACRefresh(true);
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            @Override
            public void cancel() {
                ApexDropAction.this._sr.interrupt();
                this._isCanceled = true;
            }

            @Override
            public Object doWork() {
                Object var1_1 = null;
                ApexDropAction.this.run(basicEditorPane, ApexImporter.getUnInstallScript(connection, (BigDecimal)dBObject.getDictionary().get("APPLICATION_ID")), connection, delayedProgressRunnable);
                try {
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                int n = ApexDropAction.this._sr.getScriptRunnerContext().getSqlError();
                String string = (String)ApexDropAction.this._sr.getScriptRunnerContext().getProperty("sqldev.last.err.name");
                if (n != 0 || string != null || ApexDropAction.this._sr.getScriptRunnerContext().getExited()) {
                    ScriptUtils.showError(basicEditorPane);
                } else {
                    ApexDropAction.this.dropApp();
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)ApexImportArb.getString("APPLICATION_DROPPED"), (String)ApexImportArb.getString("APPLICATION_DROPPED"), null);
                }
                return var1_1;
            }

            @Override
            public void finish(Object object) {
                if (this._isCanceled) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe(Messages.getString("ApexDropAction.12"));
                    }
                }
                ObjectActionController.getPostProcessCallback(ApexDropAction.this.getObjectAction(), ApexDropAction.this._dbo).run();
            }

            @Override
            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                delayedProgressRunnable.setRunnable(iDelayedProgressRunnable);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    private void run(BasicEditorPane basicEditorPane, String string, Connection connection, DelayedProgressRunnable delayedProgressRunnable) {
        this._sr = new ScriptExecutor(string, connection);
        basicEditorPane.setEditable(true);
        this._sr.setScriptRunnerContext(new ScriptRunnerContext());
        this._sr.getScriptRunnerContext().setSubstitutionChar('^');
        this._sr.getScriptRunnerContext().setSubstitutionOn(false);
        this._sr.getScriptRunnerContext().setScanOn(false);
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            LOGGER.throwing(ScriptUtils.class.getName(), Messages.getString("ApexDropAction.13"), iOException);
        }
        this._sr.setOut(bufferedOutputStream);
        this._sr.start();
        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
        outputRedirector.setName("Script output reader");
        outputRedirector.setProgressPanel(delayedProgressRunnable.getProgressPanel());
        outputRedirector.start();
        basicEditorPane.setEditable(false);
        while (this._sr.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void showPreview() {
        String string = ApexImporter.getUnInstallScript(this._dbo.getConnection(), (BigDecimal)this._dbo.getDictionary().get("APPLICATION_ID"));
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane);
        basicEditorPane.setText(string);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)Messages.getString("ApexDropAction.13"), (int)2);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }
}

