/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SearchForObjects;
import oracle.javatools.db.DBException;

public class DBObjectSearch
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField _search;
    private JButton _go;
    private JComboBox _schema;
    private String _schemaName;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private String _connName;
    private DefaultListModel _model = new DefaultListModel();
    private JList _tableList = new JList(this._model);
    private String _type;

    public DBObjectSearch(String string) {
        this._connName = string;
        this.init();
    }

    public DBObjectSearch() {
    }

    public void setConn(String string) {
        this._connName = string;
    }

    public void setType(String string) {
        this._type = string;
    }

    public JList getList() {
        return this._tableList;
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this._connName);
        }
        catch (DBException dBException) {
            this.logger.severe(Messages.getString("DBObjectSearch.0") + dBException.getMessage());
            return null;
        }
    }

    public void clear() {
        this._model.clear();
    }

    public void init() {
        this.removeAll();
        this._search = new JTextField();
        this._search.getAccessibleContext().setAccessibleName(ControlsArb.getString("FILTER_ACCESS"));
        this._search.setEditable(true);
        this._search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    DBObjectSearch.this.filter();
                }
            }
        });
        this._go = new JButton();
        this._go.getAccessibleContext().setAccessibleName(ControlsArb.getString("GO_ACCESS"));
        this._go.setText(StringUtils.stripMnemonic((String)Messages.getString("DBObjectSearch.1")));
        this._go.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("DBObjectSearch.1")));
        this._go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBObjectSearch.this.filter();
            }
        });
        this._schemaName = null;
        try {
            this._schemaName = this.getConnection().getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            this.logger.severe(Messages.getString("DBObjectSearch.2") + sQLException.getMessage());
        }
        SQLComboxModel sQLComboxModel = new SQLComboxModel(this.getConnection(), "select username from sys.all_users order by username", null, this._schemaName);
        sQLComboxModel.setDelayed(true);
        this._schema = new JComboBox(sQLComboxModel);
        this._schema.getAccessibleContext().setAccessibleName("SCHEMA_ACCESS");
        this._schema.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        this._schema.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DBObjectSearch.this.filter();
                }
            }
        });
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(false);
        this._tableList.getAccessibleContext().setAccessibleName(ControlsArb.getString("LIST_ACCESS"));
        JScrollPane jScrollPane = new JScrollPane(this._tableList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._schema, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._search, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._go, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void filter() {
        final SearchForObjects searchForObjects = new SearchForObjects(this._connName, this._schemaName, this._search.getText()){};
        searchForObjects.setTypes(this._type);
        searchForObjects.setFilter(this._schema.getSelectedItem() + "." + this._search.getText());
        searchForObjects.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
                ((DefaultListModel)DBObjectSearch.this._tableList.getModel()).clear();
                super.taskRunning(raptorTaskEvent);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    ArrayList arrayList = (ArrayList)searchForObjects.getResult();
                    DefaultListModel<URL> defaultListModel = new DefaultListModel<URL>();
                    for (URL uRL : arrayList) {
                        defaultListModel.addElement(uRL);
                    }
                    DBObjectSearch.this._tableList.setModel(defaultListModel);
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                }
                super.taskFinished(raptorTaskEvent);
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)searchForObjects);
    }

    public JComboBox getJComboBox() {
        return this._schema;
    }
}

