/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartEditorPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.DataPanel;
import oracle.dbtools.raptor.controls.display.chart.GeneralPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.PlotAreaPanel;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.TitlesPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.XAxisPanel;
import oracle.dbtools.raptor.controls.display.chart.Y1AxisPanel;
import oracle.dbtools.raptor.controls.display.chart.Y2AxisPanel;

class PropertyEditorPanel
extends JPanel {
    private ChartEditorPanel chartEditorPanel;
    private GeneralPropertyPanel generalPanel;
    private DataPanel dataPanel;
    private Map<String, AbstractPropertyPanel> subPanelsMap;
    private static final String DATA_PANEL = "DATA_PANEL";
    private static final String TITLES_PANEL = "TITLES_PANEL";
    private static final String PLOT_AREA_PANEL = "PLOT_AREA_PANEL";
    private static final String XAXIS_PANEL = "XAXIS_PANEL";
    private static final String Y1AXIS_PANEL = "Y1AXIS_PANEL";
    private static final String Y2AXIS_PANEL = "Y2AXIS_PANEL";
    private static Map<String, String> subPanelLabels = new HashMap<String, String>();

    PropertyEditorPanel(ChartEditorPanel chartEditorPanel) {
        super(new GridBagLayout());
        this.chartEditorPanel = chartEditorPanel;
        chartEditorPanel.propertyManager().addPropertyListener(new PropertyListener(){

            @Override
            public void onChange(PropertyEvent propertyEvent) {
                if (propertyEvent.changed(PropertyType.TYPE)) {
                    PropertyEditorPanel.this.refreshVisibility();
                }
            }
        });
    }

    List<String> getSubPanels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DATA_PANEL);
        arrayList.add(TITLES_PANEL);
        arrayList.add(PLOT_AREA_PANEL);
        arrayList.add(XAXIS_PANEL);
        arrayList.add(Y1AXIS_PANEL);
        if (this.chartEditorPanel.propertyManager().chartType().isInSet(ChartType.dualYs())) {
            arrayList.add(Y2AXIS_PANEL);
        }
        return arrayList;
    }

    String getSubPanelLabel(String string) {
        return subPanelLabels.get(string);
    }

    void setSelectedSubPanel(String string) {
        if (string == null) {
            this.mapPanel(this.generalPanel());
        } else {
            this.mapPanel(this.subPanelsMap().get(string));
        }
    }

    void clearLiveDataCheck() {
        this.dataPanel.clearLiveDataCheck();
    }

    private void mapPanel(AbstractPropertyPanel abstractPropertyPanel) {
        this.removeAll();
        this.add((Component)abstractPropertyPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    private AbstractPropertyPanel generalPanel() {
        if (this.generalPanel == null) {
            this.generalPanel = new GeneralPropertyPanel(this.chartEditorPanel.propertyManager());
            this.generalPanel.refreshVisibility();
        }
        return this.generalPanel;
    }

    private Map<String, AbstractPropertyPanel> subPanelsMap() {
        if (this.subPanelsMap == null) {
            this.dataPanel = new DataPanel(this.chartEditorPanel);
            this.subPanelsMap = new HashMap<String, AbstractPropertyPanel>();
            this.subPanelsMap.put(DATA_PANEL, this.dataPanel);
            this.subPanelsMap.put(TITLES_PANEL, new TitlesPropertyPanel(this.chartEditorPanel.propertyManager()));
            this.subPanelsMap.put(PLOT_AREA_PANEL, new PlotAreaPanel(this.chartEditorPanel.propertyManager()));
            this.subPanelsMap.put(XAXIS_PANEL, new XAxisPanel(this.chartEditorPanel.propertyManager()));
            this.subPanelsMap.put(Y1AXIS_PANEL, new Y1AxisPanel(this.chartEditorPanel.propertyManager()));
            this.subPanelsMap.put(Y2AXIS_PANEL, new Y2AxisPanel(this.chartEditorPanel.propertyManager()));
            this.refreshVisibility();
        }
        return this.subPanelsMap;
    }

    private void refreshVisibility() {
        this.generalPanel().refreshVisibility();
        for (AbstractPropertyPanel abstractPropertyPanel : this.subPanelsMap().values()) {
            abstractPropertyPanel.refreshVisibility();
        }
    }

    static {
        subPanelLabels.put(DATA_PANEL, ChartArb.getString("DATA_LABEL"));
        subPanelLabels.put(TITLES_PANEL, ChartArb.getString("TITLES_LABEL"));
        subPanelLabels.put(PLOT_AREA_PANEL, ChartArb.getString("PLOT_AREA_LABEL"));
        subPanelLabels.put(XAXIS_PANEL, ChartArb.getString("XAXIS_LABEL"));
        subPanelLabels.put(Y1AXIS_PANEL, ChartArb.getString("Y1AXIS_LABEL"));
        subPanelLabels.put(Y2AXIS_PANEL, ChartArb.getString("Y2AXIS_LABEL"));
    }
}

