/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.EnumProperty;
import oracle.dbtools.raptor.controls.display.chart.FitlineType;
import oracle.dbtools.raptor.controls.display.chart.GraphType;
import oracle.dbtools.raptor.controls.display.chart.LineType;
import oracle.dbtools.raptor.controls.display.chart.LineWidth;
import oracle.dbtools.raptor.controls.display.chart.MarkerShape;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyTableModel;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;

class PropertyTable
extends JTable {
    private static Map<Class, CellObjectFactory> cellObjectMap = new HashMap<Class, CellObjectFactory>();
    private static Map<Class, CellObjectFactory> cellWithDomainObjectMap = new HashMap<Class, CellObjectFactory>();

    PropertyTable(PropertyTableModel propertyTableModel) {
        super(propertyTableModel);
        ChartPropertyManager chartPropertyManager = propertyTableModel.propertyManager();
        PropertyType[] propertyTypeArray = propertyTableModel.columnPropertyTypes();
        PropertyType[] propertyTypeArray2 = propertyTableModel.domainPropertyTypes();
        for (int i = 0; i < propertyTypeArray.length; ++i) {
            CellObjectFactory cellObjectFactory;
            PropertyType propertyType = propertyTypeArray[i];
            Class clazz = chartPropertyManager.primitiveClassOf(propertyType);
            PropertyType propertyType2 = propertyTypeArray2 != null ? propertyTypeArray2[i] : null;
            CellObjectFactory cellObjectFactory2 = cellObjectFactory = propertyType2 == null ? cellObjectMap.get(clazz) : cellWithDomainObjectMap.get(clazz);
            if (cellObjectFactory != null) {
                this.setDefaultRenderer(clazz, cellObjectFactory.renderer(this, chartPropertyManager, propertyType));
                this.setDefaultEditor(clazz, cellObjectFactory.editor(this, chartPropertyManager, propertyType, propertyType2));
                continue;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "missing cell factory for class " + clazz);
        }
    }

    static {
        cellObjectMap.put(Boolean.class, new BooleanCellObjectFactory());
        cellObjectMap.put(String.class, new StringCellObjectFactory());
        cellObjectMap.put(Double.class, new DoubleCellObjectFactory());
        cellObjectMap.put(Color.class, new ColorCellObjectFactory());
        cellObjectMap.put(FitlineType.class, new FitlineTypeCellObjectFactory());
        cellObjectMap.put(LineType.class, new LineTypeCellObjectFactory());
        cellObjectMap.put(LineWidth.class, new LineWidthCellObjectFactory());
        cellObjectMap.put(MarkerShape.class, new MarkerShapeCellObjectFactory());
        cellObjectMap.put(GraphType.class, new GraphTypeCellObjectFactory());
        cellWithDomainObjectMap.put(String.class, new StringWithDomainCellObjectFactory());
    }

    static class ColorPropertyEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Color currentColor;
        private JButton button = new JButton();
        private JColorChooser colorChooser;
        private JDialog dialog;

        public ColorPropertyEditor() {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    button.setBackground(currentColor);
                    colorChooser.setColor(currentColor);
                    dialog.setVisible(true);
                    this.fireEditingStopped();
                }
            });
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, ChartArb.getString("EDIT_COLOR"), true, this.colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    currentColor = colorChooser.getColor();
                }
            }, null);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentColor = (Color)object;
            return this.button;
        }
    }

    static class ColorPropertyRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorPropertyRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.setBackground(color);
            this.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground()));
            return this;
        }
    }

    static class ColorCellObjectFactory
    extends CellObjectFactory {
        ColorCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new ColorPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new ColorPropertyEditor();
        }
    }

    static class EnumPropertyEditor
    extends DefaultCellEditor {
        private ChartPropertyManager propertyManager;
        private PropertyType propertyType;
        private EnumProperty[] values;

        public EnumPropertyEditor(ChartPropertyManager chartPropertyManager, PropertyType propertyType, EnumProperty[] enumPropertyArray) {
            super(new JComboBox());
            this.values = enumPropertyArray;
            this.propertyManager = chartPropertyManager;
            this.propertyType = propertyType;
            JComboBox jComboBox = this.comboBox();
            for (EnumProperty enumProperty : enumPropertyArray) {
                jComboBox.addItem(enumProperty.label());
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            EnumProperty enumProperty = (EnumProperty)this.propertyManager.get(this.propertyType, List.class).get(n);
            this.comboBox().setSelectedItem(enumProperty.label());
            Component component = super.getTableCellEditorComponent(jTable, enumProperty, bl, n, n2);
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            JComboBox jComboBox = this.comboBox();
            return this.values[jComboBox.getSelectedIndex()];
        }

        private JComboBox comboBox() {
            return (JComboBox)this.getComponent();
        }
    }

    static class EnumPropertyRenderer
    extends JLabel
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        EnumPropertyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            EnumProperty enumProperty = (EnumProperty)object;
            this.setText(enumProperty.label().toString());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    static class GraphTypeCellObjectFactory
    extends CellObjectFactory {
        GraphTypeCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new EnumPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new EnumPropertyEditor(chartPropertyManager, propertyType, GraphType.values());
        }
    }

    static class MarkerShapeCellObjectFactory
    extends CellObjectFactory {
        MarkerShapeCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new EnumPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new EnumPropertyEditor(chartPropertyManager, propertyType, MarkerShape.values());
        }
    }

    static class LineWidthCellObjectFactory
    extends CellObjectFactory {
        LineWidthCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new EnumPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new EnumPropertyEditor(chartPropertyManager, propertyType, LineWidth.values());
        }
    }

    static class LineTypeCellObjectFactory
    extends CellObjectFactory {
        LineTypeCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new EnumPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new EnumPropertyEditor(chartPropertyManager, propertyType, LineType.values());
        }
    }

    static class FitlineTypeCellObjectFactory
    extends CellObjectFactory {
        FitlineTypeCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new EnumPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new EnumPropertyEditor(chartPropertyManager, propertyType, FitlineType.values());
        }
    }

    static class DoublePropertyEditor
    extends DefaultCellEditor {
        public DoublePropertyEditor() {
            super(new JFormattedTextField(DoublePropertyEditor.getFormat()));
            JTextField jTextField = (JTextField)this.getComponent();
            jTextField.setHorizontalAlignment(4);
        }

        @Override
        public Object getCellEditorValue() {
            return Double.parseDouble((String)super.getCellEditorValue());
        }

        private static Format getFormat() {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            return numberFormat;
        }
    }

    static class DoublePropertyRenderer
    extends DefaultTableCellRenderer {
        public DoublePropertyRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object object) {
            this.setText(object == null ? "0.0" : Double.toString((Double)object));
        }
    }

    static class DoubleCellObjectFactory
    extends CellObjectFactory {
        DoubleCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new DoublePropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new DoublePropertyEditor();
        }
    }

    static class StringWithDomainPropertyEditor
    extends DefaultCellEditor {
        private ChartPropertyManager propertyManager;
        private PropertyType propertyType;
        private PropertyType domainType;

        public StringWithDomainPropertyEditor(ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            super(new JComboBox());
            this.propertyManager = chartPropertyManager;
            this.propertyType = propertyType;
            this.domainType = propertyType2;
            JComboBox jComboBox = this.comboBox();
            jComboBox.setEditable(true);
            List list = chartPropertyManager.get(propertyType2, List.class);
            for (Object e : list) {
                jComboBox.addItem(e);
            }
            chartPropertyManager.addPropertyListener(new PropertyListener(){

                @Override
                public void onChange(PropertyEvent propertyEvent) {
                    this.stopCellEditing();
                    PropertyType propertyType = domainType;
                    ChartPropertyManager chartPropertyManager = propertyManager;
                    if (propertyEvent.changed(propertyType)) {
                        JComboBox jComboBox = this.comboBox();
                        jComboBox.removeAllItems();
                        List list = chartPropertyManager.get(propertyType, List.class);
                        for (Object e : list) {
                            jComboBox.addItem(e);
                        }
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.comboBox().setSelectedItem(object);
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            JComboBox jComboBox = this.comboBox();
            return jComboBox.getSelectedItem();
        }

        private JComboBox comboBox() {
            return (JComboBox)this.getComponent();
        }
    }

    static class StringWithDomainPropertyRenderer
    extends DefaultTableCellRenderer {
        StringWithDomainPropertyRenderer() {
        }
    }

    static class StringWithDomainCellObjectFactory
    extends CellObjectFactory {
        StringWithDomainCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new StringWithDomainPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new StringWithDomainPropertyEditor(chartPropertyManager, propertyType, propertyType2);
        }
    }

    static class StringPropertyEditor
    extends DefaultCellEditor {
        public StringPropertyEditor() {
            super(new JTextField());
            JTextField jTextField = (JTextField)this.getComponent();
            jTextField.setHorizontalAlignment(2);
        }
    }

    static class StringPropertyRenderer
    extends DefaultTableCellRenderer {
        StringPropertyRenderer() {
        }
    }

    static class StringCellObjectFactory
    extends CellObjectFactory {
        StringCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new StringPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new StringPropertyEditor();
        }
    }

    static class BooleanPropertyEditor
    extends DefaultCellEditor {
        public BooleanPropertyEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    static class BooleanPropertyRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        BooleanPropertyRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    static class BooleanCellObjectFactory
    extends CellObjectFactory {
        BooleanCellObjectFactory() {
        }

        @Override
        TableCellRenderer renderer(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType) {
            return new BooleanPropertyRenderer();
        }

        @Override
        TableCellEditor editor(PropertyTable propertyTable, ChartPropertyManager chartPropertyManager, PropertyType propertyType, PropertyType propertyType2) {
            return new BooleanPropertyEditor();
        }
    }

    static abstract class CellObjectFactory {
        CellObjectFactory() {
        }

        abstract TableCellRenderer renderer(PropertyTable var1, ChartPropertyManager var2, PropertyType var3);

        abstract TableCellEditor editor(PropertyTable var1, ChartPropertyManager var2, PropertyType var3, PropertyType var4);
    }
}

