/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.CellRenderingFactory;
import oracle.dbtools.raptor.controls.cellrenderers.ICellDisplayValue;
import oracle.dbtools.raptor.controls.grid.DefaultResultSetTableCellRenderer;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.query.Column;

public class ResultSetTableCellRenderer
implements TableCellRenderer,
Serializable {
    protected final TableCellRenderer defaultRenderer;

    public ResultSetTableCellRenderer() {
        this(new DefaultResultSetTableCellRenderer());
    }

    protected ResultSetTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.defaultRenderer = tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ResultSetTable resultSetTable = jTable instanceof ResultSetTable ? (ResultSetTable)((Object)jTable) : null;
        ResultSetTableModel resultSetTableModel = resultSetTable != null ? resultSetTable.getGridModel() : null;
        Component component = null;
        Column column = null;
        if (resultSetTableModel != null && (column = resultSetTableModel.getQueryColumn(n, n2)) != null && column.getCellRenderer() != null) {
            try {
                Object obj;
                ClassLoader classLoader = column.getClassLoader();
                Object obj2 = obj = classLoader == null ? Class.forName(column.getCellRenderer()).newInstance() : Class.forName(column.getCellRenderer(), true, classLoader).newInstance();
                if (obj instanceof TableCellRenderer) {
                    component = ((TableCellRenderer)obj).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                } else if (!(obj instanceof ICellDisplayValue)) {
                    RuntimeException runtimeException = new RuntimeException("Must implement a TableCellRenderer or an ICellDisplayValue");
                    Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellRendererComponent", runtimeException);
                    throw runtimeException;
                }
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
            }
        }
        if (component == null) {
            component = CellRenderingFactory.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (component == null) {
            component = this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return component;
    }
}

