/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportSummary;
import oracle.dbtools.raptor.data.readers.IImportFormatOptions;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.IConfig;
import oracle.ide.panels.TraversableContext;

public class ImportDataFormat
extends BaseDataFormat {
    public static final int HEADER_AFTER_SKIP = 0;
    public static final int HEADER_BEFORE_SKIP = 1;
    public static final int METHOD_INSERT_EXEC = 0;
    public static final int METHOD_INSERT_SCRIPT = 1;
    public static final int METHOD_EXTERNAL_TABLE = 2;
    public static final int METHOD_STAGING_EXTERNAL_TABLE = 3;
    public static final int METHOD_SQLLDR = 4;
    public static String METHOD_INSERT_EXEC_NAME = DataImportArb.getString("METHOD_INSERT_EXEC");
    public static String METHOD_INSERT_SCRIPT_NAME = DataImportArb.getString("METHOD_INSERT_SCRIPT");
    public static String METHOD_EXTERNAL_TABLE_NAME = DataImportArb.getString("METHOD_EXTERNAL_TABLE");
    public static String METHOD_STAGING_EXTERNAL_TABLE_NAME = DataImportArb.getString("METHOD_STAGING_EXTERNAL_TABLE");
    public static String METHOD_SQLLDR_NAME = DataImportArb.getString("METHOD_SQLLDR");
    public static String[] NEW_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_EXTERNAL_TABLE_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
    public static String[] EXISTING_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
    private static String[] IMPORT_FORMATS_HSV = new String[]{HSV};
    private static String[] IMPORT_FORMATS_DELIMITED = new String[]{DELIMITED, CSV, TEXT};
    private static String[] IMPORT_FORMATS_EXCEL = new String[]{EXCEL, EXCELX};
    public static String LINE_TERMINATOR = "STANDARD";
    protected static String TRUE = ": true";
    protected static String FALSE = ": false";
    private boolean _usePreviewLimit;
    private int _previewLimit;
    private boolean _useLoadLimit;
    private int _loadLimit;
    private int _skipRows;
    private boolean _useMaxLength;
    private int _maxLength;
    private String _worksheet;
    private int _pageId = 0;

    public ImportDataFormat(int n, String string) {
        super(n, string);
    }

    @Override
    public void setFormat(String string) {
        super.setFormat(string);
        this.initConfigFormatOptions();
    }

    public void setFormat(String string, boolean bl, IConfig iConfig) {
        super.setFormat(string);
        if (bl) {
            this.initConfigFormatOptions(iConfig);
        }
    }

    public void setFormat(String string, IConfig iConfig) {
        super.setFormat(string);
        this.initConfigFormatOptions(iConfig);
    }

    @Override
    public Vector<String> getRecordTerminators() {
        this._recordTerminators = new Vector();
        this._recordTerminators.add(DataToolsArb.getString("STANDARD"));
        this._recordTerminators.add(DataToolsArb.getString("LF"));
        this._recordTerminators.add(DataToolsArb.getString("CRLF"));
        this._recordTerminators.add(DataToolsArb.getString("CR"));
        this._recordTerminators.add(DataToolsArb.getString("TERM_OTHER"));
        if (this._recordTerminators.contains(this._recTerm)) {
            return this._recordTerminators;
        }
        this._recordTerminators.add(this._recTerm);
        return this._recordTerminators;
    }

    public boolean isCompatible(String string) {
        if (this.isDelimited() || this.isCsv() || this.isText()) {
            return string == null || string.equals(BaseDataFormat.DELIMITED) || string.equals(BaseDataFormat.CSV) || string.equals(BaseDataFormat.TEXT);
        }
        return string == null || string.equals(BaseDataFormat.EXCEL) || string.equals(BaseDataFormat.EXCELX);
    }

    public String getWorksneet() {
        return this._worksheet;
    }

    public void setWorksheet(String string) {
        this._worksheet = string;
    }

    public int getPageId() {
        return this._pageId;
    }

    public void setPageId(int n) {
        this._pageId = n;
    }

    public boolean isPreviewLimitSupported() {
        return ((IImportFormatOptions)this._options).isPreviewLimitSupported();
    }

    public boolean getUsePreviewLimit() {
        return this._usePreviewLimit;
    }

    public void setUsePreviewLimit(boolean bl) {
        this._usePreviewLimit = bl;
    }

    public int getPreviewLimit() {
        return this._previewLimit;
    }

    public void setPreviewLimit(int n) {
        this._previewLimit = n;
    }

    public boolean getUseLoadLimit() {
        return this._useLoadLimit;
    }

    public void setUseLoadLimit(boolean bl) {
        this._useLoadLimit = bl;
    }

    public int getLoadLimit() {
        return this._loadLimit;
    }

    public void setLoadLimit(int n) {
        this._loadLimit = n;
    }

    public boolean getUseMaxLength() {
        return this._useMaxLength;
    }

    public void setUseMaxLength(boolean bl) {
        this._useMaxLength = bl;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int n) {
        this._maxLength = n;
    }

    public int getPreviewCharactersLimit() {
        return this._maxLength;
    }

    public void setPreviewCharactersLimit(int n) {
        this._maxLength = n;
    }

    public boolean isHeaderLocationSupported() {
        return ((IImportFormatOptions)this._options).isHeaderLocationSupported();
    }

    public String[] getHeaderLocations() {
        String[] stringArray = new String[]{DataToolsArb.getString("AFTER"), DataToolsArb.getString("BEFORE")};
        return stringArray;
    }

    public int getHeaderLocation() {
        return ((IImportFormatOptions)this._options).getHeaderLocation();
    }

    public boolean isHeaderAfter() {
        return ((IImportFormatOptions)this._options).getHeaderLocation() == 0;
    }

    public void isHeaderAfter(boolean bl) {
        ((IImportFormatOptions)this._options).setHeaderLocation(bl ? 0 : 1);
    }

    public void setHeaderLocation(int n) {
        ((IImportFormatOptions)this._options).setHeaderLocation(n);
    }

    public boolean isSkipSupported() {
        return ((IImportFormatOptions)this._options).isSkipSupported();
    }

    public int getSkipRows() {
        return this._skipRows;
    }

    public void setSkipRows(int n) {
        this._skipRows = n;
    }

    @Override
    public String[] getFormats() {
        if (this.isExcel() || this.isExcelX()) {
            return IMPORT_FORMATS_EXCEL;
        }
        if (this.isHSV()) {
            return IMPORT_FORMATS_HSV;
        }
        return IMPORT_FORMATS_DELIMITED;
    }

    public static int getLoadMethodType(String string) {
        if (string.equals(METHOD_INSERT_EXEC_NAME)) {
            return 0;
        }
        if (string.equals(METHOD_INSERT_SCRIPT_NAME)) {
            return 1;
        }
        if (string.equals(METHOD_EXTERNAL_TABLE_NAME)) {
            return 2;
        }
        if (string.equals(METHOD_STAGING_EXTERNAL_TABLE_NAME)) {
            return 3;
        }
        return 4;
    }

    public static String getLoadMethodName(int n) {
        if (n == 0) {
            return METHOD_INSERT_EXEC_NAME;
        }
        if (n == 1) {
            return METHOD_INSERT_SCRIPT_NAME;
        }
        if (n == 2) {
            return METHOD_EXTERNAL_TABLE_NAME;
        }
        if (n == 3) {
            return METHOD_STAGING_EXTERNAL_TABLE_NAME;
        }
        return METHOD_SQLLDR_NAME;
    }

    public static int getDefaultNewLoadMethod(boolean bl) {
        String[] stringArray;
        int n = DBConfig.getInstance().getInt("IMPORT_NEW_MODE");
        String string = ImportDataFormat.getLoadMethodName(n);
        for (String string2 : stringArray = ImportDataFormat.getNewLoadMethods(bl)) {
            if (!string2.equals(string)) continue;
            return n;
        }
        return 0;
    }

    public static int getDefaultExistingLoadMethod(boolean bl) {
        String[] stringArray;
        int n = DBConfig.getInstance().getInt("IMPORT_EXISTING_MODE");
        String string = ImportDataFormat.getLoadMethodName(n);
        for (String string2 : stringArray = ImportDataFormat.getNewLoadMethods(bl)) {
            if (!string2.equals(string)) continue;
            return n;
        }
        return 0;
    }

    public static String[] getNewLoadMethods(boolean bl) {
        if (bl) {
            return NEW_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    public static String[] getExistingLoadMethods(boolean bl) {
        if (bl) {
            return EXISTING_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    public DefaultMutableTreeNode getFileFormatSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString("FILE_PROPERTIES") + ": " + this.getFormat() + " format");
        if (this.isHeaderOptionSupported()) {
            defaultMutableTreeNode.add(ExtractListModel.getSummaryBooleanItem(ExtractResources.getString("HEADER"), this._header));
        }
        if (this.getSkipRows() > 0) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(DataImportArb.format("SKIP", new Integer(this.getSkipRows()).toString())));
            if (this.isHeaderLocationSupported()) {
                if (this.isHeaderAfter()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(DataImportArb.getString("AFTER_SKIP")));
                } else {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(DataImportArb.getString("BEFORE_SKIP")));
                }
            }
        }
        if (this._options.isDelimiterSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("DELIMITER") + ": " + this._delimiter));
        }
        if (this._options.isEnclosuresSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("ENCLOSURE_LEFT") + ": " + this._enclosureLeft));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("ENCLOSURE_RIGHT") + ": " + this._enclosureRight));
        }
        if (this._options.isLineTerminatorSupported()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("RECORD_TERMINATOR") + ": " + this._recTerm));
        }
        if (this._worksheet != null && this._worksheet.length() > 0) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ExtractResources.getString("WORKSHEET_NAME") + ": " + this._worksheet));
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getImportMethodSummaryNode(ImportProperties importProperties) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        boolean bl;
        DefaultMutableTreeNode defaultMutableTreeNode3;
        boolean bl2 = (Boolean)importProperties.get(ImportKeys.IS_EXISTING_TABLE);
        int n = (Integer)importProperties.get(ImportKeys.LOAD_METHOD);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(DataImportArb.getString("WIZARD_LOAD_METHOD") + ": " + ImportDataFormat.getLoadMethodName(n));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(DataImportArb.getString("METHOD_OPTIONS"));
        boolean bl3 = (Boolean)importProperties.get(ImportKeys.USE_LOAD_LIMIT);
        DefaultMutableTreeNode defaultMutableTreeNode6 = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("LIMIT_ROWS"), bl3);
        defaultMutableTreeNode5.add(defaultMutableTreeNode6);
        if (bl3) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)DataImportArb.getString("WIZARD_LOAD_LIMIT")) + " " + ((Integer)importProperties.get(ImportKeys.LOAD_LIMIT)).toString()));
        }
        if (!bl2) {
            defaultMutableTreeNode5.add(ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET"), (Boolean)importProperties.get(ImportKeys.SEND_TO_WORKSHEET)));
        }
        if (n == 3) {
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode(DataImportArb.getString("STAGING_TABLE_NAME_LABEL") + " " + (String)importProperties.get(ImportKeys.STAGING_TABLE_NAME)));
            defaultMutableTreeNode5.add(ExtractListModel.getSummaryBooleanItem(StringUtils.stripMnemonic((String)DataImportArb.getString("METHOD_DROP_STAGING")), (Boolean)importProperties.get(ImportKeys.DROP_STAGING_TABLE)));
        }
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        if (n == 3 || n == 2) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(DataImportArb.getString("EXTERNAL_TABLE_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("SERVER_SIDE_PATH") + " " + (String)importProperties.get(ImportKeys.DIRPATH)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADIRNAME)));
            bl = (Boolean)importProperties.get(ImportKeys.USELOGFILE);
            defaultMutableTreeNode2 = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("USE_LOG"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            if (bl) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORALOGDIRNAME)));
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEBADFILE);
            defaultMutableTreeNode = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("USE_BAD"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
            if (bl) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORABADDIRNAME)));
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEDISCARDFILE);
            DefaultMutableTreeNode defaultMutableTreeNode7 = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("USE_DISCARD"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode7);
            if (bl) {
                defaultMutableTreeNode7.add(new DefaultMutableTreeNode(DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADISCARDDIRNAME)));
            }
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        } else if (n == 4) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(DataImportArb.getString("SQLLDR_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("LOG_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.LOGDIRNAME)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("BAD_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.BADDIRNAME)));
            bl = (Boolean)importProperties.get(ImportKeys.USEGENDIR) == false;
            defaultMutableTreeNode2 = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("SAVE_IN_IMPORT"), bl);
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(DataImportArb.getString("SAVE_IN_GEN_DIR") + " " + (String)importProperties.get(ImportKeys.GENDIR)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("GENERATED_FILE_NEWLINE") + " " + (String)importProperties.get(ImportKeys.FILEOUTNEWLINE)));
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        }
        if (n == 3 || n == 2 || n == 4) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(DataImportArb.getString("GENERIC_OPTIONS"));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DataImportArb.getString("NUMBER_OF_CHARACTERS") + " " + (String)importProperties.get(ImportKeys.CHARNUMCHARACTERS)));
            String string = (String)importProperties.get(ImportKeys.CHARSETVAL);
            boolean bl4 = string != null && string.length() > 0;
            defaultMutableTreeNode = ExtractListModel.getSummaryBooleanItem(DataImportArb.getString("GEN_FILE_CHARSET"), bl4);
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
            if (bl4) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(DataImportArb.getString("FILE_CHARSET") + ": " + string));
            }
            defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode4;
    }

    public void writeFileFormat(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        ImportSummary.out(printWriter, DataImportArb.getString("FILE_PROPERTIES") + ": " + this.getFormat() + " format", 1);
        if (this.isHeaderOptionSupported()) {
            ImportSummary.out(printWriter, ExtractResources.getString("HEADER") + (this._header ? TRUE : FALSE), 2);
        }
        if (this.getSkipRows() > 0) {
            ImportSummary.out(printWriter, DataImportArb.format("SKIP", new Integer(this.getSkipRows()).toString()), 2);
            if (this.isHeaderLocationSupported()) {
                if (this.isHeaderAfter()) {
                    ImportSummary.out(printWriter, DataImportArb.getString("AFTER_SKIP"), 2);
                } else {
                    ImportSummary.out(printWriter, DataImportArb.getString("BEFORE_SKIP"), 2);
                }
            }
        }
        if (this._options.isDelimiterSupported()) {
            ImportSummary.out(printWriter, ExtractResources.getString("DELIMITER") + ": " + this._delimiter, 2);
        }
        if (this._options.isEnclosuresSupported()) {
            ImportSummary.out(printWriter, ExtractResources.getString("ENCLOSURE_LEFT") + ": " + this._enclosureLeft, 2);
            ImportSummary.out(printWriter, ExtractResources.getString("ENCLOSURE_RIGHT") + ": " + this._enclosureRight, 2);
        }
        if (this._options.isLineTerminatorSupported()) {
            ImportSummary.out(printWriter, ExtractResources.getString("RECORD_TERMINATOR") + ": " + this._recTerm, 2);
        }
        if (this._worksheet != null && this._worksheet.length() > 0) {
            ImportSummary.out(printWriter, ExtractResources.getString("WORKSHEET_NAME") + ": " + this._worksheet, 2);
        }
    }

    public void writeImportMethod(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        boolean bl;
        boolean bl2 = (Boolean)importProperties.get(ImportKeys.IS_EXISTING_TABLE);
        int n = (Integer)importProperties.get(ImportKeys.LOAD_METHOD);
        ImportSummary.out(printWriter, DataImportArb.getString("WIZARD_LOAD_METHOD") + ": " + ImportDataFormat.getLoadMethodName(n), 0);
        ImportSummary.out(printWriter, DataImportArb.getString("METHOD_OPTIONS"), 1);
        boolean bl3 = (Boolean)importProperties.get(ImportKeys.USE_LOAD_LIMIT);
        ImportSummary.out(printWriter, DataImportArb.getString("LIMIT_ROWS") + (bl3 ? TRUE : FALSE), 2);
        if (bl3) {
            ImportSummary.out(printWriter, StringUtils.stripMnemonic((String)DataImportArb.getString("WIZARD_LOAD_LIMIT")) + " " + ((Integer)importProperties.get(ImportKeys.LOAD_LIMIT)).toString(), 2);
        }
        if (!bl2) {
            ImportSummary.out(printWriter, DataImportArb.getString("METHOD_SEND_TO_WORKSHEET") + ((Boolean)importProperties.get(ImportKeys.SEND_TO_WORKSHEET) != false ? TRUE : FALSE), 2);
        }
        if (n == 3) {
            ImportSummary.out(printWriter, DataImportArb.getString("STAGING_TABLE_NAME_LABEL") + " " + (String)importProperties.get(ImportKeys.STAGING_TABLE_NAME), 2);
            ImportSummary.out(printWriter, StringUtils.stripMnemonic((String)DataImportArb.getString("METHOD_DROP_STAGING")) + ((Boolean)importProperties.get(ImportKeys.DROP_STAGING_TABLE) != false ? TRUE : FALSE), 2);
        }
        if (n == 3 || n == 2) {
            ImportSummary.out(printWriter, DataImportArb.getString("EXTERNAL_TABLE_OPTIONS"), 1);
            ImportSummary.out(printWriter, DataImportArb.getString("SERVER_SIDE_PATH") + " " + (String)importProperties.get(ImportKeys.DIRPATH), 2);
            ImportSummary.out(printWriter, DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADIRNAME), 2);
            bl = (Boolean)importProperties.get(ImportKeys.USELOGFILE);
            ImportSummary.out(printWriter, DataImportArb.getString("USE_LOG") + (bl ? TRUE : FALSE), 2);
            if (bl) {
                ImportSummary.out(printWriter, DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORALOGDIRNAME), 3);
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEBADFILE);
            ImportSummary.out(printWriter, DataImportArb.getString("USE_BAD") + (bl ? TRUE : FALSE), 2);
            if (bl) {
                ImportSummary.out(printWriter, DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORABADDIRNAME), 3);
            }
            bl = (Boolean)importProperties.get(ImportKeys.USEDISCARDFILE);
            ImportSummary.out(printWriter, DataImportArb.getString("USE_DISCARD") + (bl ? TRUE : FALSE), 2);
            if (bl) {
                ImportSummary.out(printWriter, DataImportArb.getString("ORACLE_DIRECTORY_NAME") + " " + (String)importProperties.get(ImportKeys.ORADISCARDDIRNAME), 3);
            }
        } else if (n == 4) {
            ImportSummary.out(printWriter, DataImportArb.getString("SQLLDR_OPTIONS"), 1);
            ImportSummary.out(printWriter, DataImportArb.getString("LOG_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.LOGDIRNAME), 2);
            ImportSummary.out(printWriter, DataImportArb.getString("BAD_FILE_DIR") + " " + (String)importProperties.get(ImportKeys.BADDIRNAME), 2);
            bl = (Boolean)importProperties.get(ImportKeys.USEGENDIR) == false;
            ImportSummary.out(printWriter, DataImportArb.getString("SAVE_IN_IMPORT") + (bl ? TRUE : FALSE), 2);
            ImportSummary.out(printWriter, DataImportArb.getString("SAVE_IN_GEN_DIR") + " " + (String)importProperties.get(ImportKeys.GENDIR), 3);
            ImportSummary.out(printWriter, DataImportArb.getString("GENERATED_FILE_NEWLINE") + " " + (String)importProperties.get(ImportKeys.FILEOUTNEWLINE), 2);
        }
        if (n == 3 || n == 2 || n == 4) {
            ImportSummary.out(printWriter, DataImportArb.getString("GENERIC_OPTIONS"), 1);
            ImportSummary.out(printWriter, DataImportArb.getString("NUMBER_OF_CHARACTERS") + " " + (String)importProperties.get(ImportKeys.CHARNUMCHARACTERS), 2);
            String string = (String)importProperties.get(ImportKeys.CHARSETVAL);
            boolean bl4 = string != null && string.length() > 0;
            ImportSummary.out(printWriter, DataImportArb.getString("GEN_FILE_CHARSET") + (bl4 ? TRUE : FALSE), 2);
            if (bl4) {
                ImportSummary.out(printWriter, DataImportArb.getString("FILE_CHARSET") + ": " + string, 3);
            }
        }
    }

    @Override
    protected void initFormat() {
        this.initConfigOptions(DBConfig.getInstance());
    }

    @Override
    protected void initConfigOptions(IConfig iConfig) {
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            this._encoding = iConfig.getString("IMP_ENCODING");
            Boolean bl = iConfig.getBoolean("IMPORT_USE_PREVIEW_LIMIT");
            this._usePreviewLimit = bl;
            this._previewLimit = iConfig.getInt("IMPORT_PREVIEW_LIMIT");
            bl = iConfig.getBoolean("IMPORT_USE_LOAD_LIMIT");
            this._useLoadLimit = bl;
            this._loadLimit = iConfig.getInt("IMPORT_LOAD_LIMIT");
            this._maxLength = iConfig.getInt("IMPORT_MAX_LENGTH");
            bl = iConfig.getBoolean("IMPORT_USE_MAX_LENGTH");
            this._useMaxLength = bl;
        }
        super.initConfigOptions(iConfig);
    }

    protected void initConfigFormatOptions() {
        super.initConfigOptions(DBConfig.getInstance());
    }

    protected void initConfigFormatOptions(IConfig iConfig) {
        super.initConfigOptions(iConfig);
    }

    @Override
    public void saveBasicPreferences(TraversableContext traversableContext) {
    }

    @Override
    public void saveFormatPreferences(TraversableContext traversableContext) {
        this.saveFormatPreferences(DBConfig.getInstance(traversableContext));
    }

    @Override
    public void saveFormatPreferences(IConfig iConfig) {
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            iConfig.putString("IMP_ENCODING", this._encoding);
            iConfig.putBoolean("IMPORT_USE_PREVIEW_LIMIT", this._usePreviewLimit);
            iConfig.putInt("IMPORT_PREVIEW_LIMIT", this._previewLimit);
            iConfig.putBoolean("IMPORT_USE_LOAD_LIMIT", this._useLoadLimit);
            iConfig.putInt("IMPORT_LOAD_LIMIT", this._loadLimit);
            iConfig.putInt("IMPORT_MAX_LENGTH", this._maxLength);
            iConfig.putBoolean("IMPORT_USE_MAX_LENGTH", this._useMaxLength);
        }
        super.saveFormatPreferences(iConfig);
    }
}

