/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ImportBadFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportBadFilePanel;
import oracle.dbtools.raptor.data.ui.ImportDiscardFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportGenFilesPanel;
import oracle.dbtools.raptor.data.ui.ImportLogFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportLogFilePanel;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.gss.util.NLSLocale;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class ExternalOptions
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext m_ctx;
    BasicEditorPane m_summaryPanel = null;
    private ImportDataFormat m_dataFormat;
    private JLabel m_pathLabel;
    private JTextField m_pathValue;
    private JLabel m_directoryLabel;
    private JComboBox m_directoryValue;
    private String m_myDir = null;
    private JComboBox m_outputComboBox;
    private String[] _recordTerminators;
    private JTextField m_numChars;
    private JCheckBox m_charsetCheckBox;
    private JLabel m_charsetLabel;
    private JComboBox m_charsetComboBox;
    private ButtonGroup m_genDirsGroup;
    private JLabel m_genDirsLabel;
    private JRadioButton m_saveInInputDirRadio;
    private JRadioButton m_saveInGenDirRadio;
    private ImportBadFilePanel m_importBadFilePanel;
    private ImportLogFilePanel m_importLogFilePanel;
    private ImportGenFilesPanel m_importGenFilesPanel;
    private ImportBadFileOraPanel m_importBadFileOraPanel;
    private ImportLogFileOraPanel m_importLogFileOraPanel;
    private ImportDiscardFileOraPanel m_importDiscardFileOraPanel;
    Vector<String> m_dirList;
    private int _loadMethod;
    private String m_inputFileDir;
    private LoadFile m_file;
    private ImportProperties _iProps;
    private boolean _init = false;

    public void onEntry(TraversableContext traversableContext) {
        String string;
        String string2;
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        this._loadMethod = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        DBConfig dBConfig = DBConfig.getInstance();
        String string3 = dBConfig.getString("IMPORT_ORA_DIR");
        String string4 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
        if (!((Boolean)this._iProps.get(ImportKeys.IS_CONFIGFILE)).booleanValue() || string4 == null || string4.length() < 1) {
            this._iProps.put(ImportKeys.ORADIRNAME, dBConfig.getString("IMPORT_ORA_DIR"));
        }
        this.m_dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        this.m_file = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.build();
        if (this._loadMethod == 2 || this._loadMethod == 3) {
            this.setDefaultPath();
            this.setDefaultDirectory();
            string2 = (String)this.m_directoryValue.getSelectedItem();
            this.m_importLogFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).setSelectedItem(string2);
            }
            this.m_importBadFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).setSelectedItem(string2);
            }
            this.m_importDiscardFileOraPanel.onEntry(this.m_ctx);
            string = (String)((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).getSelectedItem();
            if (string == null || string.length() == 0) {
                ((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).setSelectedItem(string2);
            }
        } else {
            this.m_importLogFilePanel.onEntry(this.m_ctx);
            this.m_importBadFilePanel.onEntry(this.m_ctx);
            this.m_importGenFilesPanel.onEntry(this.m_ctx);
            string2 = (String)this._iProps.get(ImportKeys.FILEOUTNEWLINE);
            if (string2 == null || string2.length() == 0) {
                string2 = BaseDataFormat.getRecordTerminatorFromConfigValue(dBConfig.getString("IMPORT_LDR_GEN_TERM"));
            }
            if (string2 != null && string2.length() > 0) {
                string = string2;
                this.m_outputComboBox.setSelectedItem(string);
            } else {
                string = DataToolsArb.getString("IMPORT_FILE");
                boolean bl = false;
                for (int i = 0; string != null && i < this._recordTerminators.length; ++i) {
                    if (!this._recordTerminators[i].equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.m_outputComboBox.addItem(string);
                }
                this.m_outputComboBox.setSelectedItem(string);
            }
        }
        string2 = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
        if (string2 != null) {
            this.m_numChars.setText(string2);
        } else {
            this.m_numChars.setText("4000");
        }
        string = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (string != null) {
            this.m_charsetComboBox.setSelectedItem(string);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this._loadMethod == 2 || this._loadMethod == 3) {
            this._iProps.put(ImportKeys.DIRPATH, this.m_pathValue.getText());
            this._iProps.put(ImportKeys.ORADIRNAME, (String)this.m_directoryValue.getSelectedItem());
            if (this.m_importBadFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORABADDIRNAME, ((JComboBox)this.m_importBadFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USEBADFILE, true);
            } else {
                this._iProps.put(ImportKeys.USEBADFILE, false);
            }
            if (this.m_importLogFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORALOGDIRNAME, ((JComboBox)this.m_importLogFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USELOGFILE, true);
            } else {
                this._iProps.put(ImportKeys.USELOGFILE, false);
            }
            if (this.m_importDiscardFileOraPanel.isUseFileEnabled()) {
                this._iProps.put(ImportKeys.ORADISCARDDIRNAME, ((JComboBox)this.m_importDiscardFileOraPanel.getDirectoryValue()).getSelectedItem());
                this._iProps.put(ImportKeys.USEDISCARDFILE, true);
            } else {
                this._iProps.put(ImportKeys.USEDISCARDFILE, false);
            }
        } else if (this._loadMethod == 4) {
            String string;
            String string2 = this.m_importBadFilePanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.BADDIRNAME, string2);
            if (string2 != null && string2.trim().length() > 0 && (string = this.validateDirectory(string2, DataImportArb.getString("BAD_FILE_DIR"))) != null) {
                throw new TraversalException(string);
            }
            string2 = this.m_importLogFilePanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.LOGDIRNAME, string2);
            if (string2 != null && string2.trim().length() > 0 && (string = this.validateDirectory(string2, DataImportArb.getString("LOG_FILE_DIR"))) != null) {
                throw new TraversalException(string);
            }
            this._iProps.put(ImportKeys.USEGENDIR, this.m_saveInGenDirRadio.isSelected());
            string = this.m_importGenFilesPanel.getSelectedDirectory();
            this._iProps.put(ImportKeys.GENDIR, string);
            this._iProps.put(ImportKeys.FILEOUTNEWLINE, (String)this.m_outputComboBox.getSelectedItem());
            String string3 = this.validateDirectory(this.m_saveInGenDirRadio.isSelected() ? string : this.m_inputFileDir, DataImportArb.getString("GENERATED_FILES_IN"));
            if (string3 != null) {
                throw new TraversalException(string3);
            }
        }
        this._iProps.put(ImportKeys.CHARNUMCHARACTERS, this.m_numChars.getText());
        if (this.m_charsetCheckBox.isSelected()) {
            this._iProps.put(ImportKeys.CHARSETVAL, this.m_charsetComboBox.getSelectedItem());
        } else {
            this._iProps.put(ImportKeys.CHARSETVAL, "");
        }
    }

    private String validateDirectory(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return DataImportArb.format("NO_DIR", string2);
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return this.canWrite(file);
        }
        if (file.isFile()) {
            return DataImportArb.format("NOT_A_DIR", string, string2);
        }
        boolean bl = MessageDialog.confirm((Component)((Object)this), (Object)DataImportArb.format("CREATE_DIRS", string, string2), (String)DataImportArb.getString("CONFIRM_CREATE_DIR"), null);
        if (!bl) {
            return DataImportArb.format("VALIDATION_FAILED", string, string2);
        }
        if (file != null && file.mkdirs()) {
            return this.canWrite(file);
        }
        return DataImportArb.format("INVALID_DIR", string, string2);
    }

    private String canWrite(File file) {
        return file.canWrite() ? null : DataImportArb.format("NOT_WRITABLE", file.getPath());
    }

    protected void build() {
        if (!this._init) {
            this._init = true;
            this.setLayout(new BorderLayout());
            this.add(this.getMainPanel(), "Center");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected JPanel getMainPanel() {
        void var6_11;
        void var6_10;
        void var6_9;
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        int n2 = 0;
        if (this._loadMethod == 2 || this._loadMethod == 3) {
            n2 = 0;
            jPanel2.setBorder(new TitledBorder(null, DataImportArb.getString("EXTERNAL_TABLE_OPTIONS"), 0, 0, null, null));
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.add((Component)this.getPathLabel(), new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
            jPanel2.add((Component)this.getPathValue(), new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 6, 0), 0, 0));
            this.m_dirList = this.getDirectories();
            jPanel2.add((Component)this.getDirectoryLabel(), new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
            jPanel2.add((Component)this.getDirectoryValue(), new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 8, 6, 0), 0, 0));
            this.m_importLogFileOraPanel = new ImportLogFileOraPanel(true, this.m_dirList);
            jPanel2.add((Component)this.m_importLogFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
            jPanel2.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, n2, 1, 3, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_importBadFileOraPanel = new ImportBadFileOraPanel(true, this.m_dirList);
            jPanel2.add((Component)this.m_importBadFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
            this.m_importDiscardFileOraPanel = new ImportDiscardFileOraPanel(true, this.m_dirList);
            jPanel2.add((Component)this.m_importDiscardFileOraPanel, new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
            jPanel2.add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(16, 0, 16, 0), 0, 0));
        } else {
            jPanel2.setBorder(new TitledBorder(null, DataImportArb.getString("SQLLDR_OPTIONS"), 0, 0, null, null));
            jPanel2.setLayout(new GridBagLayout());
            n2 = 0;
            this.m_importLogFilePanel = new ImportLogFilePanel();
            jPanel2.add((Component)this.m_importLogFilePanel, new GridBagConstraints(0, n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 8), 0, 0));
            this.m_importBadFilePanel = new ImportBadFilePanel();
            jPanel2.add((Component)this.m_importBadFilePanel, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
            jPanel2.add((Component)Box.createHorizontalBox(), new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_genDirsLabel = new JLabel();
            this.m_genDirsGroup = new ButtonGroup();
            this.m_genDirsLabel.setText(DataImportArb.getString("GENERATED_FILES_IN"));
            object2 = this.m_file.getName();
            object = "filename";
            try {
                object = new File((String)object2).getCanonicalPath();
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            this.m_inputFileDir = ((String)object).substring(0, ((String)object).lastIndexOf(File.separator));
            this.m_saveInInputDirRadio = new JRadioButton();
            this.m_saveInInputDirRadio.setText(DataImportArb.format("SAVE_IN_INPUT_DIR", this.m_inputFileDir));
            this.m_saveInInputDirRadio.setToolTipText(DataImportArb.getString("SAVE_IN_INPUT_DIR_TIP"));
            this.m_saveInInputDirRadio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExternalOptions.this.m_importGenFilesPanel.setEnabled(!ExternalOptions.this.m_saveInInputDirRadio.isSelected());
                }
            });
            this.m_genDirsGroup.add(this.m_saveInInputDirRadio);
            this.m_saveInGenDirRadio = new JRadioButton();
            this.m_saveInGenDirRadio.setText(DataImportArb.getString("SAVE_IN_GEN_DIR"));
            this.m_saveInGenDirRadio.setToolTipText(DataImportArb.getString("SAVE_IN_GEN_DIR_TIP"));
            this.m_saveInGenDirRadio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExternalOptions.this.m_importGenFilesPanel.setEnabled(ExternalOptions.this.m_saveInGenDirRadio.isSelected());
                }
            });
            this.m_genDirsGroup.add(this.m_saveInGenDirRadio);
            this.m_importGenFilesPanel = new ImportGenFilesPanel();
            boolean n = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
            String string = (String)this._iProps.get(ImportKeys.GENDIR);
            if (n) {
                this.m_saveInGenDirRadio.setSelected(true);
                this.m_importGenFilesPanel.setCurrentDirectory(string);
            } else {
                this.m_saveInInputDirRadio.setSelected(true);
            }
            this.m_importGenFilesPanel.setEnabled(this.m_saveInGenDirRadio.isSelected());
            jPanel2.add((Component)this.m_genDirsLabel, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 8), 0, 0));
            jPanel2.add((Component)this.m_saveInInputDirRadio, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
            jPanel2.add((Component)this.m_saveInGenDirRadio, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
            jPanel2.add((Component)this.m_importGenFilesPanel, new GridBagConstraints(1, n2, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 8), 0, 0));
            jPanel2.add((Component)new JLabel(DataImportArb.getString("GENERATED_FILE_NEWLINE")), new GridBagConstraints(0, ++n2, 2, 1, 0.0, 0.0, 17, 1, new Insets(16, 0, 0, 8), 0, 0));
            jPanel2.add(this.getOutputNewline(), new GridBagConstraints(2, n2, 1, 1, 0.0, 0.0, 17, 1, new Insets(16, 0, 6, 8), 0, 0));
        }
        object2 = new JPanel();
        object = new GridBagLayout();
        int n = 0;
        ((JComponent)object2).setBorder(new TitledBorder(null, DataImportArb.getString("GENERIC_OPTIONS"), 0, 0, null, null));
        ((Container)object2).setLayout((LayoutManager)object);
        ((Container)object2).add((Component)new JLabel(DataImportArb.getString("NUMBER_OF_CHARACTERS")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 0, 0), 0, 0));
        ((Container)object2).add(this.getNumChars(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 6, 0), 0, 0));
        ((Container)object2).add(this.getCharsetCheckBox(), new GridBagConstraints(0, (int)(++var6_9), 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 8, 6, 0), 0, 0));
        this.m_charsetLabel = new JLabel(DataImportArb.getString("FILE_CHARSET"));
        ((Container)object2).add((Component)this.m_charsetLabel, new GridBagConstraints(0, (int)(++var6_10), 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 26, 0, 0), 0, 0));
        ((Container)object2).add(this.getCharsetComboBox(), new GridBagConstraints(1, (int)var6_10, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 16, 6, 0), 0, 0));
        this.m_charsetCheckBox.setSelected(false);
        this.m_charsetComboBox.setEnabled(false);
        this.m_charsetLabel.setEnabled(false);
        ((Container)object2).add((Component)Box.createHorizontalBox(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)object2).add((Component)Box.createVerticalBox(), new GridBagConstraints(0, (int)(++var6_11), 1, 0, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)object2, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void setDefaultPath() {
        String string = (String)this._iProps.get(ImportKeys.DIRPATH);
        String string2 = null;
        String string3 = null;
        string3 = string != null ? string : ((string2 = this.m_file.getCanonicalName()) != null && string2.indexOf(File.separator) != -1 ? string2.substring(0, string2.lastIndexOf(File.separator)) : "unknown");
        this.m_pathValue.setText(string3);
        this.m_myDir = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setDefaultDirectory() {
        String string = (String)this._iProps.get(ImportKeys.ORADIRNAME);
        String string2 = DataImportArb.getString("ENTERNEWDIR");
        if (string != null) {
            string2 = string;
        } else {
            DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
            boolean bl = false;
            String string3 = this.m_myDir.toLowerCase();
            if (this.m_myDir.toLowerCase().matches("^[a-z]:.*")) {
                bl = true;
                string3 = string3.replaceFirst("^([a-z]:)([^\\\\])", "$1\\\\$2");
            }
            ResultSet resultSet = null;
            if (Connections.getInstance().lock(dBObject.getConnectionName())) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                    resultSet = dBUtil.executeQuery("select DIRECTORY_NAME,DIRECTORY_PATH  from all_directories", Collections.EMPTY_MAP);
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        String string5 = resultSet.getString(2);
                        if (string5 == null) continue;
                        if (bl) {
                            if (!string5.toLowerCase().replaceFirst("^([a-z]:)([^\\\\])", "$1\\\\$2").equals(string3)) continue;
                            string2 = string4;
                            break;
                        }
                        if (!string5.equals(this.m_myDir)) continue;
                        string2 = string4;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(dBObject.getConnectionName());
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(dBObject.getConnectionName());
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
            }
        }
        this.m_directoryValue.setSelectedItem(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector<String> getDirectories() {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        DBObject dBObject = (DBObject)this._iProps.get(ImportKeys.DBOBJECT);
        if (Connections.getInstance().lock(dBObject.getConnectionName())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                resultSet = dBUtil.executeQuery("select DIRECTORY_NAME from all_directories", Collections.EMPTY_MAP);
                while (resultSet.next()) {
                    vector.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(dBObject.getConnectionName());
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(dBObject.getConnectionName());
        }
        return vector;
    }

    protected Component getOutputNewline() {
        if (this.m_outputComboBox == null) {
            this._recordTerminators = new String[]{DataToolsArb.getString("PLATFORM_DEFAULT"), DataToolsArb.getString("ENV_DEFAULT"), DataToolsArb.getString("IMPORT_FILE"), DataToolsArb.getString("LF"), DataToolsArb.getString("CRLF"), DataToolsArb.getString("CR")};
            this.m_outputComboBox = new JComboBox<String>(this._recordTerminators);
        }
        return this.m_outputComboBox;
    }

    protected Component getNumChars() {
        if (this.m_numChars == null) {
            this.m_numChars = new JTextField("4000", 4);
        }
        return this.m_numChars;
    }

    protected Component getCharsetCheckBox() {
        this.m_charsetCheckBox = new JCheckBox();
        this.m_charsetCheckBox.setSelected(true);
        this.m_charsetCheckBox.setText(DataImportArb.getString("GEN_FILE_CHARSET"));
        this.m_charsetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ExternalOptions.this.m_charsetComboBox.setEnabled(jCheckBox.isSelected());
                ExternalOptions.this.m_charsetLabel.setEnabled(jCheckBox.isSelected());
            }
        });
        return this.m_charsetCheckBox;
    }

    protected Component getCharsetComboBox() {
        if (this.m_charsetComboBox == null) {
            String string;
            this.m_charsetComboBox = new JComboBox();
            this.m_charsetComboBox.addItem("");
            NLSLocale nLSLocale = NLSLocale.getInstance();
            Enumeration enumeration = nLSLocale.enumNLSCharsets();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                if (!ExternalOptions.validCharSet(string)) continue;
                if (this.m_charsetComboBox.getItemCount() == 0) {
                    this.m_charsetComboBox.addItem(string);
                    continue;
                }
                boolean bl = false;
                for (int i = 0; i < this.m_charsetComboBox.getItemCount(); ++i) {
                    if (string.compareTo(this.m_charsetComboBox.getItemAt(i).toString()) < 0) {
                        this.m_charsetComboBox.insertItemAt(string, i);
                        bl = true;
                        break;
                    }
                    if (string.compareTo(this.m_charsetComboBox.getItemAt(i).toString()) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.m_charsetComboBox.addItem(string);
            }
            string = this.m_dataFormat == null ? "UTF8" : NLSLocale.getInstance().getNLSCharset(this.m_dataFormat.getEncoding());
            this.m_charsetComboBox.setSelectedItem(string);
            this.m_charsetComboBox.setEditable(true);
        }
        return this.m_charsetComboBox;
    }

    private static boolean validCharSet(String string) {
        return !string.equals("AL16UTF16LE") && !string.equals("ISO2022-CN") && !string.equals("ISO2022-JP") && !string.equals("ISO2022-KR") && !string.equals("HZ-GB-2312");
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        ExternalOptions externalOptions = new ExternalOptions();
        jDialog.add((Component)((Object)externalOptions));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected JLabel getPathLabel() {
        if (this.m_pathLabel == null) {
            this.m_pathLabel = new JLabel();
            this.m_pathLabel.setText(DataImportArb.getString("SERVER_SIDE_PATH"));
        }
        return this.m_pathLabel;
    }

    protected JTextField getPathValue() {
        if (this.m_pathValue == null) {
            this.m_pathValue = new JTextField();
            this.m_pathValue.setText("");
        }
        return this.m_pathValue;
    }

    protected JLabel getDirectoryLabel() {
        if (this.m_directoryLabel == null) {
            this.m_directoryLabel = new JLabel();
            this.m_directoryLabel.setText(DataImportArb.getString("ORACLE_DIRECTORY_NAME"));
        }
        return this.m_directoryLabel;
    }

    protected JComboBox getDirectoryValue() {
        if (this.m_directoryValue == null) {
            this.m_directoryValue = new JComboBox<String>(this.m_dirList);
            this.m_directoryValue.setEditable(true);
        }
        return this.m_directoryValue;
    }
}

