/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import org.stringtemplate.v4.ST;

public class ImportGenSqlLoader
extends ImportGen {
    private ImportProperties _iProps;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private String _outStub;
    private String _outWithPath;
    private String _pathStringSh;
    private String _pathStringBat;
    private String _pathStringCtl;
    Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGenSqlLoader(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        return this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExitCode generate() {
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        if (!this.isExistingTable()) {
            stringBuffer.append(this.getCreateTableStatementWithComments());
        }
        this.doLoaderFiles();
        stringBuffer.append(DataImportArb.format("GEN_FILES_LOCATION", this._outWithPath));
        String string = stringBuffer.toString();
        string.replaceAll("\r", "");
        this.getStream().println(string);
        if (!this.isBatch() && this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET).booleanValue()) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.77"));
            if (this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN) != null) {
                try {
                    ImportGenSqlLoader.openSqlNodeForURL((URL)this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        } else {
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            try {
                Closeable closeable = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream((PipedInputStream)closeable);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                MessagePage messagePage = (MessagePage)LogManager.getLogManager().getMsgPage();
                if (messagePage == null) {
                    messagePage = new MessagePage();
                    LogManager.getLogManager().addPage((LogPage)messagePage);
                }
                OutputRedirector outputRedirector = new OutputRedirector((PipedInputStream)closeable, (LogPage)messagePage);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.78") + this.getTableName() + Messages.getString("ImportGenerator.79") + this.getConnName());
                ScriptExecutor scriptExecutor = new ScriptExecutor(stringBuffer.toString(), this.getConn());
                scriptRunnerContext.setErrWriter(new PrintWriter(this.getStream().getBadStreamWriter()));
                scriptRunnerContext.setOutputStreamWrapper(bufferedOutputStream);
                scriptRunnerContext.setEscape(false);
                scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                scriptExecutor.setOut(bufferedOutputStream);
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.84"));
                scriptExecutor.run();
                outputRedirector.start();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                LogManager.getLogManager().getLogWindow().activate();
                PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (!this.isBatch() && this.getStream().isBadFileUsed()) {
                    try {
                        ImportGenSqlLoader.openSqlNodeForURL(this.getStream().geturlBad());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                } else {
                    this.getStream().deleteEmptyBadFile();
                }
                this.getPostProcessCallback().run();
            }
        }
        this.getStream().finished();
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode validate() {
        CharSequence charSequence;
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        String string = this._loadFile.getName();
        String string2 = this._loadFile.getCanonicalName();
        this._outStub = string2.substring(string2.lastIndexOf(File.separator) + 1, string2.lastIndexOf("."));
        boolean bl = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
        this._outWithPath = string2.substring(0, string2.lastIndexOf(File.separator));
        if (bl) {
            charSequence = (String)this._iProps.get(ImportKeys.GENDIR);
            if (this._outWithPath.endsWith(File.separator)) {
                this._outWithPath = ((String)charSequence).substring(0, this._outWithPath.length() - 2);
            }
            this._outWithPath = charSequence;
        }
        this._pathStringSh = this._outWithPath + File.separator + this._outStub + ".sh";
        this._pathStringBat = this._outWithPath + File.separator + this._outStub + ".bat";
        this._pathStringCtl = this._outWithPath + File.separator + this._outStub + ".ctl";
        charSequence = new StringBuffer();
        if (!this.isFileWritable(this._pathStringSh)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringSh));
        }
        if (!this.isFileWritable(this._pathStringBat)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringBat));
        }
        if (!this.isFileWritable(this._pathStringCtl)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringCtl));
        }
        if (((StringBuffer)charSequence).length() > 0) {
            exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(((StringBuffer)charSequence).toString());
        } else {
            this._isValid = true;
        }
        return exitCode;
    }

    private void doLoaderFiles() {
        String string;
        Object object2;
        String string2;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.13"));
        ST sT = this.getTemplateGroup().getInstanceOf("CreateSqlldrStatement");
        sT.add("fileName", (Object)this._outStub);
        String string3 = (String)this._iProps.get(ImportKeys.LOGDIRNAME);
        String string4 = "";
        if (string3 != null && string3.length() > 0) {
            string4 = "LOG=" + string3 + File.separator + this._outStub + ".log";
        }
        sT.add("logClause", (Object)string4);
        String string5 = (String)this._iProps.get(ImportKeys.BADDIRNAME);
        String string6 = "";
        if (string5 != null && string5.length() > 0) {
            string6 = "BAD=" + string5 + File.separator + this._outStub + ".bad";
        }
        sT.add("badClause", (Object)string6);
        Integer n = this.getDataFormat().isHeader() ? this.getDataFormat().getSkipRows() + 1 : this.getDataFormat().getSkipRows();
        sT.add("rowsToSkip", (Object)n.toString());
        n = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n > 0) {
            string2 = "LOAD=" + n;
            sT.add("loadLimitClause", (Object)string2);
        }
        string2 = sT.render();
        File file = new File(this._pathStringSh);
        String string7 = string2;
        this.writeOutFile(file, this.nix(string7));
        File file2 = new File(this._pathStringBat);
        string7 = string2;
        this.writeOutFile(file2, this.dos(string7));
        sT = this.getTemplateGroup().getInstanceOf("CreateSqlldrCtlFile");
        sT.add("tableName", (Object)this.addUser(this.addDoubleQuote(this.getTableName())));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : this.getGenTable().getColumns()) {
            if (object2.getType().equalsIgnoreCase("DATE")) {
                if (object2.getFormat() == null) {
                    arrayList.add(this.addDoubleQuote(object2.getName()) + " DATE");
                    continue;
                }
                arrayList.add(this.addDoubleQuote(object2.getName()) + " DATE \"" + object2.getFormat() + "\"");
                continue;
            }
            if (object2.getType().equalsIgnoreCase("TIMESTAMP")) {
                if (object2.getFormat() == null) {
                    arrayList.add(this.addDoubleQuote(object2.getName()) + " TIMESTAMP");
                    continue;
                }
                arrayList.add(this.addDoubleQuote(object2.getName()) + " TIMESTAMP \"" + object2.getFormat() + "\"");
                continue;
            }
            string = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
            if (string != null && string != "" && string.replaceAll("[0-9]*", "").equals("")) {
                arrayList.add(this.addDoubleQuote(object2.getName()) + " CHAR(" + string + ")");
                continue;
            }
            arrayList.add(this.addDoubleQuote(object2.getName()) + " CHAR(4000)");
        }
        sT.add("nameList", (Object)arrayList.toArray());
        boolean bl = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
        if (bl) {
            sT.add("fileName", (Object)this._loadFile.getCanonicalName());
        } else {
            sT.add("fileName", (Object)this._loadFile.getCanonicalName().substring(this._loadFile.getCanonicalName().lastIndexOf(File.separator) + 1));
        }
        String string8 = BaseDataFormat.singleQuote(BaseDataFormat.getRecordTerminatorString(this.getDataFormat().getRecordTerminator()));
        sT.add("endOfRow", (Object)string8);
        String string9 = this.getDataFormat().getEnclosureLeftValue();
        object2 = this.getDataFormat().getEnclosureRightValue();
        string = "";
        if (string9.length() != 0) {
            string = "OPTIONALLY ENCLOSED BY '" + string9 + "' AND '" + (String)object2 + "'";
        }
        sT.add("enclosures", (Object)string);
        String string10 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (!string10.equals("")) {
            string10 = "CHARACTERSET " + string10;
        }
        sT.add("charset", (Object)string10);
        String string11 = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(this.getDataFormat().getDelimiter()));
        if (string11 == null || string11.equals("")) {
            string11 = "','";
        } else if (string11.equals("'WHITESPACE'")) {
            string11 = "WHITESPACE";
        }
        sT.add("fieldDelimiter", (Object)string11);
        String string12 = sT.render();
        File file3 = new File(this._pathStringCtl);
        this.writeOutFile(file3, this.translateEOL(string12 + "\n"));
    }
}

