/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.headless;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.raptor.headless.HeadlessCore;

public class LogHandler
extends Handler {
    File _logFile;
    private OutputStream _fout;
    private BufferedOutputStream _bout;
    protected Writer _logWriter;
    private long _lastMills = 0L;
    private static LogHandler INSTANCE;
    private static final Object INSTANCE_LOCK;
    private static final Logger BASE_LOGGER;
    private static final Formatter FORMATTER;

    private LogHandler() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        logger.addHandler(this);
    }

    public boolean setLogFile(String string, HeadlessCore headlessCore) {
        try {
            if (string.equalsIgnoreCase("STDERR")) {
                this._logWriter = headlessCore.getErrorWriter();
            } else {
                this._logFile = new File(string);
                this._fout = new FileOutputStream(this._logFile.getPath());
                this._bout = new BufferedOutputStream(this._fout);
                this._logWriter = new OutputStreamWriter(this._bout);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogHandler getInstance() {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LogHandler();
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void close() throws SecurityException {
        if (this._logWriter != null) {
            try {
                this._logWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        if (this._logWriter != null) {
            try {
                this._logWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        assert (logRecord != null);
        if (BASE_LOGGER.isLoggable(logRecord.getLevel()) && this._logWriter != null) {
            try {
                this.logMsg(logRecord);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void logMsg(Object object) {
        if (object instanceof LogRecord) {
            LogRecord logRecord = (LogRecord)object;
            Object[] objectArray = new Object[5];
            objectArray[0] = logRecord.getLevel() + "";
            objectArray[1] = logRecord.getSequenceNumber();
            objectArray[2] = this._lastMills == 0L ? 0L : logRecord.getMillis() - this._lastMills;
            String string = logRecord.getSourceClassName();
            if (null == string || string.isEmpty()) {
                string = logRecord.getLoggerName();
            }
            if (string.startsWith("oracle.dbtools")) {
                objectArray[3] = string;
                objectArray[4] = FORMATTER.format(logRecord);
                this._lastMills = logRecord.getMillis();
                try {
                    this._logWriter.write((String)objectArray[0] + ": " + (String)objectArray[4] + "\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static {
        INSTANCE_LOCK = new Object();
        BASE_LOGGER = Logger.getLogger("oracle.dbtools");
        FORMATTER = new Formatter(){

            @Override
            public String format(LogRecord logRecord) {
                Throwable throwable;
                String string = this.formatMessage(logRecord);
                if ((null == string || string.isEmpty() || "null".equals(string)) && (throwable = logRecord.getThrown()) != null) {
                    string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
                }
                return string;
            }
        };
    }
}

