/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;
import javafx.util.Pair;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.console.AttributeRow;
import oracle.dbtools.raptor.metrics.console.ConsoleModel;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.ElementEditor;
import oracle.dbtools.raptor.metrics.console.MetaAttribute;
import oracle.dbtools.raptor.metrics.console.ModelElement;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.engine.DXService;

public class ConsolePane
extends StackPane {
    private final SplitPane splitPane = new SplitPane();
    private final Label notRunningLabel = new Label(MetricsResources.getString("METRICS_CONSOLE_NOTHING_RUNNING"));
    private final TreeView<Element<?>> tree;
    private final SplitPane detailView;
    private final TableView<Pair<ObservableStringValue, ObservableStringValue>> attributeView;
    private final TableView<AttributeRow> childAttributeView;
    private final Pane emptyDetailView;
    private TreeItem<Element<?>> selectedItem;

    public ConsolePane(ConsoleModel consoleModel) {
        this.notRunningLabel.setStyle("-fx-background-color:GAINSBORO");
        this.notRunningLabel.setAlignment(Pos.CENTER);
        this.notRunningLabel.setMaxWidth(Double.MAX_VALUE);
        this.notRunningLabel.setMaxHeight(Double.MAX_VALUE);
        this.getChildren().setAll((Object[])new Node[]{this.splitPane, this.notRunningLabel});
        this.tree = new TreeView();
        this.setTreeCellFactory();
        this.setSelectedItemListener();
        ModelElement modelElement = new ModelElement(consoleModel){

            @Override
            void beforeAddChildItem() {
                if (this.getTreeItem().getChildren().isEmpty()) {
                    ConsolePane.this.notRunningLabel.setVisible(false);
                }
            }

            @Override
            void afterRemoveChildItem() {
                if (this.getTreeItem().getChildren().isEmpty()) {
                    ConsolePane.this.notRunningLabel.setVisible(true);
                }
            }
        };
        modelElement.setAsRoot(this.tree);
        this.emptyDetailView = new Pane();
        this.detailView = new SplitPane();
        this.detailView.setOrientation(Orientation.VERTICAL);
        this.detailView.setDividerPositions(new double[]{0.3});
        this.attributeView = new TableView();
        this.childAttributeView = new TableView();
        this.detailView.getItems().setAll((Object[])new Node[]{this.attributeView, this.childAttributeView});
        this.splitPane.setDividerPositions(new double[]{0.1});
        this.splitPane.getItems().setAll((Object[])new Node[]{this.tree, this.emptyDetailView});
        consoleModel.getObjectMap().addListener(change -> {
            if (change.wasRemoved()) {
                this.onRemoveObjectFromTree((ViewObject)change.getValueRemoved());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.MIDDLE && mouseEvent.isAltDown()) {
                DXService.diagnostics(mouseEvent.isControlDown());
            }
        });
    }

    private void setTreeCellFactory() {
        this.tree.setCellFactory(treeView -> new TreeCell<Element<?>>(){
            private final ContextMenu addMenu = new ContextMenu();
            {
                MenuItem menuItem = new MenuItem(MetricsResources.getString("METRICS_CONSOLE_MENU_EDIT"));
                this.addMenu.getItems().add((Object)menuItem);
                menuItem.setOnAction(actionEvent -> ConsolePane.this.onEditElement((Element)this.getTreeItem().getValue()));
            }

            public void updateItem(Element<?> element, boolean bl) {
                super.updateItem(element, bl);
                if (element == null || bl) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(element.toString());
                    this.setGraphic(this.getTreeItem().getGraphic());
                }
                if (element != null) {
                    this.setContextMenu(this.addMenu);
                }
            }
        });
    }

    private void setSelectedItemListener() {
        this.tree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> this.onSelectItem((TreeItem<Element<?>>)treeItem2));
    }

    private void onEditElement(Element<?> element) {
        Window window = this.getScene().getWindow();
        Dialog dialog = new Dialog();
        dialog.initOwner(window);
        dialog.setTitle(MetricsResources.getString("METRICS_CONSOLE_EDIT_DIALOG_TITLE"));
        dialog.setHeaderText(element.toString());
        dialog.setGraphic((Node)element.createIconImage());
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node node = dialog.getDialogPane().lookupButton(ButtonType.OK);
        node.setDisable(true);
        ElementEditor elementEditor = new ElementEditor(element);
        elementEditor.modifiedProperty().addListener((observableValue, bl, bl2) -> node.setDisable(bl2 == false));
        dialog.getDialogPane().setContent((Node)elementEditor);
        dialog.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                elementEditor.applyChanges(window);
            }
        });
    }

    private void onSelectItem(TreeItem<Element<?>> treeItem) {
        if (treeItem != null) {
            Element element = (Element)treeItem.getValue();
            this.populateAttributes(element);
            this.populateChildAttributes(element);
            this.splitPane.getItems().set(1, (Object)this.detailView);
        } else {
            this.splitPane.getItems().set(1, (Object)this.emptyDetailView);
        }
        this.selectedItem = treeItem;
    }

    private void onRemoveObjectFromTree(ViewObject<?> viewObject) {
        if (this.selectedItem != null && viewObject.getPath().equals(((Element)this.selectedItem.getValue()).getPath())) {
            this.tree.getSelectionModel().clearSelection();
        }
    }

    private void populateAttributes(Element<?> element) {
        List<MetaAttribute> list = element.getMetaAttributes();
        ArrayList<TableColumn<Pair<ObservableStringValue, ObservableStringValue>, String>> arrayList = new ArrayList<TableColumn<Pair<ObservableStringValue, ObservableStringValue>, String>>();
        arrayList.add(this.createAttributeTableColumn(MetricsResources.getString("METRICS_CONSOLE_TABLE_HEADER_ATTRIBUTE"), HPos.LEFT, 250, pair -> (ObservableStringValue)pair.getKey()));
        arrayList.add(this.createAttributeTableColumn(MetricsResources.getString("METRICS_CONSOLE_TABLE_HEADER_VALUE"), HPos.CENTER, 250, pair -> (ObservableStringValue)pair.getValue()));
        this.attributeView.getColumns().setAll(arrayList);
        AttributeRow attributeRow = element.getAttributeRow();
        ObservableList observableList = FXCollections.observableArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MetaAttribute metaAttribute = list.get(i);
            StringBinding stringBinding = Bindings.createStringBinding(() -> metaAttribute.getLabel(), (Observable[])new Observable[0]);
            ObservableStringValue observableStringValue = attributeRow.getValues().get(i);
            if (observableStringValue == null) continue;
            Pair pair2 = new Pair((Object)stringBinding, (Object)observableStringValue);
            observableList.add((Object)pair2);
        }
        this.attributeView.setItems(observableList);
    }

    private void populateChildAttributes(Element<?> element) {
        List<MetaAttribute> list = element.getChildMetaAttributes();
        ArrayList<TableColumn<AttributeRow, String>> arrayList = new ArrayList<TableColumn<AttributeRow, String>>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MetaAttribute metaAttribute = list.get(i);
            arrayList.add(this.createChildAttributeTableColumn(i, metaAttribute.getLabel(), metaAttribute.getAlignment(), i == 0 ? 250 : 135));
        }
        this.childAttributeView.getColumns().setAll(arrayList);
        this.childAttributeView.setItems(element.getChildAttributeRows());
    }

    private TableColumn<Pair<ObservableStringValue, ObservableStringValue>, String> createAttributeTableColumn(String string, HPos hPos, int n, Function<Pair<ObservableStringValue, ObservableStringValue>, ObservableStringValue> function) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setMinWidth((double)n);
        tableColumn.setCellValueFactory(cellDataFeatures -> (ObservableStringValue)function.apply((Pair<ObservableStringValue, ObservableStringValue>)cellDataFeatures.getValue()));
        this.setTableColumnAlignment(tableColumn, hPos);
        return tableColumn;
    }

    private TableColumn<AttributeRow, String> createChildAttributeTableColumn(int n, String string, HPos hPos, int n2) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setMinWidth((double)n2);
        tableColumn.setCellValueFactory(cellDataFeatures -> ((AttributeRow)cellDataFeatures.getValue()).getValues().get(n));
        this.setTableColumnAlignment(tableColumn, hPos);
        return tableColumn;
    }

    private void setTableColumnAlignment(TableColumn<?, ?> tableColumn, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                tableColumn.setStyle("-fx-alignment: CENTER-LEFT;");
                break;
            }
            case CENTER: {
                tableColumn.setStyle("-fx-alignment: CENTER;");
                break;
            }
            case RIGHT: {
                tableColumn.setStyle("-fx-alignment: CENTER-RIGHT;");
            }
        }
    }
}

