/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;

class Operations {
    private final Window owner;
    private final List<Supplier<Void>> calls = new ArrayList<Supplier<Void>>();
    private final Map<Supplier<Void>, String> messages = new HashMap<Supplier<Void>, String>();
    private boolean errors;

    Operations(Window window) {
        this.owner = window;
    }

    void addCall(final String string, final String string2, final Consumer<DXOperationCallback> consumer) {
        Supplier<Void> supplier = new Supplier<Void>(){

            @Override
            public Void get() {
                consumer.accept(dXError -> {
                    DXException dXException = dXError.getException();
                    if (dXException == null) {
                        Operations.this.messages.put(this, string);
                    } else {
                        Operations.this.messages.put(this, string2 + "\n" + dXException.getLocalizedMessage());
                        Operations.this.errors = true;
                    }
                    if (Operations.this.messages.size() == Operations.this.calls.size()) {
                        Platform.runLater(() -> Operations.this.showAlert());
                    }
                });
                return null;
            }
        };
        this.calls.add(supplier);
    }

    void callAll() {
        for (Supplier<Void> supplier : this.calls) {
            supplier.get();
        }
    }

    private void showAlert() {
        Alert alert;
        StringBuilder stringBuilder = new StringBuilder();
        for (Supplier<Void> supplier : this.calls) {
            String string = this.messages.get(supplier);
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        if (this.errors) {
            alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.owner);
            alert.setTitle(MetricsResources.getString("METRICS_CONSOLE_UPDATE_WARNING"));
            alert.setHeaderText(MetricsResources.getString("METRICS_CONSOLE_UPDATE_SOME_FAILED"));
        } else {
            alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initOwner(this.owner);
            alert.setTitle(MetricsResources.getString("METRICS_CONSOLE_UPDATE_INFORMATION"));
            alert.setHeaderText(MetricsResources.getString("METRICS_CONSOLE_UPDATE_ALL_SUCCESSFUL"));
        }
        alert.setContentText(stringBuilder.toString());
        alert.showAndWait();
    }
}

