/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.listener.DXAccessCallback;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.support.MetaURLReference;

public class DXService {
    public static void requestSourceKeepAlive(URI uRI, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createRequestSourceKeepAliveCommand(uRI, dXOperationCallback));
    }

    public static void requestJobRun(URI uRI, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createRequestJobRunCommand(uRI, dXOperationCallback));
    }

    public static void useMergeSet(MetaURLReference metaURLReference, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createUseMergeSetCommand(metaURLReference, dXOperationCallback));
    }

    public static void releaseMergeSet(MetaURLReference metaURLReference, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createReleaseMergeSetCommand(metaURLReference, dXOperationCallback));
    }

    public static <T> void getProperty(URI uRI, Class<T> clazz, String string, DXAccessCallback dXAccessCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createGetPropertyCommand(uRI, clazz, string, dXAccessCallback));
    }

    public static <T> void setProperty(URI uRI, Class<T> clazz, String string, T t, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createSetPropertyCommand(uRI, clazz, string, t, dXOperationCallback));
    }

    public static <T> void useDefaultProperty(URI uRI, Class<T> clazz, String string, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createUseDefaultPropertyCommand(uRI, clazz, string, dXOperationCallback));
    }

    public static void invokeOperation(URI uRI, DXOperationCallback dXOperationCallback) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createInvokeOperationCommand(uRI, dXOperationCallback));
    }

    public static void registerListeners(DXListenerList dXListenerList) {
        if (dXListenerList.getListenerCount() > 0) {
            Engine engine = Engine.getInstance();
            engine.enqueueCommand(engine.createRegisterListenersCommand(dXListenerList.getListenerEntries()));
        }
    }

    public static void unregisterListeners(DXListenerList dXListenerList) {
        if (dXListenerList.getListenerCount() > 0) {
            Engine engine = Engine.getInstance();
            engine.enqueueCommand(engine.createUnregisterListenersCommand(dXListenerList.getListenerEntries()));
        }
    }

    public static void diagnostics(boolean bl) {
        Engine engine = Engine.getInstance();
        engine.enqueueCommand(engine.createDiagnosticsCommand(bl));
    }

    private DXService() {
    }
}

