/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.item.TableItemType;
import oracle.dbtools.raptor.metrics.item.TableValue;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;

class TableItemInstance
extends ItemInstance {
    private final TableItemType itemType;
    private Map<DXTableChanges.Key, DXTableChanges.Row> rowMap;
    private DXTableChanges tableChanges;

    TableItemInstance(TableItemType tableItemType, URI uRI) {
        super(uRI);
        this.itemType = tableItemType;
    }

    @Override
    public TableItemType getItemType() {
        return this.itemType;
    }

    @Override
    protected DXTableChanges getChangeObject() {
        ArrayList<DXTableChanges.Row> arrayList = this.rowMap != null ? new ArrayList<DXTableChanges.Row>(this.rowMap.values()) : new ArrayList();
        List<DXTableChanges.Row> list = Collections.emptyList();
        List<DXTableChanges.Key> list2 = Collections.emptyList();
        return new DXTableChanges(arrayList, list, list2);
    }

    @Override
    protected DXTableChanges getIncrementalChangeObject() {
        return this.tableChanges;
    }

    @Override
    protected void update(ValueConverter valueConverter, DataMap dataMap) {
        DataMap dataMap2 = dataMap.getDataMap(this.getItemType().getMapTo());
        if (dataMap2 != null) {
            boolean bl;
            if (this.rowMap == null) {
                this.rowMap = Collections.emptyMap();
                bl = true;
            } else {
                bl = false;
            }
            Map<DXTableChanges.Key, DXTableChanges.Row> map = this.rowMap;
            HashMap<DXTableChanges.Key, DXTableChanges.Row> hashMap = new HashMap<DXTableChanges.Key, DXTableChanges.Row>();
            ArrayList<DXTableChanges.Row> arrayList = new ArrayList<DXTableChanges.Row>();
            ArrayList<DXTableChanges.Row> arrayList2 = new ArrayList<DXTableChanges.Row>();
            ArrayList<DXTableChanges.Key> arrayList3 = new ArrayList<DXTableChanges.Key>();
            List<TableKey> list = this.getRowKeys(valueConverter, dataMap2);
            int n = 0;
            for (TableKey object : list) {
                DXTableChanges.Row row = map.get(object);
                if (row == null) {
                    TableRow tableRow = this.createNewRow(valueConverter, object, dataMap2, n);
                    arrayList.add(tableRow);
                    hashMap.put(object, tableRow);
                    bl = true;
                } else {
                    boolean bl2 = false;
                    for (TableValue tableValue : this.itemType.getTableValues()) {
                        String string = tableValue.getName();
                        List<Object> list2 = dataMap2.getColumnValue(tableValue.getMapTo());
                        Comparable<?> comparable = this.rawToGeneric(tableValue, valueConverter, list2.get(n));
                        if (Objects.equals(row.getCellValue(string, Object.class), comparable)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        TableRow tableRow = this.createNewRow(valueConverter, object, dataMap2, n);
                        arrayList2.add(tableRow);
                        hashMap.put(object, tableRow);
                        bl = true;
                    } else {
                        hashMap.put(object, row);
                    }
                }
                ++n;
            }
            HashSet<TableKey> hashSet = new HashSet<TableKey>(list);
            for (DXTableChanges.Key key : map.keySet()) {
                if (hashSet.contains(key)) continue;
                arrayList3.add(key);
                bl = true;
            }
            if (bl) {
                this.tableChanges = new DXTableChanges(arrayList, arrayList2, arrayList3);
                this.markChanged();
            } else {
                this.tableChanges = null;
            }
            this.rowMap = hashMap;
        } else {
            this.getLogger().log(Level.WARNING, "No data array found for column ''{0}''", new Object[]{this.getItemType().getMapTo()});
        }
    }

    private List<TableKey> getRowKeys(ValueConverter valueConverter, DataMap dataMap) {
        ArrayList<TableKey> arrayList = new ArrayList<TableKey>();
        List<TableValue> list = this.itemType.getKeyValues();
        List<Object> list2 = dataMap.getColumnValue(list.get(0).getMapTo());
        if (list2 == null) {
            this.getLogger().log(Level.WARNING, "No data array found for key column ''{0}''", new Object[]{list.get(0).getMapTo()});
        } else {
            int n = list2.size();
            ArrayList<TableKey> arrayList2 = new ArrayList<TableKey>();
            for (int i = 0; i < n; ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (TableValue tableValue : this.itemType.getKeyValues()) {
                    List<Object> list3 = dataMap.getColumnValue(tableValue.getMapTo());
                    if (list3 != null) {
                        hashMap.put(tableValue.getName(), this.rawToGeneric(tableValue, valueConverter, list3.get(i)));
                        continue;
                    }
                    this.getLogger().log(Level.WARNING, "No data array found for column ''{0}''", new Object[]{tableValue.getMapTo()});
                    arrayList2 = null;
                    break;
                }
                if (arrayList2 == null) break;
                arrayList2.add(new TableKey(this.itemType, hashMap));
            }
            if (arrayList2 != null) {
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    private TableRow createNewRow(ValueConverter valueConverter, TableKey tableKey, DataMap dataMap, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TableValue tableValue : this.itemType.getTableValues()) {
            String string = tableValue.getName();
            List<Object> list = dataMap.getColumnValue(tableValue.getMapTo());
            if (list != null) {
                hashMap.put(string, this.rawToGeneric(tableValue, valueConverter, list.get(n)));
                continue;
            }
            hashMap.put(string, null);
        }
        return new TableRow(tableKey, hashMap);
    }

    private Comparable<?> rawToGeneric(TableValue tableValue, ValueConverter valueConverter, Object object) {
        Object obj;
        try {
            obj = tableValue.getValueType().rawToGeneric(valueConverter, object);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to convert data '" + object + "' for table item '" + this.getPath() + "' column '" + tableValue.getName() + "'", runtimeException);
            obj = null;
        }
        return obj;
    }

    static class TableRow
    implements DXTableChanges.Row {
        private final TableKey rowKey;
        private final Map<String, Object> cellMap;

        TableRow(TableKey tableKey, Map<String, Object> map) {
            this.rowKey = tableKey;
            this.cellMap = map;
        }

        @Override
        public TableKey getRowKey() {
            return this.rowKey;
        }

        @Override
        public Set<String> getCellNames() {
            return this.cellMap.keySet();
        }

        @Override
        public <T> T getCellValue(String string, Class<T> clazz) {
            Object object = this.cellMap.get(string);
            if (object != null) {
                if (clazz.isAssignableFrom(object.getClass())) {
                    return (T)object;
                }
                Logger.getLogger(TableItemInstance.class.getName()).log(Level.WARNING, "Type mismatch for cell ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), object.getClass().getName()});
            }
            return null;
        }
    }

    static class TableKey
    implements DXTableChanges.Key {
        private final TableItemType itemType;
        private final Map<String, Object> cellMap;

        TableKey(TableItemType tableItemType, Map<String, Object> map) {
            this.itemType = tableItemType;
            this.cellMap = map;
        }

        @Override
        public List<String> getKeyCellNames() {
            return this.itemType.getKeyNames();
        }

        @Override
        public <T> T getCellValue(String string, Class<T> clazz) {
            Object object = this.cellMap.get(string);
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            Logger.getLogger(TableItemInstance.class.getName()).log(Level.WARNING, "Type mismatch for cell ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), object.getClass().getName()});
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TableKey)) {
                return false;
            }
            TableKey tableKey = (TableKey)object;
            return tableKey.cellMap.equals(this.cellMap);
        }

        public int hashCode() {
            int n = 7;
            n = 11 * n + Objects.hashCode(this.cellMap);
            return n;
        }

        @Override
        public int compareTo(DXTableChanges.Key key) {
            for (String string : this.itemType.getKeyNames()) {
                Comparable comparable = this.getCellValue(string, Comparable.class);
                Comparable comparable2 = key.getCellValue(string, Comparable.class);
                if (comparable == null) {
                    if (comparable2 == null) continue;
                    return -1;
                }
                if (comparable2 == null) {
                    return 1;
                }
                int n = comparable.compareTo(comparable2);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

