/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractAugmentorObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

public abstract class AbstractChangeIndicatorObject
extends AbstractAugmentorObject {
    private BooleanExpression connectedValue;
    private BooleanExpression availableValue;
    private ChangeListener<Boolean> availableListener;
    private boolean inTransition;
    private FadeTransition fadeTransition;

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return AbstractChangeIndicatorObject.class;
    }

    public ObservableBooleanValue getConnectedValue() {
        return this.connectedValue;
    }

    @Override
    protected void onInit(Context context) {
        this.inTransition = false;
        this.setNonTransitionEffect(context.getContainer(Node.class));
    }

    @Override
    protected void onStart(Context context) {
        List<DataObject> list;
        Node node = context.getContainer(Node.class);
        AbstractMonitorObject abstractMonitorObject = context.getFacet(AbstractMonitorObject.class, (Map<Object, Object>)node.getProperties());
        if (abstractMonitorObject != null && (list = abstractMonitorObject.getDataObjects(context)) != null) {
            for (DataObject dataObject : list) {
                this.availableValue = this.availableValue == null ? dataObject.getAvailable() : this.availableValue.and((ObservableBooleanValue)dataObject.getAvailable());
                if (this.connectedValue == null) {
                    this.connectedValue = dataObject.getConnected();
                    continue;
                }
                this.connectedValue = this.connectedValue.and((ObservableBooleanValue)dataObject.getConnected());
            }
        }
        this.setNonTransitionEffect(context.getContainer(Node.class));
        this.fadeTransition = new FadeTransition(Duration.seconds((double)0.25), node);
        if (this.availableValue != null) {
            if (this.availableValue.getValue().booleanValue()) {
                this.onAvailable(context);
                this.availableValue = null;
            } else {
                this.availableListener = (observableValue, bl, bl2) -> {
                    if (bl2.booleanValue()) {
                        this.onAvailable(context);
                    }
                };
                this.availableValue.addListener(this.availableListener);
            }
        }
        this.fadeTransition.setFromValue(1.0);
        this.fadeTransition.setToValue(0.9);
        this.fadeTransition.setCycleCount(2);
        this.fadeTransition.setAutoReverse(true);
        this.fadeTransition.setOnFinished(actionEvent -> this.onTimeout(context));
    }

    @Override
    protected void onStop(Context context) {
        this.inTransition = false;
        context.getContainer(Node.class).setEffect((Effect)new BoxBlur());
        if (this.availableValue != null && this.availableListener != null) {
            this.availableValue.removeListener(this.availableListener);
        }
        if (this.fadeTransition != null) {
            this.fadeTransition.stop();
        }
        this.availableValue = null;
        this.availableListener = null;
        this.connectedValue = null;
        this.fadeTransition = null;
    }

    protected void playContainerNodeChangeEffect(Context context) {
        if (this.availableValue.get()) {
            this.inTransition = true;
            context.getContainer(Node.class).setEffect((Effect)new MotionBlur(0.0, 10.0));
            this.fadeTransition.play();
        }
    }

    private void onAvailable(Context context) {
        if (this.availableListener != null) {
            this.availableValue.removeListener(this.availableListener);
            this.availableListener = null;
        }
        if (!this.inTransition) {
            this.inTransition = true;
            context.getContainer(Node.class).setEffect((Effect)new BoxBlur());
            this.fadeTransition.play();
        }
    }

    private void setNonTransitionEffect(Node node) {
        BoxBlur boxBlur = null;
        if (this.availableValue == null || !this.availableValue.get()) {
            boxBlur = new BoxBlur();
        }
        node.setEffect((Effect)boxBlur);
    }

    private void onTimeout(Context context) {
        if (this.inTransition) {
            this.inTransition = false;
            this.setNonTransitionEffect(context.getContainer(Node.class));
        }
    }
}

