/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractDecoratorObject;

public class DialogButton
extends AbstractDecoratorObject {
    private final ObjectProperty<Type> typeProperty = new SimpleObjectProperty();
    private final BooleanProperty disableProperty = new SimpleBooleanProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onActionProperty = new SimpleObjectProperty();
    private Button button;

    public Type getType() {
        return (Type)((Object)this.typeProperty.get());
    }

    public void setType(Type type) {
        this.typeProperty.set((Object)type);
    }

    public ObjectProperty<Type> typeProperty() {
        return this.typeProperty;
    }

    public boolean isDisable() {
        return this.disableProperty.get();
    }

    public void setDisable(boolean bl) {
        this.disableProperty.set(bl);
    }

    public BooleanProperty disableProperty() {
        return this.disableProperty;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty.get();
    }

    public void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty.set(eventHandler);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onActionProperty;
    }

    public Button getButton() {
        return this.button;
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return DialogButton.class;
    }

    void onCreateDialog(Dialog<Void> dialog) {
        ButtonType buttonType = this.getType().getButtonType();
        dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
        this.button = (Button)dialog.getDialogPane().lookupButton(buttonType);
        this.button.setDisable(this.isDisable());
        EventHandler<ActionEvent> eventHandler = this.getOnAction();
        if (eventHandler != null) {
            this.button.setOnAction(eventHandler);
        }
    }

    public static enum Type {
        APPLY(ButtonType.APPLY),
        CANCEL(ButtonType.CANCEL),
        CLOSE(ButtonType.CLOSE),
        FINISH(ButtonType.FINISH),
        NO(ButtonType.NO),
        OK(ButtonType.OK),
        YES(ButtonType.YES);

        private final ButtonType buttonType;

        private Type(ButtonType buttonType) {
            this.buttonType = buttonType;
        }

        public ButtonType getButtonType() {
            return this.buttonType;
        }
    }
}

