/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.panel.AbstractTableViewMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;

public class PagedTableViewMonitor
extends AbstractTableViewMonitor {
    private final IntegerProperty pageSizeProperty = new SimpleIntegerProperty((Object)this, "pageSize", 20);
    private final IntegerProperty pageNoProperty = new SimpleIntegerProperty((Object)this, "pageNo", 0);
    private final StringProperty rowNoColumnNameProperty = new SimpleStringProperty((Object)this, "rowNoColumnName", "Row#");
    private final ObservableList<SortOrder> sortOrders = FXCollections.observableArrayList();
    private TableColumn<DXRow, ?> rowNoColumn;

    public int getPageSize() {
        return this.pageSizeProperty.get();
    }

    public void setPageSize(int n) {
        this.pageSizeProperty.set(n);
    }

    public IntegerProperty pageSizeProperty() {
        return this.pageSizeProperty;
    }

    public int getPageNo() {
        return this.pageNoProperty.get();
    }

    public void setPageNo(int n) {
        this.pageNoProperty.set(n);
    }

    public IntegerProperty pageNoProperty() {
        return this.pageNoProperty;
    }

    public String getRowNoColumnName() {
        return (String)this.rowNoColumnNameProperty.get();
    }

    public void setRowNoColumnName(String string) {
        this.rowNoColumnNameProperty.set((Object)string);
    }

    public StringProperty rowNoColumnNameProperty() {
        return this.rowNoColumnNameProperty;
    }

    public ObservableList<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    @Override
    protected void onInit(Context context) {
        TableView tableView = context.getContainer(TableView.class);
        if (tableView != null) {
            for (TableColumn tableColumn : tableView.getColumns()) {
                AbstractCellFactory<TableColumn<DXRow, Object>, TableCell<DXRow, Object>> abstractCellFactory = this.getCellFactory((TableColumn<DXRow, Object>)tableColumn);
                if (abstractCellFactory == null || !this.getRowNoColumnName().equals(abstractCellFactory.getValueColumn())) continue;
                this.rowNoColumn = tableColumn;
                break;
            }
            this.bindTableView(context, (TableView<DXRow>)tableView);
            this.setupTableViewSortingUpdates(context, (TableView<DXRow>)tableView);
        }
    }

    @Override
    protected void onStart(Context context) {
        TableView tableView = context.getContainer(TableView.class);
        if (tableView != null) {
            if (this.sortOrders.isEmpty()) {
                for (TableColumn tableColumn : tableView.getSortOrder()) {
                    this.sortOrders.add((Object)new SortOrder(-1, TableColumn.SortType.DESCENDING));
                    if (tableColumn == this.rowNoColumn || !tableColumn.isSortable()) continue;
                    int n = tableView.getColumns().indexOf((Object)tableColumn);
                    this.sortOrders.add((Object)new SortOrder(n, tableColumn.getSortType()));
                }
            } else {
                tableView.getSortOrder().clear();
                for (SortOrder sortOrder : this.sortOrders) {
                    if (sortOrder.columnIndex < 0) continue;
                    TableColumn tableColumn = (TableColumn)tableView.getColumns().get(sortOrder.columnIndex);
                    tableColumn.setSortType(sortOrder.sortType);
                    tableView.getSortOrder().add((Object)tableColumn);
                }
            }
            this.initializeDynamicItemParameters(this.getItemParameters((TableView<DXRow>)tableView));
            this.setupTableViewSorting((TableView<DXRow>)tableView);
        }
    }

    private Map<String, Object> getItemParameters(TableView<DXRow> tableView) {
        int n = this.getPageNo();
        int n2 = this.getPageSize();
        int n3 = n * n2 + 1;
        int n4 = (n + 1) * n2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (SortOrder sortOrder : this.sortOrders) {
            hashSet.add(sortOrder.columnIndex);
        }
        ArrayList<SortOrder> arrayList = new ArrayList<SortOrder>((Collection<SortOrder>)this.sortOrders);
        for (int i = 0; i < tableView.getColumns().size(); ++i) {
            if (hashSet.contains(i)) continue;
            arrayList.add(new SortOrder(i, TableColumn.SortType.DESCENDING));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getRowNoColumnName();
        boolean bl = true;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            String string2;
            AbstractCellFactory<TableColumn<DXRow, Object>, TableCell<DXRow, Object>> abstractCellFactory;
            SortOrder sortOrder = (SortOrder)object.next();
            if (sortOrder.columnIndex < 0 || (abstractCellFactory = this.getCellFactory((TableColumn<DXRow, Object>)((TableColumn)tableView.getColumns().get(sortOrder.columnIndex)))) == null || (string2 = abstractCellFactory.getValueColumn()).equals(string)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            if (sortOrder.sortType == TableColumn.SortType.ASCENDING) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('-');
            }
            stringBuilder.append(abstractCellFactory.getValueColumn());
        }
        object = new HashMap();
        object.put("minRowNo", n3);
        object.put("maxRowNo", n4);
        object.put("orderBy", stringBuilder);
        return object;
    }

    private void setupTableViewSorting(TableView<DXRow> tableView) {
        SortedList sortedList = new SortedList(this.getItem().getObservable());
        tableView.setItems((ObservableList)sortedList);
        sortedList.comparatorProperty().bind((ObservableValue)tableView.comparatorProperty());
        tableView.getSortOrder().clear();
        for (SortOrder sortOrder : this.sortOrders) {
            if (sortOrder.columnIndex < 0) continue;
            ((TableColumn)tableView.getColumns().get(sortOrder.columnIndex)).setSortType(sortOrder.sortType);
            tableView.getSortOrder().add(tableView.getColumns().get(sortOrder.columnIndex));
        }
        sortedList.comparatorProperty().unbind();
        sortedList.comparatorProperty().set((dXRow, dXRow2) -> {
            long l = (Long)dXRow.get(this.getRowNoColumnName(), Long.class).get();
            long l2 = (Long)dXRow2.get(this.getRowNoColumnName(), Long.class).get();
            return Long.compare(l, l2);
        });
    }

    private void setupTableViewSortingUpdates(Context context, TableView<DXRow> tableView) {
        tableView.applyCss();
        tableView.layout();
        Set set = tableView.lookupAll(".column-header");
        for (Node node : set) {
            int n;
            TableColumnHeader tableColumnHeader;
            TableColumnBase tableColumnBase;
            if (!(node instanceof TableColumnHeader) || (tableColumnBase = (tableColumnHeader = (TableColumnHeader)node).getTableColumn()) == this.rowNoColumn || !tableColumnBase.isSortable() || (n = tableView.getColumns().indexOf((Object)tableColumnBase)) < 0) continue;
            node.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (!mouseEvent.isConsumed()) {
                    this.processHeaderMouseClick(context, n, (MouseEvent)mouseEvent);
                }
            });
        }
    }

    private void processHeaderMouseClick(Context context, int n, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            SortOrder sortOrder = null;
            for (SortOrder sortOrder2 : this.sortOrders) {
                if (n != sortOrder2.columnIndex) continue;
                sortOrder = sortOrder2;
                break;
            }
            if (sortOrder == null) {
                SortOrder sortOrder3 = new SortOrder(n, TableColumn.SortType.DESCENDING);
                if (!mouseEvent.isShiftDown()) {
                    this.sortOrders.clear();
                    this.sortOrders.add((Object)new SortOrder(-1, TableColumn.SortType.ASCENDING));
                }
                this.sortOrders.add((Object)sortOrder3);
            } else {
                int n2 = this.sortOrders.indexOf(sortOrder);
                switch (sortOrder.sortType) {
                    case DESCENDING: {
                        SortOrder sortOrder2;
                        sortOrder2 = new SortOrder(n, TableColumn.SortType.ASCENDING);
                        this.sortOrders.set(n2, (Object)sortOrder2);
                        break;
                    }
                    case ASCENDING: {
                        this.sortOrders.remove(n2);
                    }
                }
            }
            context.requestPanelRestart();
            mouseEvent.consume();
        }
    }

    private void initializeDynamicItemParameters(Map<String, Object> map) {
        ObservableMap<String, Object> observableMap = this.getItem().getQueryParameters();
        for (String string : map.keySet()) {
            observableMap.put((Object)string, (Object)map.get(string).toString());
        }
    }

    public static class SortOrder {
        private final int columnIndex;
        private final TableColumn.SortType sortType;

        public SortOrder(int n, TableColumn.SortType sortType) {
            this.columnIndex = n;
            this.sortType = sortType;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public TableColumn.SortType getSortType() {
            return this.sortType;
        }
    }
}

