/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.StringDataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="item")
public class TextMonitor
extends AbstractMonitorObject {
    private final ObjectProperty<StringDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private InvalidationListener listener;

    @Override
    protected Class<? extends Node> getBindToClass() {
        return Labeled.class;
    }

    public StringDataObject getItem() {
        return (StringDataObject)this.itemProperty.get();
    }

    public void setItem(StringDataObject stringDataObject) {
        this.itemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    @Override
    protected void onInit(Context context) {
        Labeled labeled = context.getContainer(Labeled.class);
        if (labeled != null) {
            StringProperty stringProperty = labeled.textProperty();
            BooleanExpression booleanExpression = this.getItem().getAvailable();
            if (booleanExpression.get()) {
                stringProperty.bind((ObservableValue)this.getItem().getObservable());
            } else {
                if (stringProperty.get() == null || ((String)stringProperty.get()).isEmpty()) {
                    stringProperty.set((Object)"***");
                }
                this.listener = observable -> stringProperty.bind((ObservableValue)this.getItem().getObservable());
                booleanExpression.addListener(this.listener);
            }
        }
    }

    @Override
    protected void onClose(Context context) {
        Labeled labeled = context.getContainer(Labeled.class);
        if (labeled != null) {
            StringProperty stringProperty;
            BooleanExpression booleanExpression = this.getItem().getAvailable();
            if (this.listener != null) {
                booleanExpression.removeListener(this.listener);
            }
            if ((stringProperty = labeled.textProperty()).isBound()) {
                stringProperty.unbind();
            }
        }
    }
}

