/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.StringDataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractAugmentorObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="textItem")
public class TooltipTray
extends AbstractAugmentorObject {
    private final ObjectProperty<StringDataObject> textItemProperty = new SimpleObjectProperty();
    private final ObjectProperty<Tooltip> tooltipProperty = new SimpleObjectProperty();

    public StringDataObject getTextItem() {
        return (StringDataObject)this.textItemProperty.get();
    }

    public void setTextItem(StringDataObject stringDataObject) {
        this.textItemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> textItemProperty() {
        return this.textItemProperty;
    }

    public Tooltip getTooltip() {
        return (Tooltip)this.tooltipProperty.get();
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltipProperty.set((Object)tooltip);
    }

    public ObjectProperty<Tooltip> tooltipProperty() {
        return this.tooltipProperty;
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return TooltipTray.class;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getTextItem());
    }

    @Override
    protected void onInit(Context context) {
        Node node = context.getContainer(Node.class);
        Tooltip tooltip = this.getTooltip();
        if (tooltip == null) {
            tooltip = new Tooltip();
        }
        if (node instanceof Control) {
            ((Control)node).setTooltip(tooltip);
        } else {
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }
        this.monitorText(tooltip);
    }

    private void monitorText(Tooltip tooltip) {
        ObservableStringValue observableStringValue = this.getTextItem().getObservable();
        tooltip.setText((String)observableStringValue.get());
        observableStringValue.addListener((observableValue, string, string2) -> tooltip.setText(string2));
    }
}

