/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;

public abstract class ObjectFactory {
    private ConnectionInfo m_info;
    private ConnectionType m_type;
    private Map<String, Object> m_globalBinds;
    private String m_navType;

    public static void setDefaultFactoryClass(Class<? extends ObjectFactory> clazz) {
        ObjectFactoryRegistry.getDatabaseNavigatorRegistry().setDefaultFactoryClass(clazz);
    }

    public static final ObjectFactory getFactory(String string, Connection connection) {
        return ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(string, connection);
    }

    public static void registerRecognizer(ConnectionRecognizer connectionRecognizer) {
        ObjectFactoryRegistry.getDatabaseNavigatorRegistry().registerRecognizer(connectionRecognizer);
    }

    public static void unregisterRecognizer(ConnectionRecognizer connectionRecognizer) {
        ObjectFactoryRegistry.getDatabaseNavigatorRegistry().unregisterRecognizer(connectionRecognizer);
    }

    public static ConnectionInfo createConnectionInfo(String string, Connection connection) {
        return ObjectFactoryRegistry.getDatabaseNavigatorRegistry().createConnectionInfo(string, connection);
    }

    protected ObjectFactory(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        this.m_info = connectionInfo;
        this.m_type = connectionType;
    }

    final void setNavigatorType(String string) {
        this.m_navType = string;
    }

    protected final String getNavigatorType() {
        return this.m_navType;
    }

    public Map<String, Object> getGlobalBindMap() {
        return this.m_globalBinds != null ? new HashMap<String, Object>(this.m_globalBinds) : new HashMap();
    }

    public void setGlobalBindMap(Map<String, Object> map) {
        this.m_globalBinds = map != null ? new HashMap<String, Object>(map) : null;
    }

    public final String getSchema() {
        return this.m_info.getSchema();
    }

    public final Version getVersion() {
        return this.m_info.getVersion();
    }

    public final Connection getConnection() {
        return this.m_info.getConnection();
    }

    public final ConnectionIdentifier getConnectionID() {
        return DefaultConnectionIdentifier.createIdentifier((String)this.m_info.getConnectionName(), (Connection)this.m_info.getConnection());
    }

    public String getConnectionType() {
        return this.m_info.getConnectionType();
    }

    public final String getConnectionName() {
        return this.m_info.getConnectionName();
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return this.m_type.isShowAllSchemasAtTopLevel();
    }

    public boolean isShowOtherSchemas() {
        return this.m_type.isOtherSchemasSupported();
    }

    public boolean isSupportsCatalog() {
        return this.m_type.isSupportsCatalog();
    }

    protected ConnectionInfo getConnectionInfo() {
        return this.m_info;
    }

    public ConnectionType getConnectionTypeDescriptor() {
        return this.m_type;
    }

    public ObjectType getObjectType(String string) {
        ObjectType objectType = null;
        for (ObjectType objectType2 : this.listTypes()) {
            if (!ModelUtil.areEqual((Object)objectType2.getType(), (Object)string)) continue;
            objectType = objectType2;
            break;
        }
        return objectType;
    }

    public abstract ObjectType[] listTypes();

    public final ObjectType[] listTypes(String string) {
        return this.listTypesImpl(string);
    }

    protected ObjectType[] listTypesImpl(String string) {
        return new ObjectType[0];
    }

    public ObjectCategory[] listCategories(String string) {
        return new ObjectCategory[0];
    }

    public CategoryInstance createCategoryInstance(ObjectCategory objectCategory) {
        return null;
    }

    public ObjectCategory getParentCategoryForType(String string) {
        return null;
    }

    public ObjectCategory getParentCategoryForCategory(String string) {
        return null;
    }

    public abstract DatabaseObject getObjectDescriptor(String var1);

    public abstract DBFolderInstance createFolderInstance(String var1, DatabaseFolder var2);

    public abstract DBObjectInstance createNodeInstance(String var1);

    public abstract DBChildInstance createChildInstance(String var1, String var2);

    public abstract DBSchemasInstance getSchemasInstance(DBCatalogInstance var1);

    public abstract DBSchemaInstance createSchemaInstance(String var1);

    public abstract DBCatalogsInstance getCatalogsInstance();

    public abstract DBCatalogInstance createCatalogInstance(String var1);
}

